/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Dependency.
 * 
 * @version $Revision$ $Date$
 */
public class Dependency
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the repository content.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the repository content.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The version of the repository content.
     *           
     */
    private String version;

    /**
     * 
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts that belong to the same POM but
     *             were built differently, and is appended to the
     * filename after the version. For example,
     *             <code>jdk14</code> and <code>jdk15</code>.
     *           
     */
    private String classifier = "";

    /**
     * 
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it usually represents the extension
     * on
     *             the filename of the dependency, that is not
     * always the case. A type can be mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code> and
     * <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *           
     */
    private String type = "jar";

    /**
     * True if the dependency is only here due a transitive
     * resolution.
     */
    private boolean transitive = false;

    /**
     * True if the dependency is only here due a parent pom.
     */
    private boolean fromParent = false;

    /**
     * 
     *             This url will be provided to the user if the jar
     * file cannot be downloaded
     *             from the central repository.
     *           
     */
    private String url;

    /**
     * 
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     * <code>test</code>,
     *             <code>system</code>, and <code>provided</code>.
     * Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on. It also assists in
     * determining
     *             which artifacts to include in a distribution of
     * this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     */
    private String scope;

    /**
     * 
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b> and may be replaced in later
     *             versions. This specifies the path on the
     * filesystem for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *           
     */
    private String systemPath;

    /**
     * Field exclusions.
     */
    private java.util.List<Exclusion> exclusions;

    /**
     * 
     *             Indicates the dependency is optional for use of
     * this library. While the version of the dependency will be
     *             taken into account for dependency calculation if
     * the library is used elsewhere, it will not be passed on
     *             transitively.
     *           
     */
    private boolean optional = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion.
     * 
     * @param exclusion
     */
    public void addExclusion( Exclusion exclusion )
    {
        if ( !(exclusion instanceof Exclusion) )
        {
            throw new ClassCastException( "Dependency.addExclusions(exclusion) parameter must be instanceof " + Exclusion.class.getName() );
        }
        getExclusions().add( exclusion );
    } //-- void addExclusion( Exclusion )

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get 
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts that belong to the same POM but
     *             were built differently, and is appended to the
     * filename after the version. For example,
     *             <code>jdk14</code> and <code>jdk15</code>.
     *           
     * 
     * @return String
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier()

    /**
     * Method getExclusions.
     * 
     * @return List
     */
    public java.util.List<Exclusion> getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList<Exclusion>();
        }

        return this.exclusions;
    } //-- java.util.List<Exclusion> getExclusions()

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get 
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     * <code>test</code>,
     *             <code>system</code>, and <code>provided</code>.
     * Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on. It also assists in
     * determining
     *             which artifacts to include in a distribution of
     * this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     * 
     * @return String
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope()

    /**
     * Get 
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b> and may be replaced in later
     *             versions. This specifies the path on the
     * filesystem for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *           
     * 
     * @return String
     */
    public String getSystemPath()
    {
        return this.systemPath;
    } //-- String getSystemPath()

    /**
     * Get 
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it usually represents the extension
     * on
     *             the filename of the dependency, that is not
     * always the case. A type can be mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code> and
     * <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *           
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Get 
     *             This url will be provided to the user if the jar
     * file cannot be downloaded
     *             from the central repository.
     *           
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get 
     *             The version of the repository content.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get true if the dependency is only here due a parent pom.
     * 
     * @return boolean
     */
    public boolean isFromParent()
    {
        return this.fromParent;
    } //-- boolean isFromParent()

    /**
     * Get 
     *             Indicates the dependency is optional for use of
     * this library. While the version of the dependency will be
     *             taken into account for dependency calculation if
     * the library is used elsewhere, it will not be passed on
     *             transitively.
     *           
     * 
     * @return boolean
     */
    public boolean isOptional()
    {
        return this.optional;
    } //-- boolean isOptional()

    /**
     * Get true if the dependency is only here due a transitive
     * resolution.
     * 
     * @return boolean
     */
    public boolean isTransitive()
    {
        return this.transitive;
    } //-- boolean isTransitive()

    /**
     * Method removeExclusion.
     * 
     * @param exclusion
     */
    public void removeExclusion( Exclusion exclusion )
    {
        if ( !(exclusion instanceof Exclusion) )
        {
            throw new ClassCastException( "Dependency.removeExclusions(exclusion) parameter must be instanceof " + Exclusion.class.getName() );
        }
        getExclusions().remove( exclusion );
    } //-- void removeExclusion( Exclusion )

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts that belong to the same POM but
     *             were built differently, and is appended to the
     * filename after the version. For example,
     *             <code>jdk14</code> and <code>jdk15</code>.
     *           
     * 
     * @param classifier
     */
    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    } //-- void setClassifier( String )

    /**
     * Set 
     *             Lists a set of artifacts that should be excluded
     * from this dependency's artifact list when it comes to
     *             calculating transitive dependencies.
     *           
     * 
     * @param exclusions
     */
    public void setExclusions( java.util.List<Exclusion> exclusions )
    {
        this.exclusions = exclusions;
    } //-- void setExclusions( java.util.List )

    /**
     * Set true if the dependency is only here due a parent pom.
     * 
     * @param fromParent
     */
    public void setFromParent( boolean fromParent )
    {
        this.fromParent = fromParent;
    } //-- void setFromParent( boolean )

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             Indicates the dependency is optional for use of
     * this library. While the version of the dependency will be
     *             taken into account for dependency calculation if
     * the library is used elsewhere, it will not be passed on
     *             transitively.
     *           
     * 
     * @param optional
     */
    public void setOptional( boolean optional )
    {
        this.optional = optional;
    } //-- void setOptional( boolean )

    /**
     * Set 
     *             The scope of the dependency -
     * <code>compile</code>, <code>runtime</code>,
     * <code>test</code>,
     *             <code>system</code>, and <code>provided</code>.
     * Used to
     *             calculate the various classpaths used for
     * compilation, testing, and so on. It also assists in
     * determining
     *             which artifacts to include in a distribution of
     * this project. For more information, see
     *             <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a>.
     *             
     *           
     * 
     * @param scope
     */
    public void setScope( String scope )
    {
        this.scope = scope;
    } //-- void setScope( String )

    /**
     * Set 
     *             FOR SYSTEM SCOPE ONLY. Note that use of this
     * property is <b>discouraged</b> and may be replaced in later
     *             versions. This specifies the path on the
     * filesystem for this dependency.
     *             Requires an absolute path for the value, not
     * relative.
     *             Use a property that gives the machine specific
     * absolute path,
     *             e.g. <code>${java.home}</code>.
     *           
     * 
     * @param systemPath
     */
    public void setSystemPath( String systemPath )
    {
        this.systemPath = systemPath;
    } //-- void setSystemPath( String )

    /**
     * Set true if the dependency is only here due a transitive
     * resolution.
     * 
     * @param transitive
     */
    public void setTransitive( boolean transitive )
    {
        this.transitive = transitive;
    } //-- void setTransitive( boolean )

    /**
     * Set 
     *             The type of dependency. This defaults to
     * <code>jar</code>. While it usually represents the extension
     * on
     *             the filename of the dependency, that is not
     * always the case. A type can be mapped to a different
     *             extension and a classifier.
     *             The type often correspongs to the packaging
     * used, though this is also not always the case.
     *             Some examples are <code>jar</code>,
     * <code>war</code>, <code>ejb-client</code> and
     * <code>test-jar</code>.
     *             New types can be defined by plugins that set
     *             <code>extensions</code> to <code>true</code>, so
     * this is not a complete list.
     *           
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    /**
     * Set 
     *             This url will be provided to the user if the jar
     * file cannot be downloaded
     *             from the central repository.
     *           
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )


    private static final long serialVersionUID = -5401218809636164002L;
          
    public String toString()
    {
        return Dependency.toKey( this );
    }          
          
    public static String toKey( Dependency dep )
    {
        StringBuffer key = new StringBuffer();

        key.append( dep.getGroupId() ).append( ":" );
        key.append( dep.getArtifactId() ).append( ":" );
        key.append( dep.getVersion() ).append( ":" );
        if ( dep.getClassifier() != null )
        {
            key.append( dep.getClassifier() );
        }
        key.append( ":" );
        key.append( dep.getType() );

        return key.toString();
    }

    public static String toVersionlessKey( Dependency dep )
    {
        StringBuffer key = new StringBuffer();

        key.append( dep.getGroupId() ).append( ":" );
        key.append( dep.getArtifactId() ).append( ":" );
        if ( dep.getClassifier() != null )
        {
            key.append( dep.getClassifier() );
        }
        key.append( ":" );
        key.append( dep.getType() );

        return key.toString();
    }
          
}
