/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.model;

import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.model.ArchivaArtifactModel;
import org.apache.archiva.model.ArchivaArtifactPlatformDetails;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.Keys;
import org.apache.commons.lang.StringUtils;

public class ArchivaArtifact {
    private ArchivaArtifactModel model;
    private ArchivaArtifactPlatformDetails platformDetails;
    private String baseVersion;

    public ArchivaArtifact(String groupId, String artifactId, String version, String classifier, String type, String repositoryId) {
        if (this.empty(groupId)) {
            throw new IllegalArgumentException("Unable to create ArchivaArtifact with empty groupId [" + Keys.toKey(groupId, artifactId, version, classifier, type) + "]");
        }
        if (this.empty(artifactId)) {
            throw new IllegalArgumentException("Unable to create ArchivaArtifact with empty artifactId [" + Keys.toKey(groupId, artifactId, version, classifier, type) + "]");
        }
        if (this.empty(version)) {
            throw new IllegalArgumentException("Unable to create ArchivaArtifact with empty version [" + Keys.toKey(groupId, artifactId, version, classifier, type) + "]");
        }
        if (this.empty(type)) {
            throw new IllegalArgumentException("Unable to create ArchivaArtifact with empty type [" + Keys.toKey(groupId, artifactId, version, classifier, type) + "]");
        }
        if (this.empty(repositoryId)) {
            throw new IllegalArgumentException("Unable to create ArchivaArtifact with empty repositoryId [" + Keys.toKey(groupId, artifactId, version, classifier, type) + "]");
        }
        this.model = new ArchivaArtifactModel();
        this.model.setGroupId(groupId);
        this.model.setArtifactId(artifactId);
        this.model.setVersion(version);
        this.model.setClassifier(StringUtils.defaultString((String)classifier));
        this.model.setType(type);
        this.model.setSnapshot(VersionUtil.isSnapshot((String)version));
        this.model.setRepositoryId(repositoryId);
        this.baseVersion = VersionUtil.getBaseVersion((String)version);
    }

    public ArchivaArtifact(ArchivaArtifactModel artifactModel) {
        this.model = artifactModel;
        this.model.setSnapshot(VersionUtil.isSnapshot((String)this.model.getVersion()));
        this.baseVersion = VersionUtil.getBaseVersion((String)this.model.getVersion());
    }

    public ArchivaArtifact(ArtifactReference ref, String repositoryId) {
        this(ref.getGroupId(), ref.getArtifactId(), ref.getVersion(), ref.getClassifier(), ref.getType(), repositoryId);
    }

    public ArchivaArtifactModel getModel() {
        return this.model;
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public boolean isSnapshot() {
        return this.model.isSnapshot();
    }

    public String getClassifier() {
        return this.model.getClassifier();
    }

    public String getType() {
        return this.model.getType();
    }

    public boolean hasClassifier() {
        return StringUtils.isNotEmpty((String)this.model.getClassifier());
    }

    public String getRepositoryId() {
        return this.model.getRepositoryId();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        if (this.model != null) {
            result = 31 * result + (this.model.getGroupId() == null ? 0 : this.model.getGroupId().hashCode());
            result = 31 * result + (this.model.getArtifactId() == null ? 0 : this.model.getArtifactId().hashCode());
            result = 31 * result + (this.model.getVersion() == null ? 0 : this.model.getVersion().hashCode());
            result = 31 * result + (this.model.getClassifier() == null ? 0 : this.model.getClassifier().hashCode());
            result = 31 * result + (this.model.getType() == null ? 0 : this.model.getType().hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchivaArtifact other = (ArchivaArtifact)obj;
        if (this.model == null && other.model != null) {
            return false;
        }
        return this.model.equals(other.model);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.model.getGroupId() != null) {
            sb.append(this.model.getGroupId());
            sb.append(":");
        }
        this.appendArtifactTypeClassifierString(sb);
        sb.append(":");
        if (this.model.getVersion() != null) {
            sb.append(this.model.getVersion());
        }
        return sb.toString();
    }

    private void appendArtifactTypeClassifierString(StringBuffer sb) {
        sb.append(this.model.getArtifactId());
        sb.append(":");
        sb.append(this.getType());
        if (this.hasClassifier()) {
            sb.append(":");
            sb.append(this.getClassifier());
        }
    }

    private boolean empty(String value) {
        return value == null || value.trim().length() < 1;
    }

    public ArchivaArtifactPlatformDetails getPlatformDetails() {
        return this.platformDetails;
    }

    public void setPlatformDetails(ArchivaArtifactPlatformDetails platformDetails) {
        this.platformDetails = platformDetails;
    }
}

