/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.model;

import java.io.Serializable;

public class ArtifactReference
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private static final long serialVersionUID = -6116764846682178732L;

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private static String defaultString(String value) {
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static String toKey(ArtifactReference artifactReference) {
        StringBuffer key = new StringBuffer();
        key.append(ArtifactReference.defaultString(artifactReference.getGroupId())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getArtifactId())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getVersion())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getClassifier())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getType()));
        return key.toString();
    }

    public static String toVersionlessKey(ArtifactReference artifactReference) {
        StringBuffer key = new StringBuffer();
        key.append(ArtifactReference.defaultString(artifactReference.getGroupId())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getArtifactId())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getClassifier())).append(":");
        key.append(ArtifactReference.defaultString(artifactReference.getType()));
        return key.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactReference other = (ArtifactReference)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

