/*
 * $Id$
 */

package org.apache.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A reference to another (unversioned) Project.
 * 
 * @version $Revision$ $Date$
 */
public class ProjectReference
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the project reference.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the project reference.
     *           
     */
    private String artifactId;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Artifact ID of the project reference.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get 
     *             The Group ID of the project reference.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Set 
     *             The Artifact ID of the project reference.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The Group ID of the project reference.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )


    private static final long serialVersionUID = 8947981859537138991L;
          
    private static String defaultString( String value )
    {
        if ( value == null )
        {
            return "";
        }
        
        return value.trim();
    }
          
    public static String toKey( ProjectReference reference )
    {
        StringBuilder key = new StringBuilder();

        key.append( defaultString( reference.getGroupId() ) ).append( ":" );
        key.append( defaultString( reference.getArtifactId() ) );

        return key.toString();
    }
          
}
