/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.reporting;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.ArtifactsByRepositoryConstraint;
import org.apache.maven.archiva.model.RepositoryContentStatistics;
import org.apache.maven.archiva.reporting.ArchivaReportException;
import org.apache.maven.archiva.reporting.DataLimits;
import org.apache.maven.archiva.reporting.RepositoryStatistics;
import org.apache.maven.archiva.reporting.RepositoryStatisticsReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepositoryStatisticsReportGenerator
implements RepositoryStatisticsReportGenerator {
    private Logger log = LoggerFactory.getLogger(SimpleRepositoryStatisticsReportGenerator.class);
    private ArchivaDAO dao;

    @Override
    public List<RepositoryStatistics> generateReport(List<RepositoryContentStatistics> repoContentStats, String repository, Date startDate, Date endDate, DataLimits limits) throws ArchivaReportException {
        if (limits.getCurrentPage() > limits.getCountOfPages()) {
            throw new ArchivaReportException("The requested page exceeds the total number of pages.");
        }
        int start = limits.getPerPageCount() * limits.getCurrentPage() - limits.getPerPageCount();
        int end = start + limits.getPerPageCount() - 1;
        if (end > repoContentStats.size()) {
            end = repoContentStats.size() - 1;
        }
        return this.constructRepositoryStatistics(repoContentStats, repository, endDate, start, end);
    }

    @Override
    public List<RepositoryStatistics> generateReport(List<RepositoryContentStatistics> repoContentStats, String repository, Date startDate, Date endDate, boolean firstStatsOnly) throws ArchivaReportException {
        if (firstStatsOnly) {
            return this.constructRepositoryStatistics(repoContentStats, repository, endDate, 0, 0);
        }
        return this.constructRepositoryStatistics(repoContentStats, repository, endDate, 0, repoContentStats.size() - 1);
    }

    private List<RepositoryStatistics> constructRepositoryStatistics(List<RepositoryContentStatistics> repoContentStats, String repository, Date endDate, int start, int end) {
        ArtifactDAO artifactDao = this.dao.getArtifactDAO();
        ArrayList<RepositoryStatistics> repoStatisticsList = new ArrayList<RepositoryStatistics>();
        for (int i = start; i <= end; ++i) {
            RepositoryContentStatistics repoContentStat = repoContentStats.get(i);
            RepositoryStatistics repoStatistics = new RepositoryStatistics();
            repoStatistics.setRepositoryId(repository);
            repoStatistics.setArtifactCount(repoContentStat.getTotalArtifactCount());
            repoStatistics.setGroupCount(repoContentStat.getTotalGroupCount());
            repoStatistics.setProjectCount(repoContentStat.getTotalProjectCount());
            repoStatistics.setTotalSize(repoContentStat.getTotalSize());
            repoStatistics.setFileCount(repoContentStat.getTotalFileCount());
            repoStatistics.setDateOfScan(repoContentStat.getWhenGathered());
            try {
                List types = artifactDao.queryArtifacts((Constraint)new ArtifactsByRepositoryConstraint(repository, "jar", endDate, "whenGathered"));
                repoStatistics.setJarCount(types.size());
                types = artifactDao.queryArtifacts((Constraint)new ArtifactsByRepositoryConstraint(repository, "war", endDate, "whenGathered"));
                repoStatistics.setWarCount(types.size());
                types = artifactDao.queryArtifacts((Constraint)new ArtifactsByRepositoryConstraint(repository, "maven-plugin", endDate, "whenGathered"));
                repoStatistics.setPluginCount(types.size());
            }
            catch (ArchivaDatabaseException e) {
                this.log.error("Error occurred while querying artifacts from the database.", (Object)e.getMessage());
            }
            repoStatisticsList.add(repoStatistics);
        }
        return repoStatisticsList;
    }

    public void setDao(ArchivaDAO dao) {
        this.dao = dao;
    }
}

