/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled;

import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.codehaus.plexus.scheduler.AbstractJob;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RepositoryTaskJob
extends AbstractJob {
    static final String TASK_KEY = "EXECUTION";
    static final String TASK_QUEUE = "TASK_QUEUE";
    static final String TASK_QUEUE_POLICY = "TASK_QUEUE_POLICY";
    static final String TASK_REPOSITORY = "TASK_REPOSITORY";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        this.setJobDataMap(dataMap);
        TaskQueue taskQueue = (TaskQueue)dataMap.get((Object)TASK_QUEUE);
        String queuePolicy = dataMap.get((Object)TASK_QUEUE_POLICY).toString();
        RepositoryTask task = new RepositoryTask();
        task.setName(context.getJobDetail().getName());
        task.setRepositoryId((String)dataMap.get((Object)TASK_REPOSITORY));
        try {
            if (taskQueue.getQueueSnapshot().size() == 0) {
                taskQueue.put((Task)task);
                return;
            }
            if ("wait".equals(queuePolicy)) {
                taskQueue.put((Task)task);
                return;
            }
            if (!"skip".equals(queuePolicy)) return;
        }
        catch (TaskQueueException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }
}

