/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.executors;

import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.updater.DatabaseUpdater;
import org.apache.maven.archiva.scheduled.tasks.DatabaseTask;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivaDatabaseUpdateTaskExecutor
implements TaskExecutor,
Initializable {
    private Logger log = LoggerFactory.getLogger(ArchivaDatabaseUpdateTaskExecutor.class);
    private DatabaseUpdater databaseUpdater;

    public void initialize() throws InitializationException {
        this.log.info("Initialized " + this.getClass().getName());
    }

    public void executeTask(Task task) throws TaskExecutionException {
        DatabaseTask dbtask = (DatabaseTask)task;
        this.log.info("Executing task from queue with job name: " + dbtask.getName());
        long time = System.currentTimeMillis();
        try {
            this.log.info("Task: Updating unprocessed artifacts");
            this.databaseUpdater.updateAllUnprocessed();
        }
        catch (ArchivaDatabaseException e) {
            throw new TaskExecutionException("Error running unprocessed updater", (Throwable)e);
        }
        try {
            this.log.info("Task: Updating processed artifacts");
            this.databaseUpdater.updateAllProcessed();
        }
        catch (ArchivaDatabaseException e) {
            throw new TaskExecutionException("Error running processed updater", (Throwable)e);
        }
        time = System.currentTimeMillis() - time;
        this.log.info("Finished database task in " + time + "ms.");
    }
}

