/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.executors;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.SimpleConstraint;
import org.apache.maven.archiva.database.constraints.MostRecentRepositoryScanStatistics;
import org.apache.maven.archiva.model.RepositoryContentStatistics;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.maven.archiva.repository.scanner.RepositoryScanner;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivaRepositoryScanningTaskExecutor
implements TaskExecutor,
Initializable {
    private Logger log = LoggerFactory.getLogger(ArchivaRepositoryScanningTaskExecutor.class);
    private ArchivaDAO dao;
    private ArchivaConfiguration archivaConfiguration;
    private RepositoryScanner repoScanner;

    public void initialize() throws InitializationException {
        this.log.info("Initialized " + this.getClass().getName());
    }

    public void executeTask(Task task) throws TaskExecutionException {
        RepositoryTask repoTask = (RepositoryTask)task;
        if (StringUtils.isBlank((String)repoTask.getRepositoryId())) {
            throw new TaskExecutionException("Unable to execute RepositoryTask with blank repository Id.");
        }
        this.log.info("Executing task from queue with job name: " + repoTask.getName());
        try {
            ManagedRepositoryConfiguration arepo = this.archivaConfiguration.getConfiguration().findManagedRepositoryById(repoTask.getRepositoryId());
            if (arepo == null) {
                throw new TaskExecutionException("Unable to execute RepositoryTask with invalid repository id: " + repoTask.getRepositoryId());
            }
            long sinceWhen = 0L;
            List results = this.dao.query((SimpleConstraint)new MostRecentRepositoryScanStatistics(arepo.getId()));
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                RepositoryContentStatistics lastStats = (RepositoryContentStatistics)results.get(0);
                sinceWhen = lastStats.getWhenGathered().getTime() + lastStats.getDuration();
            }
            RepositoryScanStatistics stats = this.repoScanner.scan(arepo, sinceWhen);
            this.log.info("Finished repository task: " + stats.toDump(arepo));
            RepositoryContentStatistics dbstats = new RepositoryContentStatistics();
            dbstats.setDuration(stats.getDuration());
            dbstats.setNewFileCount(stats.getNewFileCount());
            dbstats.setRepositoryId(stats.getRepositoryId());
            dbstats.setTotalFileCount(stats.getTotalFileCount());
            dbstats.setWhenGathered(stats.getWhenGathered());
            this.dao.getRepositoryContentStatisticsDAO().saveRepositoryContentStatistics(dbstats);
        }
        catch (RepositoryException e) {
            throw new TaskExecutionException("Repository error when executing repository job.", (Throwable)e);
        }
    }
}

