/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled;

import org.apache.maven.archiva.scheduled.tasks.DatabaseTask;
import org.codehaus.plexus.scheduler.AbstractJob;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DatabaseTaskJob
extends AbstractJob {
    static final String TASK_KEY = "EXECUTION";
    static final String TASK_QUEUE = "TASK_QUEUE";
    static final String TASK_QUEUE_POLICY = "TASK_QUEUE_POLICY";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        this.setJobDataMap(dataMap);
        TaskQueue taskQueue = (TaskQueue)dataMap.get((Object)TASK_QUEUE);
        String queuePolicy = (String)dataMap.get((Object)TASK_QUEUE_POLICY);
        DatabaseTask task = new DatabaseTask();
        task.setName(context.getJobDetail().getName());
        try {
            if (taskQueue.getQueueSnapshot().size() == 0) {
                taskQueue.put((Task)task);
                return;
            }
            if ("wait".equals(queuePolicy)) {
                taskQueue.put((Task)task);
                return;
            }
            if (!"skip".equals(queuePolicy)) return;
        }
        catch (TaskQueueException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }
}

