/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.executors;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.DefaultArtifactContextProducer;
import org.sonatype.nexus.index.IndexerEngine;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.DefaultIndexingContext;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.packer.IndexPacker;
import org.sonatype.nexus.index.packer.IndexPackingRequest;

public class ArchivaIndexingTaskExecutor
implements TaskExecutor,
Initializable {
    private Logger log = LoggerFactory.getLogger(ArchivaIndexingTaskExecutor.class);
    private IndexerEngine indexerEngine;
    private ArchivaConfiguration archivaConfiguration;
    private IndexPacker indexPacker;
    private ArtifactContextProducer artifactContextProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(Task task) throws TaskExecutionException {
        IndexerEngine indexerEngine = this.indexerEngine;
        synchronized (indexerEngine) {
            ArtifactIndexingTask indexingTask = (ArtifactIndexingTask)task;
            ManagedRepositoryConfiguration repository = this.archivaConfiguration.getConfiguration().findManagedRepositoryById(indexingTask.getRepositoryId());
            String indexDir = repository.getIndexDir();
            File managedRepository = new File(repository.getLocation());
            File indexDirectory = null;
            indexDirectory = indexDir != null && !"".equals(indexDir) ? new File(repository.getIndexDir()) : new File(managedRepository, ".indexer");
            DefaultIndexingContext context = null;
            try {
                context = new DefaultIndexingContext(repository.getId(), repository.getId(), managedRepository, indexDirectory, null, null, NexusIndexer.FULL_INDEX, false);
                context.setSearchable(repository.isScanned());
                File artifactFile = indexingTask.getResourceFile();
                ArtifactContext ac = this.artifactContextProducer.getArtifactContext((IndexingContext)context, artifactFile);
                if (ac != null) {
                    if (indexingTask.getAction().equals("add")) {
                        boolean add = true;
                        IndexReader r = context.getIndexReader();
                        for (int i = 0; i < r.numDocs(); ++i) {
                            if (r.isDeleted(i)) continue;
                            Document d = r.document(i);
                            String uinfo = d.get("u");
                            if (!ac.getArtifactInfo().getUinfo().equals(uinfo)) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            this.log.debug("Adding artifact '" + ac.getArtifactInfo() + "' to index..");
                            this.indexerEngine.index((IndexingContext)context, ac);
                            context.optimize();
                        } else {
                            this.log.debug("Updating artifact '" + ac.getArtifactInfo() + "' in index..");
                            this.indexerEngine.update((IndexingContext)context, ac);
                            context.optimize();
                        }
                    } else {
                        this.log.debug("Removing artifact '" + ac.getArtifactInfo() + "' from index..");
                        this.indexerEngine.remove((IndexingContext)context, ac);
                        context.optimize();
                    }
                    File indexLocation = new File(managedRepository, ".index");
                    IndexPackingRequest request = new IndexPackingRequest((IndexingContext)context, indexLocation);
                    this.indexPacker.packIndex(request);
                    this.log.debug("Index file packaged at '" + indexLocation.getPath() + "'.");
                }
            }
            catch (IOException e) {
                this.log.error("Error occurred while executing indexing task '" + indexingTask.getName() + "'");
                throw new TaskExecutionException("Error occurred while executing indexing task '" + indexingTask.getName() + "'");
            }
            catch (UnsupportedExistingLuceneIndexException e) {
                this.log.error("Unsupported Lucene index format: " + e.getMessage());
                throw new TaskExecutionException("Unsupported Lucene index format: " + e.getMessage());
            }
            finally {
                if (context != null) {
                    try {
                        context.close(false);
                    }
                    catch (IOException e) {
                        this.log.error("Error occurred while closing context: " + e.getMessage());
                        throw new TaskExecutionException("Error occurred while closing context: " + e.getMessage());
                    }
                }
            }
        }
    }

    public void initialize() throws InitializationException {
        this.log.info("Initialized " + this.getClass().getName());
        this.artifactContextProducer = new DefaultArtifactContextProducer();
    }

    public void setIndexerEngine(IndexerEngine indexerEngine) {
        this.indexerEngine = indexerEngine;
    }

    public void setIndexPacker(IndexPacker indexPacker) {
        this.indexPacker = indexPacker;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }
}

