/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.tasks;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;

public class TaskCreator {
    public static RepositoryTask createRepositoryTask(String repositoryId, String taskNameSuffix) {
        String suffix = "";
        if (!StringUtils.isEmpty((String)taskNameSuffix)) {
            suffix = ":" + taskNameSuffix;
        }
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setName("repository-job:" + repositoryId + suffix);
        task.setQueuePolicy("wait");
        return task;
    }

    public static RepositoryTask createRepositoryTask(String repositoryId, String taskNameSuffix, File resourceFile, boolean updateRelatedArtifacts) {
        RepositoryTask task = TaskCreator.createRepositoryTask(repositoryId, taskNameSuffix);
        task.setResourceFile(resourceFile);
        task.setUpdateRelatedArtifacts(updateRelatedArtifacts);
        return task;
    }

    public static ArtifactIndexingTask createIndexingTask(String repositoryId, File resource, String action) {
        ArtifactIndexingTask task = new ArtifactIndexingTask();
        task.setRepositoryId(repositoryId);
        task.setName("indexing-job:" + repositoryId + ":" + resource.getName() + ":" + action);
        task.setAction(action);
        task.setQueuePolicy("wait");
        task.setResourceFile(resource);
        return task;
    }
}

