/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.DefaultIndexingContext;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

public class TaskCreator {
    public static RepositoryTask createRepositoryTask(String repositoryId) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        return task;
    }

    public static RepositoryTask createRepositoryTask(String repositoryId, boolean scanAll) {
        RepositoryTask task = TaskCreator.createRepositoryTask(repositoryId);
        task.setScanAll(scanAll);
        return task;
    }

    public static RepositoryTask createRepositoryTask(String repositoryId, File resourceFile, boolean updateRelatedArtifacts) {
        RepositoryTask task = TaskCreator.createRepositoryTask(repositoryId);
        task.setResourceFile(resourceFile);
        task.setUpdateRelatedArtifacts(updateRelatedArtifacts);
        return task;
    }

    public static RepositoryTask createRepositoryTask(String repositoryId, File resourceFile, boolean updateRelatedArtifacts, boolean scanAll) {
        RepositoryTask task = TaskCreator.createRepositoryTask(repositoryId, resourceFile, updateRelatedArtifacts);
        task.setScanAll(scanAll);
        return task;
    }

    public static ArtifactIndexingTask createIndexingTask(ManagedRepositoryConfiguration repository, File resource, ArtifactIndexingTask.Action action, IndexingContext context) {
        return new ArtifactIndexingTask(repository, resource, action, context);
    }

    public static IndexingContext createContext(ManagedRepositoryConfiguration repository) throws IOException, UnsupportedExistingLuceneIndexException {
        String indexDir = repository.getIndexDir();
        File managedRepository = new File(repository.getLocation());
        File indexDirectory = null;
        indexDirectory = indexDir != null && !"".equals(indexDir) ? new File(repository.getIndexDir()) : new File(managedRepository, ".indexer");
        DefaultIndexingContext context = new DefaultIndexingContext(repository.getId(), repository.getId(), managedRepository, indexDirectory, null, null, NexusIndexer.FULL_INDEX, false);
        context.setSearchable(repository.isScanned());
        return context;
    }
}

