/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.tasks;

import java.io.File;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.codehaus.plexus.taskqueue.Task;
import org.sonatype.nexus.index.context.IndexingContext;

public class ArtifactIndexingTask
implements Task {
    private final ManagedRepositoryConfiguration repository;
    private final File resourceFile;
    private final Action action;
    private final IndexingContext context;

    public ArtifactIndexingTask(ManagedRepositoryConfiguration repository, File resourceFile, Action action, IndexingContext context) {
        this.repository = repository;
        this.resourceFile = resourceFile;
        this.action = action;
        this.context = context;
    }

    public long getMaxExecutionTime() {
        return 0L;
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return "ArtifactIndexingTask [action=" + (Object)((Object)this.action) + ", repositoryId=" + this.repository.getId() + ", resourceFile=" + this.resourceFile + "]";
    }

    public ManagedRepositoryConfiguration getRepository() {
        return this.repository;
    }

    public IndexingContext getContext() {
        return this.context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.action.hashCode();
        result = 31 * result + this.repository.getId().hashCode();
        result = 31 * result + (this.resourceFile == null ? 0 : this.resourceFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIndexingTask other = (ArtifactIndexingTask)obj;
        if (!this.action.equals((Object)other.action)) {
            return false;
        }
        if (!this.repository.getId().equals(other.repository.getId())) {
            return false;
        }
        return !(this.resourceFile == null ? other.resourceFile != null : !this.resourceFile.equals(other.resourceFile));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD,
        DELETE,
        FINISH;

    }
}

