/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.executors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.DeclarativeConstraint;
import org.apache.maven.archiva.database.SimpleConstraint;
import org.apache.maven.archiva.database.constraints.ArtifactsByRepositoryConstraint;
import org.apache.maven.archiva.database.constraints.MostRecentRepositoryScanStatistics;
import org.apache.maven.archiva.database.constraints.UniqueArtifactIdConstraint;
import org.apache.maven.archiva.database.constraints.UniqueGroupIdConstraint;
import org.apache.maven.archiva.model.RepositoryContentStatistics;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.maven.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.maven.archiva.repository.scanner.RepositoryScanner;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivaRepositoryScanningTaskExecutor
implements TaskExecutor,
Initializable {
    private Logger log = LoggerFactory.getLogger(ArchivaRepositoryScanningTaskExecutor.class);
    private ArchivaDAO dao;
    private ArchivaConfiguration archivaConfiguration;
    private RepositoryScanner repoScanner;
    private RepositoryContentConsumers consumers;
    private Task task;

    public void initialize() throws InitializationException {
        this.log.info("Initialized " + this.getClass().getName());
    }

    public void executeTask(Task task) throws TaskExecutionException {
        this.task = task;
        RepositoryTask repoTask = (RepositoryTask)task;
        if (StringUtils.isBlank((String)repoTask.getRepositoryId())) {
            throw new TaskExecutionException("Unable to execute RepositoryTask with blank repository Id.");
        }
        ManagedRepositoryConfiguration arepo = this.archivaConfiguration.getConfiguration().findManagedRepositoryById(repoTask.getRepositoryId());
        if (repoTask.getResourceFile() != null) {
            this.log.debug("Executing task from queue with job name: " + repoTask);
            this.consumers.executeConsumers(arepo, repoTask.getResourceFile(), repoTask.isUpdateRelatedArtifacts());
        } else {
            this.log.info("Executing task from queue with job name: " + repoTask);
            try {
                if (arepo == null) {
                    throw new TaskExecutionException("Unable to execute RepositoryTask with invalid repository id: " + repoTask.getRepositoryId());
                }
                long sinceWhen = 0L;
                List results = this.dao.query((SimpleConstraint)new MostRecentRepositoryScanStatistics(arepo.getId()));
                if (CollectionUtils.isNotEmpty((Collection)results)) {
                    RepositoryContentStatistics lastStats = (RepositoryContentStatistics)results.get(0);
                    if (!repoTask.isScanAll()) {
                        sinceWhen = lastStats.getWhenGathered().getTime() - lastStats.getDuration();
                    }
                }
                RepositoryScanStatistics stats = this.repoScanner.scan(arepo, sinceWhen);
                this.log.info("Finished repository task: " + stats.toDump(arepo));
                RepositoryContentStatistics dbstats = this.constructRepositoryStatistics(arepo, stats);
                this.dao.getRepositoryContentStatisticsDAO().saveRepositoryContentStatistics(dbstats);
                this.task = null;
            }
            catch (RepositoryException e) {
                throw new TaskExecutionException("Repository error when executing repository job.", (Throwable)e);
            }
        }
    }

    private RepositoryContentStatistics constructRepositoryStatistics(ManagedRepositoryConfiguration arepo, RepositoryScanStatistics stats) {
        RepositoryContentStatistics dbstats = new RepositoryContentStatistics();
        dbstats.setDuration(stats.getDuration());
        dbstats.setNewFileCount(stats.getNewFileCount());
        dbstats.setRepositoryId(stats.getRepositoryId());
        dbstats.setTotalFileCount(stats.getTotalFileCount());
        dbstats.setWhenGathered(stats.getWhenGathered());
        dbstats.setTotalArtifactCount(this.dao.getArtifactDAO().countArtifacts((DeclarativeConstraint)new ArtifactsByRepositoryConstraint(arepo.getId(), stats.getWhenGathered(), "groupId", true)));
        long size = FileUtils.sizeOfDirectory((File)new File(arepo.getLocation()));
        dbstats.setTotalSize(size);
        ArrayList<String> repos = new ArrayList<String>();
        repos.add(arepo.getId());
        dbstats.setTotalGroupCount(this.dao.count((SimpleConstraint)new UniqueGroupIdConstraint(repos)));
        dbstats.setTotalProjectCount(this.dao.count((SimpleConstraint)new UniqueArtifactIdConstraint(arepo.getId(), true)));
        return dbstats;
    }

    public Task getCurrentTaskInExecution() {
        return this.task;
    }
}

