/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.scheduled.executors;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.TaskCreator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.DefaultArtifactContextProducer;
import org.sonatype.nexus.index.IndexerEngine;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.packer.IndexPacker;
import org.sonatype.nexus.index.packer.IndexPackingRequest;

public class ArchivaIndexingTaskExecutor
implements TaskExecutor,
Initializable {
    private Logger log = LoggerFactory.getLogger(ArchivaIndexingTaskExecutor.class);
    private IndexerEngine indexerEngine;
    private IndexPacker indexPacker;
    private ArtifactContextProducer artifactContextProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(Task task) throws TaskExecutionException {
        IndexerEngine indexerEngine = this.indexerEngine;
        synchronized (indexerEngine) {
            ArtifactIndexingTask indexingTask = (ArtifactIndexingTask)task;
            ManagedRepositoryConfiguration repository = indexingTask.getRepository();
            IndexingContext context = indexingTask.getContext();
            if (ArtifactIndexingTask.Action.FINISH.equals((Object)indexingTask.getAction()) && indexingTask.isExecuteOnEntireRepo()) {
                this.log.debug("Finishing indexing task on repo: " + repository.getId());
                this.finishIndexingTask(indexingTask, repository, context);
            } else {
                if (!indexingTask.isExecuteOnEntireRepo()) {
                    try {
                        this.log.debug("Creating indexing context on resource: " + indexingTask.getResourceFile().getPath());
                        context = TaskCreator.createContext(repository);
                    }
                    catch (IOException e) {
                        this.log.error("Error occurred while creating context: " + e.getMessage());
                        throw new TaskExecutionException("Error occurred while creating context: " + e.getMessage());
                    }
                    catch (UnsupportedExistingLuceneIndexException e) {
                        this.log.error("Error occurred while creating context: " + e.getMessage());
                        throw new TaskExecutionException("Error occurred while creating context: " + e.getMessage());
                    }
                }
                if (context == null || context.getIndexDirectory() == null) {
                    throw new TaskExecutionException("Trying to index an artifact but the context is already closed");
                }
                try {
                    File artifactFile = indexingTask.getResourceFile();
                    ArtifactContext ac = this.artifactContextProducer.getArtifactContext(context, artifactFile);
                    if (ac != null) {
                        if (indexingTask.getAction().equals((Object)ArtifactIndexingTask.Action.ADD)) {
                            IndexSearcher s = context.getIndexSearcher();
                            String uinfo = ac.getArtifactInfo().getUinfo();
                            TopDocs d = s.search((Query)new TermQuery(new Term("u", uinfo)), 1);
                            if (d.totalHits == 0) {
                                this.log.debug("Adding artifact '" + ac.getArtifactInfo() + "' to index..");
                                this.indexerEngine.index(context, ac);
                                context.getIndexWriter().commit();
                            } else {
                                this.log.debug("Updating artifact '" + ac.getArtifactInfo() + "' in index..");
                                this.indexerEngine.update(context, ac);
                                context.getIndexWriter().commit();
                            }
                            if (!indexingTask.isExecuteOnEntireRepo()) {
                                this.log.debug("Finishing indexing task on resource file : " + indexingTask.getResourceFile().getPath());
                                this.finishIndexingTask(indexingTask, repository, context);
                            }
                        } else {
                            this.log.debug("Removing artifact '" + ac.getArtifactInfo() + "' from index..");
                            this.indexerEngine.remove(context, ac);
                            context.getIndexWriter().commit();
                        }
                    }
                }
                catch (IOException e) {
                    this.log.error("Error occurred while executing indexing task '" + indexingTask + "': " + e.getMessage());
                    throw new TaskExecutionException("Error occurred while executing indexing task '" + indexingTask + "'", (Throwable)e);
                }
            }
        }
    }

    private void finishIndexingTask(ArtifactIndexingTask indexingTask, ManagedRepositoryConfiguration repository, IndexingContext context) throws TaskExecutionException {
        try {
            context.optimize();
            File managedRepository = new File(repository.getLocation());
            File indexLocation = new File(managedRepository, ".index");
            IndexPackingRequest request = new IndexPackingRequest(context, indexLocation);
            this.indexPacker.packIndex(request);
            this.log.debug("Index file packaged at '" + indexLocation.getPath() + "'.");
        }
        catch (IOException e) {
            this.log.error("Error occurred while executing indexing task '" + indexingTask + "': " + e.getMessage());
            throw new TaskExecutionException("Error occurred while executing indexing task '" + indexingTask + "'", (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close(false);
                }
                catch (IOException e) {
                    this.log.error("Error occurred while closing context: " + e.getMessage());
                    throw new TaskExecutionException("Error occurred while closing context: " + e.getMessage());
                }
            }
        }
    }

    public void initialize() throws InitializationException {
        this.log.info("Initialized " + this.getClass().getName());
        this.artifactContextProducer = new DefaultArtifactContextProducer();
    }

    public void setIndexerEngine(IndexerEngine indexerEngine) {
        this.indexerEngine = indexerEngine;
    }

    public void setIndexPacker(IndexPacker indexPacker) {
        this.indexPacker = indexPacker;
    }
}

