/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import com.opensymphony.xwork.ActionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.repository.audit.AuditEvent;
import org.apache.maven.archiva.repository.audit.AuditListener;
import org.apache.maven.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.maven.archiva.security.ArchivaXworkUser;
import org.apache.maven.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.maven.archiva.webdav.util.IndexWriter;
import org.apache.maven.archiva.webdav.util.MimeTypes;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivaDavResource
implements DavResource {
    public static final String HIDDEN_PATH_PREFIX = ".";
    private final ArchivaDavResourceLocator locator;
    private final DavResourceFactory factory;
    private final File localResource;
    private final String logicalResource;
    private DavPropertySet properties = null;
    private LockManager lockManager;
    private final DavSession session;
    private String remoteAddr;
    private final ManagedRepositoryConfiguration repository;
    private final RepositoryContentConsumers consumers;
    private final MimeTypes mimeTypes;
    private List<AuditListener> auditListeners;

    public ArchivaDavResource(String localResource, String logicalResource, ManagedRepositoryConfiguration repository, DavSession session, ArchivaDavResourceLocator locator, DavResourceFactory factory, MimeTypes mimeTypes, List<AuditListener> auditListeners, RepositoryContentConsumers consumers) {
        this.localResource = new File(localResource);
        this.logicalResource = logicalResource;
        this.locator = locator;
        this.factory = factory;
        this.session = session;
        this.repository = repository;
        this.mimeTypes = mimeTypes;
        this.consumers = consumers;
        this.auditListeners = auditListeners;
    }

    public ArchivaDavResource(String localResource, String logicalResource, ManagedRepositoryConfiguration repository, String remoteAddr, DavSession session, ArchivaDavResourceLocator locator, DavResourceFactory factory, MimeTypes mimeTypes, List<AuditListener> auditListeners, RepositoryContentConsumers consumers) {
        this(localResource, logicalResource, repository, session, locator, factory, mimeTypes, auditListeners, consumers);
        this.remoteAddr = remoteAddr;
    }

    public String getComplianceClass() {
        return "1, 2";
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    }

    public boolean exists() {
        return this.localResource.exists();
    }

    public boolean isCollection() {
        return this.localResource.isDirectory();
    }

    public String getDisplayName() {
        String resPath = this.getResourcePath();
        return resPath != null ? Text.getName((String)resPath) : resPath;
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public File getLocalResource() {
        return this.localResource;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public long getModificationTime() {
        return this.localResource.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spool(OutputContext outputContext) throws IOException {
        block5: {
            block4: {
                if (!this.isCollection()) {
                    outputContext.setContentLength(this.localResource.length());
                    outputContext.setContentType(this.mimeTypes.getMimeType(this.localResource.getName()));
                }
                if (this.isCollection() || !outputContext.hasStream()) break block4;
                FileInputStream is = null;
                try {
                    is = new FileInputStream(this.localResource);
                    IOUtils.copy((InputStream)is, (OutputStream)outputContext.getOutputStream());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                break block5;
            }
            if (outputContext.hasStream()) {
                IndexWriter writer = new IndexWriter((DavResource)this, this.localResource, this.logicalResource);
                writer.write(outputContext);
            }
        }
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public DavProperty getProperty(DavPropertyName name) {
        return this.getProperties().get(name);
    }

    public DavPropertySet getProperties() {
        return this.initProperties();
    }

    public void setProperty(DavProperty property) throws DavException {
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        return null;
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        return null;
    }

    public DavResource getCollection() {
        DavResource parent = null;
        if (this.getResourcePath() != null && !this.getResourcePath().equals("/")) {
            String parentPath = Text.getRelativeParent((String)this.getResourcePath(), (int)1);
            if (parentPath.equals("")) {
                parentPath = "/";
            }
            DavResourceLocator parentloc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), parentPath);
            try {
                parent = this.factory.createResource(parentloc, this.session);
            }
            catch (DavException e) {
                // empty catch block
            }
        }
        return parent;
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        block9: {
            File localFile;
            block7: {
                localFile = new File(this.localResource, resource.getDisplayName());
                boolean exists = localFile.exists();
                if (!this.isCollection() || !inputContext.hasStream()) break block7;
                FileOutputStream stream = null;
                try {
                    stream = new FileOutputStream(localFile);
                    IOUtils.copy((InputStream)inputContext.getInputStream(), (OutputStream)stream);
                }
                catch (IOException e) {
                    try {
                        throw new DavException(500, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)stream);
                if (inputContext.getContentLength() != localFile.length()) {
                    FileUtils.deleteQuietly((File)localFile);
                    throw new DavException(400, "Content Header length was " + inputContext.getContentLength() + " but was " + localFile.length());
                }
                this.consumers.executeConsumers(this.repository, localFile);
                this.triggerAuditEvent(resource, exists ? "Modified File" : "Created File");
                break block9;
            }
            if (!inputContext.hasStream() && this.isCollection()) {
                localFile.mkdir();
                this.triggerAuditEvent(resource, "Created Directory");
            } else {
                throw new DavException(400, "Could not write member " + resource.getResourcePath() + " at " + this.getResourcePath());
            }
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<DavResource> list = new ArrayList<DavResource>();
        if (this.exists() && this.isCollection()) {
            for (String item : this.localResource.list()) {
                try {
                    if (item.startsWith(HIDDEN_PATH_PREFIX)) continue;
                    String path = this.locator.getResourcePath() + '/' + item;
                    DavResourceLocator resourceLocator = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), path);
                    DavResource resource = this.factory.createResource(resourceLocator, this.session);
                    if (resource == null) continue;
                    list.add(resource);
                }
                catch (DavException e) {
                    // empty catch block
                }
            }
        }
        return new DavResourceIteratorImpl(list);
    }

    public void removeMember(DavResource member) throws DavException {
        File resource = this.checkDavResourceIsArchivaDavResource(member).getLocalResource();
        if (resource.exists()) {
            try {
                if (resource.isDirectory()) {
                    FileUtils.deleteDirectory((File)resource);
                    this.triggerAuditEvent(member, "Removed Directory");
                }
                if (!resource.delete()) {
                    throw new IOException("Could not remove file");
                }
                this.triggerAuditEvent(member, "Removed File");
            }
            catch (IOException e) {
                throw new DavException(500);
            }
        } else {
            throw new DavException(404);
        }
    }

    private void triggerAuditEvent(DavResource member, String event) throws DavException {
        String path = this.logicalResource + "/" + member.getDisplayName();
        this.triggerAuditEvent(this.checkDavResourceIsArchivaDavResource((DavResource)member).remoteAddr, this.locator.getRepositoryId(), path, event);
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404, "Resource to copy does not exist.");
        }
        try {
            ArchivaDavResource resource = this.checkDavResourceIsArchivaDavResource(destination);
            if (this.isCollection()) {
                FileUtils.moveDirectory((File)this.getLocalResource(), (File)resource.getLocalResource());
                this.triggerAuditEvent(this.remoteAddr, this.locator.getRepositoryId(), this.logicalResource, "Moved Directory");
            } else {
                FileUtils.moveFile((File)this.getLocalResource(), (File)resource.getLocalResource());
                this.triggerAuditEvent(this.remoteAddr, this.locator.getRepositoryId(), this.logicalResource, "Moved File");
            }
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404, "Resource to copy does not exist.");
        }
        if (shallow && this.isCollection()) {
            throw new DavException(403, "Unable to perform shallow copy for collection");
        }
        try {
            ArchivaDavResource resource = this.checkDavResourceIsArchivaDavResource(destination);
            if (this.isCollection()) {
                FileUtils.copyDirectory((File)this.getLocalResource(), (File)resource.getLocalResource());
                this.triggerAuditEvent(this.remoteAddr, this.locator.getRepositoryId(), this.logicalResource, "Copied Directory");
            } else {
                FileUtils.copyFile((File)this.getLocalResource(), (File)resource.getLocalResource());
                this.triggerAuditEvent(this.remoteAddr, this.locator.getRepositoryId(), this.logicalResource, "Copied File");
            }
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope);
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        ActiveLock lock = null;
        if (this.exists() && Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope)) {
            lock = this.lockManager.getLock(type, scope, (DavResource)this);
        }
        return lock;
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        ActiveLock lock = null;
        if (!this.isLockable(lockInfo.getType(), lockInfo.getScope())) {
            throw new DavException(412, "Unsupported lock type or scope.");
        }
        lock = this.lockManager.createLock(lockInfo, (DavResource)this);
        return lock;
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        ActiveLock lock = this.getLock(lockInfo.getType(), lockInfo.getScope());
        if (lock == null) {
            throw new DavException(412, "No lock with the given type/scope present on resource " + this.getResourcePath());
        }
        lock = this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
        return lock;
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            throw new DavException(412);
        }
        if (!lock.isLockedByToken(lockToken)) {
            throw new DavException(423);
        }
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public DavSession getSession() {
        return this.session;
    }

    protected DavPropertySet initProperties() {
        if (!this.exists()) {
            this.properties = new DavPropertySet();
        }
        if (this.properties != null) {
            return this.properties;
        }
        DavPropertySet properties = new DavPropertySet();
        if (this.getDisplayName() != null) {
            properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        }
        if (this.isCollection()) {
            properties.add((DavProperty)new ResourceType(1));
            properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        } else {
            properties.add((DavProperty)new ResourceType(0));
            properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        DateTime dt = new DateTime(this.localResource.lastModified());
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String modifiedDate = fmt.print((ReadableInstant)dt);
        properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)modifiedDate));
        properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)modifiedDate));
        properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.localResource.length()));
        this.properties = properties;
        return properties;
    }

    private ArchivaDavResource checkDavResourceIsArchivaDavResource(DavResource resource) throws DavException {
        if (!(resource instanceof ArchivaDavResource)) {
            throw new DavException(500, "DavResource is not instance of ArchivaDavResource");
        }
        return (ArchivaDavResource)resource;
    }

    private void triggerAuditEvent(String remoteIP, String repositoryId, String resource, String action) {
        String activePrincipal = ArchivaXworkUser.getActivePrincipal((Map)ActionContext.getContext().getSession());
        AuditEvent event = new AuditEvent(repositoryId, activePrincipal, resource, action);
        event.setRemoteIP(remoteIP);
        for (AuditListener listener : this.auditListeners) {
            listener.auditEvent(event);
        }
    }
}

