/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import com.opensymphony.xwork.ActionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.maven.archiva.common.utils.PathUtil;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.model.ArchivaRepositoryMetadata;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.ProjectReference;
import org.apache.maven.archiva.model.VersionedReference;
import org.apache.maven.archiva.policies.ProxyDownloadException;
import org.apache.maven.archiva.proxy.RepositoryProxyConnectors;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.RepositoryNotFoundException;
import org.apache.maven.archiva.repository.audit.AuditEvent;
import org.apache.maven.archiva.repository.audit.AuditListener;
import org.apache.maven.archiva.repository.audit.Auditable;
import org.apache.maven.archiva.repository.content.RepositoryRequest;
import org.apache.maven.archiva.repository.layout.LayoutException;
import org.apache.maven.archiva.repository.metadata.MetadataTools;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataMerge;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataReader;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.maven.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.maven.archiva.security.ArchivaXworkUser;
import org.apache.maven.archiva.security.ServletAuthenticator;
import org.apache.maven.archiva.webdav.ArchivaDavResource;
import org.apache.maven.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.maven.archiva.webdav.ArchivaVirtualDavResource;
import org.apache.maven.archiva.webdav.BrowserRedirectException;
import org.apache.maven.archiva.webdav.RepositoryLocator;
import org.apache.maven.archiva.webdav.UnauthorizedDavException;
import org.apache.maven.archiva.webdav.util.MimeTypes;
import org.apache.maven.archiva.webdav.util.RepositoryPathUtil;
import org.apache.maven.archiva.webdav.util.WebdavMethodUtil;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.digest.ChecksumFile;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.authorization.UnauthorizedException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.xwork.filter.authentication.HttpAuthenticator;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivaDavResourceFactory
implements DavResourceFactory,
Auditable {
    private static final String PROXIED_SUFFIX = " (proxied)";
    private static final String HTTP_PUT_METHOD = "PUT";
    private Logger log = LoggerFactory.getLogger(ArchivaDavResourceFactory.class);
    private List<AuditListener> auditListeners = new ArrayList<AuditListener>();
    private RepositoryContentFactory repositoryFactory;
    private RepositoryRequest repositoryRequest;
    private RepositoryProxyConnectors connectors;
    private MetadataTools metadataTools;
    private MimeTypes mimeTypes;
    private ArchivaConfiguration archivaConfiguration;
    private ServletAuthenticator servletAuth;
    private HttpAuthenticator httpAuth;
    private final LockManager lockManager = new SimpleLockManager();
    private RepositoryContentConsumers consumers;
    private ChecksumFile checksum;
    private Digester digestSha1;
    private Digester digestMd5;

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        ArchivaDavResourceLocator archivaLocator = (ArchivaDavResourceLocator)locator;
        RepositoryGroupConfiguration repoGroupConfig = (RepositoryGroupConfiguration)this.archivaConfiguration.getConfiguration().getRepositoryGroupsAsMap().get(archivaLocator.getRepositoryId());
        ArrayList<String> repositories = new ArrayList<String>();
        boolean isGet = WebdavMethodUtil.isReadMethod(request.getMethod());
        boolean isPut = WebdavMethodUtil.isWriteMethod(request.getMethod());
        if (repoGroupConfig != null) {
            if (WebdavMethodUtil.isWriteMethod(request.getMethod())) {
                throw new DavException(405, "Write method not allowed for repository groups.");
            }
            repositories.addAll(repoGroupConfig.getRepositories());
            if (RepositoryPathUtil.getLogicalResource(locator.getResourcePath()).endsWith("/")) {
                return this.getResource(request, repositories, archivaLocator);
            }
        } else {
            repositories.add(archivaLocator.getRepositoryId());
        }
        if (StringUtils.isEmpty((String)archivaLocator.getRepositoryId())) {
            throw new DavException(204);
        }
        ArrayList<DavResource> availableResources = new ArrayList<DavResource>();
        ArrayList<String> resourcesInAbsolutePath = new ArrayList<String>();
        DavException e = null;
        for (String repositoryId : repositories) {
            ManagedRepositoryContent managedRepository = null;
            try {
                managedRepository = this.getManagedRepository(repositoryId);
            }
            catch (DavException de) {
                throw new DavException(404, "Invalid managed repository <" + repositoryId + ">");
            }
            DavResource resource = null;
            if (locator.getResourcePath().startsWith(".")) continue;
            if (managedRepository != null) {
                Object logicalResource;
                block26: {
                    try {
                        if (!this.isAuthorized(request, repositoryId)) break block26;
                        logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
                        if (isGet) {
                            resource = this.doGet(managedRepository, request, archivaLocator, (LogicalResource)logicalResource);
                        }
                        if (!isPut) break block26;
                        resource = this.doPut(managedRepository, request, archivaLocator, (LogicalResource)logicalResource);
                    }
                    catch (DavException de) {
                        e = de;
                        continue;
                    }
                }
                if (resource == null) {
                    e = new DavException(404, "Resource does not exist");
                    continue;
                }
                availableResources.add(resource);
                logicalResource = RepositoryPathUtil.getLogicalResource(locator.getResourcePath());
                resourcesInAbsolutePath.add(managedRepository.getRepoRoot() + (String)logicalResource);
                continue;
            }
            e = new DavException(404, "Repository does not exist");
        }
        if (availableResources.isEmpty()) {
            throw e;
        }
        String requestedResource = request.getRequestURI();
        if ((this.repositoryRequest.isMetadata(requestedResource) || requestedResource.endsWith("metadata.xml.sha1") || requestedResource.endsWith("metadata.xml.md5")) && repoGroupConfig != null && this.isProjectReference(requestedResource)) {
            String artifactId = StringUtils.substringBeforeLast((String)requestedResource.replace('\\', '/'), (String)"/");
            artifactId = StringUtils.substringAfterLast((String)artifactId, (String)"/");
            ArchivaDavResource res = (ArchivaDavResource)availableResources.get(0);
            String filePath = StringUtils.substringBeforeLast((String)res.getLocalResource().getAbsolutePath().replace('\\', '/'), (String)"/");
            filePath = filePath + "/maven-metadata-" + repoGroupConfig.getId() + ".xml";
            if (this.repositoryRequest.isSupportFile(requestedResource)) {
                File metadataChecksum = new File(filePath + "." + StringUtils.substringAfterLast((String)requestedResource, (String)"."));
                if (metadataChecksum.exists()) {
                    LogicalResource logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
                    ArchivaDavResource metadataChecksumResource = new ArchivaDavResource(metadataChecksum.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.consumers);
                    availableResources.add(0, metadataChecksumResource);
                }
            } else {
                ArchivaRepositoryMetadata mergedMetadata = new ArchivaRepositoryMetadata();
                for (String resourceAbsPath : resourcesInAbsolutePath) {
                    try {
                        File metadataFile = new File(resourceAbsPath);
                        ArchivaRepositoryMetadata repoMetadata = RepositoryMetadataReader.read((File)metadataFile);
                        mergedMetadata = RepositoryMetadataMerge.merge((ArchivaRepositoryMetadata)mergedMetadata, (ArchivaRepositoryMetadata)repoMetadata);
                    }
                    catch (RepositoryMetadataException r) {
                        throw new DavException(500, "Error occurred while reading metadata file.");
                    }
                }
                try {
                    File resourceFile = this.writeMergedMetadataToFile(mergedMetadata, filePath);
                    LogicalResource logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
                    ArchivaDavResource metadataResource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.consumers);
                    availableResources.add(0, metadataResource);
                }
                catch (RepositoryMetadataException r) {
                    throw new DavException(500, "Error occurred while writing metadata file.");
                }
                catch (IOException ie) {
                    throw new DavException(500, "Error occurred while generating checksum files.");
                }
                catch (DigesterException de) {
                    throw new DavException(500, "Error occurred while generating checksum files.");
                }
            }
        }
        DavResource resource = (DavResource)availableResources.get(0);
        this.setHeaders(response, locator, resource);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        resource.addLockManager(this.lockManager);
        return resource;
    }

    public DavResource createResource(DavResourceLocator locator, DavSession davSession) throws DavException {
        this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        ArchivaDavResourceLocator archivaLocator = (ArchivaDavResourceLocator)locator;
        ArchivaDavResource resource = null;
        if (!locator.getResourcePath().startsWith(".")) {
            ManagedRepositoryContent managedRepository = this.getManagedRepository(archivaLocator.getRepositoryId());
            String logicalResource = RepositoryPathUtil.getLogicalResource(locator.getResourcePath());
            File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource);
            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource, managedRepository.getRepository(), davSession, archivaLocator, this, this.mimeTypes, this.auditListeners, this.consumers);
        }
        resource.addLockManager(this.lockManager);
        return resource;
    }

    private DavResource doGet(ManagedRepositoryContent managedRepository, DavServletRequest request, ArchivaDavResourceLocator locator, LogicalResource logicalResource) throws DavException {
        File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource.getPath());
        ArchivaDavResource resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), managedRepository.getRepository(), request.getRemoteAddr(), request.getDavSession(), locator, this, this.mimeTypes, this.auditListeners, this.consumers);
        if (!resource.isCollection()) {
            boolean previouslyExisted = resourceFile.exists();
            boolean fromProxy = this.fetchContentFromProxies(managedRepository, request, logicalResource);
            try {
                String localResourcePath = this.repositoryRequest.toNativePath(logicalResource.getPath(), managedRepository);
                resourceFile = new File(managedRepository.getRepoRoot(), localResourcePath);
            }
            catch (LayoutException e) {
                if (previouslyExisted) {
                    return resource;
                }
                throw new DavException(404, (Throwable)e);
            }
            if (fromProxy) {
                String repositoryId = locator.getRepositoryId();
                String event = (previouslyExisted ? "Modified File" : "Created File") + PROXIED_SUFFIX;
                this.triggerAuditEvent(request.getRemoteAddr(), repositoryId, logicalResource.getPath(), event);
            }
            resource = !resourceFile.exists() ? null : new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), managedRepository.getRepository(), request.getRemoteAddr(), request.getDavSession(), locator, this, this.mimeTypes, this.auditListeners, this.consumers);
        }
        return resource;
    }

    private DavResource doPut(ManagedRepositoryContent managedRepository, DavServletRequest request, ArchivaDavResourceLocator locator, LogicalResource logicalResource) throws DavException {
        File rootDirectory = new File(managedRepository.getRepoRoot());
        File destDir = new File(rootDirectory, logicalResource.getPath()).getParentFile();
        if (request.getMethod().equals(HTTP_PUT_METHOD) && !destDir.exists()) {
            destDir.mkdirs();
            String relPath = PathUtil.getRelative((String)rootDirectory.getAbsolutePath(), (File)destDir);
            this.triggerAuditEvent(request.getRemoteAddr(), logicalResource.getPath(), relPath, "Created Directory");
        }
        File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource.getPath());
        return new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), managedRepository.getRepository(), request.getRemoteAddr(), request.getDavSession(), locator, this, this.mimeTypes, this.auditListeners, this.consumers);
    }

    private boolean fetchContentFromProxies(ManagedRepositoryContent managedRepository, DavServletRequest request, LogicalResource resource) throws DavException {
        if (this.repositoryRequest.isSupportFile(resource.getPath())) {
            return false;
        }
        if (this.repositoryRequest.isDefault(resource.getPath()) && this.repositoryRequest.isMetadata(resource.getPath())) {
            return this.fetchMetadataFromProxies(managedRepository, request, resource);
        }
        try {
            ArtifactReference artifact = this.repositoryRequest.toArtifactReference(resource.getPath());
            if (artifact != null) {
                this.applyServerSideRelocation(managedRepository, artifact);
                File proxiedFile = this.connectors.fetchFromProxies(managedRepository, artifact);
                resource.setPath(managedRepository.toPath(artifact));
                return proxiedFile != null;
            }
        }
        catch (LayoutException e) {
        }
        catch (ProxyDownloadException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new DavException(500, "Unable to fetch artifact resource.");
        }
        return false;
    }

    private boolean fetchMetadataFromProxies(ManagedRepositoryContent managedRepository, DavServletRequest request, LogicalResource resource) throws DavException {
        try {
            VersionedReference versioned = this.metadataTools.toVersionedReference(resource.getPath());
            if (versioned != null) {
                this.connectors.fetchFromProxies(managedRepository, versioned);
                return true;
            }
        }
        catch (RepositoryMetadataException e) {
            // empty catch block
        }
        try {
            ProjectReference project = this.metadataTools.toProjectReference(resource.getPath());
            if (project != null) {
                this.connectors.fetchFromProxies(managedRepository, project);
                return true;
            }
        }
        catch (RepositoryMetadataException e) {
            // empty catch block
        }
        return false;
    }

    protected void applyServerSideRelocation(ManagedRepositoryContent managedRepository, ArtifactReference artifact) throws ProxyDownloadException {
        if ("pom".equals(artifact.getType())) {
            return;
        }
        ArtifactReference pomReference = new ArtifactReference();
        pomReference.setGroupId(artifact.getGroupId());
        pomReference.setArtifactId(artifact.getArtifactId());
        pomReference.setVersion(artifact.getVersion());
        pomReference.setType("pom");
        this.connectors.fetchFromProxies(managedRepository, pomReference);
        File pom = managedRepository.toFile(pomReference);
        if (!pom.exists()) {
            return;
        }
        try {
            Relocation relocation;
            Model model = new MavenXpp3Reader().read((Reader)new FileReader(pom));
            DistributionManagement dist = model.getDistributionManagement();
            if (dist != null && (relocation = dist.getRelocation()) != null) {
                if (relocation.getGroupId() != null) {
                    artifact.setGroupId(relocation.getGroupId());
                }
                if (relocation.getArtifactId() != null) {
                    artifact.setArtifactId(relocation.getArtifactId());
                }
                if (relocation.getVersion() != null) {
                    artifact.setVersion(relocation.getVersion());
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (XmlPullParserException e) {
            // empty catch block
        }
    }

    private void triggerAuditEvent(String remoteIP, String repositoryId, String resource, String action) {
        String activePrincipal = ArchivaXworkUser.getActivePrincipal((Map)ActionContext.getContext().getSession());
        AuditEvent event = new AuditEvent(repositoryId, activePrincipal, resource, action);
        event.setRemoteIP(remoteIP);
        for (AuditListener listener : this.auditListeners) {
            listener.auditEvent(event);
        }
    }

    public void addAuditListener(AuditListener listener) {
        this.auditListeners.add(listener);
    }

    public void clearAuditListeners() {
        this.auditListeners.clear();
    }

    public void removeAuditListener(AuditListener listener) {
        this.auditListeners.remove(listener);
    }

    private void setHeaders(DavServletResponse response, DavResourceLocator locator, DavResource resource) {
        if (locator.getResourcePath().endsWith("/maven-metadata.xml")) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        response.addDateHeader("last-modified", resource.getModificationTime());
    }

    private ManagedRepositoryContent getManagedRepository(String respositoryId) throws DavException {
        if (respositoryId != null) {
            try {
                return this.repositoryFactory.getManagedRepositoryContent(respositoryId);
            }
            catch (RepositoryNotFoundException e) {
                throw new DavException(404, (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new DavException(404, (Throwable)e);
            }
        }
        return null;
    }

    private void checkLocatorIsInstanceOfRepositoryLocator(DavResourceLocator locator) throws DavException {
        if (!(locator instanceof RepositoryLocator)) {
            throw new DavException(500, "Locator does not implement RepositoryLocator");
        }
    }

    protected boolean isAuthorized(DavServletRequest request, String repositoryId) throws DavException {
        try {
            AuthenticationResult result = this.httpAuth.getAuthenticationResult((HttpServletRequest)request, null);
            SecuritySession securitySession = this.httpAuth.getSecuritySession();
            return this.servletAuth.isAuthenticated((HttpServletRequest)request, result) && this.servletAuth.isAuthorized((HttpServletRequest)request, securitySession, repositoryId, WebdavMethodUtil.isWriteMethod(request.getMethod()));
        }
        catch (AuthenticationException e) {
            throw new UnauthorizedDavException(repositoryId, "You are not authenticated");
        }
        catch (MustChangePasswordException e) {
            throw new UnauthorizedDavException(repositoryId, "You must change your password.");
        }
        catch (AccountLockedException e) {
            throw new UnauthorizedDavException(repositoryId, "User account is locked.");
        }
        catch (AuthorizationException e) {
            throw new DavException(500, "Fatal Authorization Subsystem Error.");
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedDavException(repositoryId, e.getMessage());
        }
    }

    private DavResource getResource(DavServletRequest request, List<String> repositories, ArchivaDavResourceLocator locator) throws DavException {
        String activePrincipal;
        boolean allow;
        ArrayList<File> mergedRepositoryContents = new ArrayList<File>();
        LogicalResource logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        if (request.getSession().getAttribute("securitySession") != null) {
            sessionMap.put("securitySession", request.getSession().getAttribute("securitySession"));
        }
        if (allow = this.isAllowedToContinue(request, repositories, activePrincipal = ArchivaXworkUser.getActivePrincipal(sessionMap))) {
            for (String repository : repositories) {
                if (this.httpAuth.getSecuritySession() != null) {
                    try {
                        if (!this.isAuthorized(request, repository)) continue;
                        this.getResource(locator, mergedRepositoryContents, logicalResource, repository);
                    }
                    catch (DavException e) {}
                    continue;
                }
                try {
                    if (!this.servletAuth.isAuthorizedToAccessVirtualRepository(activePrincipal, repository)) continue;
                    this.getResource(locator, mergedRepositoryContents, logicalResource, repository);
                }
                catch (UnauthorizedException e) {}
            }
        } else {
            throw new UnauthorizedDavException(locator.getRepositoryId(), "User not authorized.");
        }
        ArchivaVirtualDavResource resource = new ArchivaVirtualDavResource(mergedRepositoryContents, logicalResource.getPath(), this.mimeTypes, locator, this);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        return resource;
    }

    private void getResource(ArchivaDavResourceLocator locator, List<File> mergedRepositoryContents, LogicalResource logicalResource, String repository) throws DavException {
        File resourceFile;
        ManagedRepositoryContent managedRepository = null;
        try {
            managedRepository = this.getManagedRepository(repository);
        }
        catch (DavException de) {
            throw new DavException(404, "Invalid managed repository <" + repository + ">");
        }
        if (!locator.getResourcePath().startsWith(".") && managedRepository != null && (resourceFile = new File(managedRepository.getRepoRoot(), logicalResource.getPath())).exists()) {
            mergedRepositoryContents.add(resourceFile);
        }
    }

    private boolean isAllowedToContinue(DavServletRequest request, List<String> repositories, String activePrincipal) {
        boolean allow = false;
        if (this.httpAuth.getSecuritySession() != null) {
            for (String repository : repositories) {
                try {
                    if (!this.isAuthorized(request, repository)) continue;
                    allow = true;
                    break;
                }
                catch (DavException e) {
                }
            }
        } else {
            for (String repository : repositories) {
                try {
                    if (!this.servletAuth.isAuthorizedToAccessVirtualRepository(activePrincipal, repository)) continue;
                    allow = true;
                    break;
                }
                catch (UnauthorizedException e) {
                }
            }
        }
        return allow;
    }

    private File writeMergedMetadataToFile(ArchivaRepositoryMetadata mergedMetadata, String outputFilename) throws RepositoryMetadataException, DigesterException, IOException {
        File outputFile = new File(outputFilename);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        outputFile.getParentFile().mkdirs();
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)mergedMetadata, (File)outputFile);
        this.createChecksumFile(outputFilename, this.digestSha1);
        this.createChecksumFile(outputFilename, this.digestMd5);
        return outputFile;
    }

    private void createChecksumFile(String path, Digester digester) throws DigesterException, IOException {
        File checksumFile = new File(path + digester.getFilenameExtension());
        if (!checksumFile.exists()) {
            FileUtils.deleteQuietly((File)checksumFile);
            this.checksum.createChecksum(new File(path), digester);
        } else if (!checksumFile.isFile()) {
            this.log.error("Checksum file is not a file.");
        }
    }

    private boolean isProjectReference(String requestedResource) {
        try {
            VersionedReference versionRef = this.metadataTools.toVersionedReference(requestedResource);
            return false;
        }
        catch (RepositoryMetadataException re) {
            return true;
        }
    }

    class LogicalResource {
        private String path;

        public LogicalResource(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

