/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.maven.archiva.webdav.RepositoryLocator;

public class ArchivaDavResourceLocator
implements DavResourceLocator,
RepositoryLocator {
    private final String prefix;
    private final String resourcePath;
    private final String href;
    private final String repositoryId;
    private final DavLocatorFactory davLocatorFactory;

    public ArchivaDavResourceLocator(String prefix, String resourcePath, String repositoryId, DavLocatorFactory davLocatorFactory) {
        this.prefix = prefix;
        this.repositoryId = repositoryId;
        this.davLocatorFactory = davLocatorFactory;
        String path = resourcePath;
        if (!resourcePath.startsWith("/")) {
            path = "/" + resourcePath;
        }
        String escapedPath = Text.escapePath((String)resourcePath);
        String hrefPrefix = prefix;
        if (hrefPrefix.endsWith("/") && escapedPath.startsWith("/")) {
            hrefPrefix = hrefPrefix.substring(0, hrefPrefix.length() - 1);
        }
        this.href = hrefPrefix + escapedPath;
        if (resourcePath.endsWith("/") && resourcePath.length() > 1) {
            path = resourcePath.substring(0, resourcePath.length() - 1);
        }
        this.resourcePath = path;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getWorkspacePath() {
        return "";
    }

    public String getWorkspaceName() {
        return "";
    }

    public boolean isSameWorkspace(DavResourceLocator locator) {
        return this.isSameWorkspace(locator.getWorkspaceName());
    }

    public boolean isSameWorkspace(String workspaceName) {
        return this.getWorkspaceName().equals(workspaceName);
    }

    public String getHref(boolean isCollection) {
        String suffix = isCollection && !this.isRootLocation() && !this.href.endsWith("/") ? "/" : "";
        return this.href + suffix;
    }

    public boolean isRootLocation() {
        return "/".equals(this.resourcePath);
    }

    public DavLocatorFactory getFactory() {
        return this.davLocatorFactory;
    }

    public String getRepositoryPath() {
        return this.getResourcePath();
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DavResourceLocator) {
            DavResourceLocator other = (DavResourceLocator)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }
}

