/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.maven.archiva.security.ServletAuthenticator;
import org.apache.maven.archiva.webdav.ArchivaDavSession;
import org.apache.maven.archiva.webdav.UnauthorizedDavException;
import org.apache.maven.archiva.webdav.util.RepositoryPathUtil;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.xwork.filter.authentication.HttpAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivaDavSessionProvider
implements DavSessionProvider {
    private Logger log = LoggerFactory.getLogger(ArchivaDavSessionProvider.class);
    private ServletAuthenticator servletAuth;
    private HttpAuthenticator httpAuth;

    public ArchivaDavSessionProvider(ServletAuthenticator servletAuth, HttpAuthenticator httpAuth) {
        this.servletAuth = servletAuth;
        this.httpAuth = httpAuth;
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        String repositoryId = RepositoryPathUtil.getRepositoryName(this.removeContextPath((DavServletRequest)request));
        try {
            AuthenticationResult result = this.httpAuth.getAuthenticationResult((HttpServletRequest)request, null);
            request.setDavSession((DavSession)new ArchivaDavSession());
            return this.servletAuth.isAuthenticated((HttpServletRequest)request, result);
        }
        catch (AuthenticationException e) {
            throw new UnauthorizedDavException(repositoryId, "You are not authenticated");
        }
        catch (MustChangePasswordException e) {
            throw new UnauthorizedDavException(repositoryId, "You must change your password.");
        }
        catch (AccountLockedException e) {
            throw new UnauthorizedDavException(repositoryId, "User account is locked.");
        }
    }

    public void releaseSession(WebdavRequest request) {
        request.setDavSession(null);
    }

    private String removeContextPath(DavServletRequest request) {
        String ctx;
        String path = request.getRequestURI();
        if (path.startsWith(ctx = request.getContextPath())) {
            path = path.substring(ctx.length());
        }
        return path;
    }
}

