/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav.util;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RepositoryPathUtil {
    public static String getLogicalResource(String href) {
        int slash;
        String logicalResource = null;
        String requestPathInfo = StringUtils.defaultString((String)href);
        if ((requestPathInfo = RepositoryPathUtil.removePrefix(requestPathInfo)).startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        if ((slash = requestPathInfo.indexOf(47)) > 0) {
            logicalResource = requestPathInfo.substring(slash);
            if (logicalResource.endsWith("/..")) {
                logicalResource = logicalResource + "/";
            }
            if (logicalResource != null && logicalResource.startsWith("//")) {
                logicalResource = logicalResource.substring(1);
            }
            if (logicalResource == null) {
                logicalResource = "/";
            }
        } else {
            logicalResource = "/";
        }
        return logicalResource;
    }

    public static String getRepositoryName(String href) {
        int slash;
        String requestPathInfo = StringUtils.defaultString((String)href);
        if ((requestPathInfo = RepositoryPathUtil.removePrefix(requestPathInfo)).startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        if ((slash = requestPathInfo.indexOf(47)) > 0) {
            return requestPathInfo.substring(0, slash);
        }
        return requestPathInfo;
    }

    private static String removePrefix(String href) {
        Object[] parts = StringUtils.split((String)href, (char)'/');
        if ((parts = (String[])ArrayUtils.subarray((Object[])parts, (int)1, (int)parts.length)) == null || parts.length == 0) {
            return "/";
        }
        String joinedString = StringUtils.join((Object[])parts, (char)'/');
        if (href.endsWith("/")) {
            joinedString = joinedString + "/";
        }
        return joinedString;
    }
}

