/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.maven.archiva.security.ServletAuthenticator;
import org.apache.maven.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.maven.archiva.webdav.ArchivaDavSession;
import org.apache.maven.archiva.webdav.UnauthorizedDavException;
import org.apache.maven.archiva.webdav.util.RepositoryPathUtil;
import org.apache.maven.archiva.webdav.util.WebdavMethodUtil;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.UnauthorizedException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.redback.integration.filter.authentication.HttpAuthenticator;

public class ArchivaDavSessionProvider
implements DavSessionProvider {
    private ServletAuthenticator servletAuth;
    private HttpAuthenticator httpAuth;

    public ArchivaDavSessionProvider(ServletAuthenticator servletAuth, HttpAuthenticator httpAuth) {
        this.servletAuth = servletAuth;
        this.httpAuth = httpAuth;
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        String repositoryId = RepositoryPathUtil.getRepositoryName(this.removeContextPath((DavServletRequest)request));
        try {
            AuthenticationResult result = this.httpAuth.getAuthenticationResult((HttpServletRequest)request, null);
            request.setDavSession((DavSession)new ArchivaDavSession());
            return this.servletAuth.isAuthenticated((HttpServletRequest)request, result);
        }
        catch (AuthenticationException e) {
            String guest = "guest";
            try {
                if (this.servletAuth.isAuthorized(guest, ((ArchivaDavResourceLocator)request.getRequestLocator()).getRepositoryId(), WebdavMethodUtil.getMethodPermission(request.getMethod()))) {
                    request.setDavSession((DavSession)new ArchivaDavSession());
                    return true;
                }
            }
            catch (UnauthorizedException ae) {
                throw new UnauthorizedDavException(repositoryId, "You are not authenticated and authorized to access any repository.");
            }
            throw new UnauthorizedDavException(repositoryId, "You are not authenticated.");
        }
        catch (MustChangePasswordException e) {
            throw new UnauthorizedDavException(repositoryId, "You must change your password.");
        }
        catch (AccountLockedException e) {
            throw new UnauthorizedDavException(repositoryId, "User account is locked.");
        }
    }

    public void releaseSession(WebdavRequest request) {
        request.setDavSession(null);
    }

    private String removeContextPath(DavServletRequest request) {
        String ctx;
        String path = request.getRequestURI();
        if (path.startsWith(ctx = request.getContextPath())) {
            path = path.substring(ctx.length());
        }
        return path;
    }
}

