/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.maven.archiva.common.utils.PathUtil;
import org.apache.maven.archiva.common.utils.VersionUtil;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.database.ArchivaAuditLogsDao;
import org.apache.maven.archiva.model.ArchivaRepositoryMetadata;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.policies.ProxyDownloadException;
import org.apache.maven.archiva.proxy.RepositoryProxyConnectors;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.RepositoryNotFoundException;
import org.apache.maven.archiva.repository.audit.AuditEvent;
import org.apache.maven.archiva.repository.audit.AuditListener;
import org.apache.maven.archiva.repository.audit.Auditable;
import org.apache.maven.archiva.repository.content.RepositoryRequest;
import org.apache.maven.archiva.repository.layout.LayoutException;
import org.apache.maven.archiva.repository.metadata.MetadataTools;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataMerge;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataReader;
import org.apache.maven.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.maven.archiva.scheduled.ArchivaTaskScheduler;
import org.apache.maven.archiva.security.ServletAuthenticator;
import org.apache.maven.archiva.webdav.ArchivaDavResource;
import org.apache.maven.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.maven.archiva.webdav.ArchivaVirtualDavResource;
import org.apache.maven.archiva.webdav.BrowserRedirectException;
import org.apache.maven.archiva.webdav.UnauthorizedDavException;
import org.apache.maven.archiva.webdav.util.MimeTypes;
import org.apache.maven.archiva.webdav.util.RepositoryPathUtil;
import org.apache.maven.archiva.webdav.util.WebdavMethodUtil;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.digest.ChecksumFile;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.authorization.UnauthorizedException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.redback.integration.filter.authentication.HttpAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivaDavResourceFactory
implements DavResourceFactory,
Auditable {
    private static final String PROXIED_SUFFIX = " (proxied)";
    private static final String HTTP_PUT_METHOD = "PUT";
    private Logger log = LoggerFactory.getLogger(ArchivaDavResourceFactory.class);
    private List<AuditListener> auditListeners = new ArrayList<AuditListener>();
    private RepositoryContentFactory repositoryFactory;
    private RepositoryRequest repositoryRequest;
    private RepositoryProxyConnectors connectors;
    private MetadataTools metadataTools;
    private MimeTypes mimeTypes;
    private ArchivaConfiguration archivaConfiguration;
    private ServletAuthenticator servletAuth;
    private HttpAuthenticator httpAuth;
    private final LockManager lockManager = new SimpleLockManager();
    private ChecksumFile checksum;
    private Digester digestSha1;
    private Digester digestMd5;
    private ArchivaTaskScheduler scheduler;
    private ArchivaAuditLogsDao auditLogsDao;

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        DavResource resource;
        ArchivaDavResourceLocator archivaLocator = this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        RepositoryGroupConfiguration repoGroupConfig = (RepositoryGroupConfiguration)this.archivaConfiguration.getConfiguration().getRepositoryGroupsAsMap().get(archivaLocator.getRepositoryId());
        String activePrincipal = this.getActivePrincipal(request);
        ArrayList<String> resourcesInAbsolutePath = new ArrayList<String>();
        boolean readMethod = WebdavMethodUtil.isReadMethod(request.getMethod());
        if (repoGroupConfig != null) {
            if (!readMethod) {
                throw new DavException(405, "Write method not allowed for repository groups.");
            }
            this.log.debug("Repository group '" + repoGroupConfig.getId() + "' accessed by '" + activePrincipal + "'");
            if (RepositoryPathUtil.getLogicalResource(archivaLocator.getOrigResourcePath()).endsWith("/")) {
                return this.getResource(request, repoGroupConfig.getRepositories(), archivaLocator);
            }
            resource = this.processRepositoryGroup(request, archivaLocator, repoGroupConfig.getRepositories(), activePrincipal, resourcesInAbsolutePath);
        } else {
            ManagedRepositoryContent managedRepository = null;
            try {
                managedRepository = this.repositoryFactory.getManagedRepositoryContent(archivaLocator.getRepositoryId());
            }
            catch (RepositoryNotFoundException e) {
                throw new DavException(404, "Invalid repository: " + archivaLocator.getRepositoryId());
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
            this.log.debug("Managed repository '" + managedRepository.getId() + "' accessed by '" + activePrincipal + "'");
            resource = this.processRepository(request, archivaLocator, activePrincipal, managedRepository);
            String logicalResource = RepositoryPathUtil.getLogicalResource(locator.getResourcePath());
            resourcesInAbsolutePath.add(new File(managedRepository.getRepoRoot(), logicalResource).getAbsolutePath());
        }
        String requestedResource = request.getRequestURI();
        if ((this.repositoryRequest.isMetadata(requestedResource) || this.repositoryRequest.isMetadataSupportFile(requestedResource)) && repoGroupConfig != null && this.isProjectReference(requestedResource)) {
            String artifactId = StringUtils.substringBeforeLast((String)requestedResource.replace('\\', '/'), (String)"/");
            artifactId = StringUtils.substringAfterLast((String)artifactId, (String)"/");
            ArchivaDavResource res = (ArchivaDavResource)resource;
            String filePath = StringUtils.substringBeforeLast((String)res.getLocalResource().getAbsolutePath().replace('\\', '/'), (String)"/");
            filePath = filePath + "/maven-metadata-" + repoGroupConfig.getId() + ".xml";
            if (this.repositoryRequest.isSupportFile(requestedResource)) {
                File metadataChecksum = new File(filePath + "." + StringUtils.substringAfterLast((String)requestedResource, (String)"."));
                if (metadataChecksum.exists()) {
                    LogicalResource logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
                    resource = new ArchivaDavResource(metadataChecksum.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.auditLogsDao);
                }
            } else if (resourcesInAbsolutePath != null && resourcesInAbsolutePath.size() > 1) {
                ArchivaRepositoryMetadata mergedMetadata = new ArchivaRepositoryMetadata();
                for (String resourceAbsPath : resourcesInAbsolutePath) {
                    try {
                        File metadataFile = new File(resourceAbsPath);
                        ArchivaRepositoryMetadata repoMetadata = RepositoryMetadataReader.read((File)metadataFile);
                        mergedMetadata = RepositoryMetadataMerge.merge((ArchivaRepositoryMetadata)mergedMetadata, (ArchivaRepositoryMetadata)repoMetadata);
                    }
                    catch (RepositoryMetadataException r) {
                        throw new DavException(500, "Error occurred while reading metadata file.");
                    }
                }
                try {
                    File resourceFile = this.writeMergedMetadataToFile(mergedMetadata, filePath);
                    LogicalResource logicalResource = new LogicalResource(RepositoryPathUtil.getLogicalResource(locator.getResourcePath()));
                    resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.auditLogsDao);
                }
                catch (RepositoryMetadataException r) {
                    throw new DavException(500, "Error occurred while writing metadata file.");
                }
                catch (IOException ie) {
                    throw new DavException(500, "Error occurred while generating checksum files.");
                }
                catch (DigesterException de) {
                    throw new DavException(500, "Error occurred while generating checksum files.");
                }
            }
        }
        this.setHeaders(response, locator, resource);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        resource.addLockManager(this.lockManager);
        return resource;
    }

    private DavResource processRepositoryGroup(DavServletRequest request, ArchivaDavResourceLocator archivaLocator, List<String> repositories, String activePrincipal, List<String> resourcesInAbsolutePath) throws DavException {
        DavResource resource = null;
        ArrayList<DavException> storedExceptions = new ArrayList<DavException>();
        for (String repositoryId : repositories) {
            ManagedRepositoryContent managedRepository = null;
            try {
                managedRepository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            }
            catch (RepositoryNotFoundException e) {
                throw new DavException(500, (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
            try {
                String logicalResource;
                DavResource updatedResource = this.processRepository(request, archivaLocator, activePrincipal, managedRepository);
                if (resource == null) {
                    resource = updatedResource;
                }
                if ((logicalResource = RepositoryPathUtil.getLogicalResource(archivaLocator.getResourcePath())).endsWith("/")) {
                    logicalResource = logicalResource.substring(1);
                }
                resourcesInAbsolutePath.add(new File(managedRepository.getRepoRoot(), logicalResource).getAbsolutePath());
            }
            catch (DavException e) {
                storedExceptions.add(e);
            }
        }
        if (resource == null) {
            if (!storedExceptions.isEmpty()) {
                for (DavException e : storedExceptions) {
                    if (401 != e.getErrorCode()) continue;
                    throw e;
                }
                throw new DavException(404);
            }
            throw new DavException(404);
        }
        return resource;
    }

    private DavResource processRepository(DavServletRequest request, ArchivaDavResourceLocator archivaLocator, String activePrincipal, ManagedRepositoryContent managedRepository) throws DavException {
        ArchivaDavResource resource = null;
        if (this.isAuthorized(request, managedRepository.getId())) {
            String path = RepositoryPathUtil.getLogicalResource(archivaLocator.getResourcePath());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            LogicalResource logicalResource = new LogicalResource(path);
            File resourceFile = new File(managedRepository.getRepoRoot(), path);
            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), path, managedRepository.getRepository(), request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.auditLogsDao);
            if (WebdavMethodUtil.isReadMethod(request.getMethod())) {
                if (archivaLocator.getHref(false).endsWith("/") && !resourceFile.isDirectory()) {
                    throw new DavException(404, "Resource does not exist");
                }
                if (!resource.isCollection()) {
                    boolean fromProxy;
                    boolean previouslyExisted;
                    block15: {
                        previouslyExisted = resourceFile.exists();
                        fromProxy = this.fetchContentFromProxies(managedRepository, request, logicalResource);
                        try {
                            String localResourcePath = this.repositoryRequest.toNativePath(logicalResource.getPath(), managedRepository);
                            resourceFile = new File(managedRepository.getRepoRoot(), localResourcePath);
                            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), managedRepository.getRepository(), request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.auditLogsDao);
                        }
                        catch (LayoutException e) {
                            if (resourceFile.exists()) break block15;
                            throw new DavException(404, (Throwable)e);
                        }
                    }
                    if (fromProxy) {
                        String event = (previouslyExisted ? "Modified File" : "Created File") + PROXIED_SUFFIX;
                        this.log.debug("Proxied artifact '" + resourceFile.getName() + "' in repository '" + managedRepository.getId() + "' (current user '" + activePrincipal + "')");
                        this.triggerAuditEvent(request.getRemoteAddr(), archivaLocator.getRepositoryId(), logicalResource.getPath(), event, activePrincipal);
                    }
                    if (!resourceFile.exists()) {
                        throw new DavException(404, "Resource does not exist");
                    }
                }
            }
            if (request.getMethod().equals(HTTP_PUT_METHOD)) {
                File rootDirectory;
                File destDir;
                String resourcePath = logicalResource.getPath();
                if (managedRepository.getRepository().isReleases() && !this.repositoryRequest.isMetadata(resourcePath) && !this.repositoryRequest.isSupportFile(resourcePath)) {
                    ArtifactReference artifact = null;
                    try {
                        artifact = managedRepository.toArtifactReference(resourcePath);
                        if (!VersionUtil.isSnapshot((String)artifact.getVersion()) && managedRepository.hasContent(artifact) && managedRepository.getRepository().isBlockRedeployments()) {
                            this.log.warn("Overwriting released artifacts in repository '" + managedRepository.getId() + "' is not allowed.");
                            throw new DavException(409, "Overwriting released artifacts is not allowed.");
                        }
                    }
                    catch (LayoutException e) {
                        this.log.warn("Artifact path '" + resourcePath + "' is invalid.");
                    }
                }
                if (!(destDir = new File(rootDirectory = new File(managedRepository.getRepoRoot()), logicalResource.getPath()).getParentFile()).exists()) {
                    destDir.mkdirs();
                    String relPath = PathUtil.getRelative((String)rootDirectory.getAbsolutePath(), (File)destDir);
                    this.log.debug("Creating destination directory '" + destDir.getName() + "' (current user '" + activePrincipal + "')");
                    this.triggerAuditEvent(request.getRemoteAddr(), managedRepository.getId(), relPath, "Created Directory", activePrincipal);
                }
            }
        }
        return resource;
    }

    public DavResource createResource(DavResourceLocator locator, DavSession davSession) throws DavException {
        ManagedRepositoryContent managedRepository;
        ArchivaDavResourceLocator archivaLocator = this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        try {
            managedRepository = this.repositoryFactory.getManagedRepositoryContent(archivaLocator.getRepositoryId());
        }
        catch (RepositoryNotFoundException e) {
            throw new DavException(404, "Invalid repository: " + archivaLocator.getRepositoryId());
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
        String logicalResource = RepositoryPathUtil.getLogicalResource(locator.getResourcePath());
        if (logicalResource.startsWith("/")) {
            logicalResource = logicalResource.substring(1);
        }
        File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource);
        ArchivaDavResource resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource, managedRepository.getRepository(), davSession, archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.auditLogsDao);
        resource.addLockManager(this.lockManager);
        return resource;
    }

    private boolean fetchContentFromProxies(ManagedRepositoryContent managedRepository, DavServletRequest request, LogicalResource resource) throws DavException {
        String path = resource.getPath();
        if (this.repositoryRequest.isSupportFile(path)) {
            File proxiedFile = this.connectors.fetchFromProxies(managedRepository, path);
            return proxiedFile != null;
        }
        if (this.repositoryRequest.isDefault(path) && this.repositoryRequest.isMetadata(path)) {
            return this.connectors.fetchMetatadaFromProxies(managedRepository, path) != null;
        }
        try {
            ArtifactReference artifact = this.repositoryRequest.toArtifactReference(path);
            if (artifact != null) {
                this.applyServerSideRelocation(managedRepository, artifact);
                File proxiedFile = this.connectors.fetchFromProxies(managedRepository, artifact);
                resource.setPath(managedRepository.toPath(artifact));
                this.log.debug("Proxied artifact '" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "'");
                return proxiedFile != null;
            }
        }
        catch (LayoutException e) {
        }
        catch (ProxyDownloadException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new DavException(500, "Unable to fetch artifact resource.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyServerSideRelocation(ManagedRepositoryContent managedRepository, ArtifactReference artifact) throws ProxyDownloadException {
        if ("pom".equals(artifact.getType())) {
            return;
        }
        ArtifactReference pomReference = new ArtifactReference();
        pomReference.setGroupId(artifact.getGroupId());
        pomReference.setArtifactId(artifact.getArtifactId());
        pomReference.setVersion(artifact.getVersion());
        pomReference.setType("pom");
        this.connectors.fetchFromProxies(managedRepository, pomReference);
        File pom = managedRepository.toFile(pomReference);
        if (!pom.exists()) {
            return;
        }
        try {
            Relocation relocation;
            FileReader reader = new FileReader(pom);
            Model model = null;
            try {
                model = new MavenXpp3Reader().read((Reader)reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            DistributionManagement dist = model.getDistributionManagement();
            if (dist != null && (relocation = dist.getRelocation()) != null) {
                if (relocation.getGroupId() != null) {
                    artifact.setGroupId(relocation.getGroupId());
                }
                if (relocation.getArtifactId() != null) {
                    artifact.setArtifactId(relocation.getArtifactId());
                }
                if (relocation.getVersion() != null) {
                    artifact.setVersion(relocation.getVersion());
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (XmlPullParserException e) {
            // empty catch block
        }
    }

    private void triggerAuditEvent(String remoteIP, String repositoryId, String resource, String action, String principal) {
        AuditEvent event = new AuditEvent(repositoryId, principal, resource, action);
        event.setRemoteIP(remoteIP);
        for (AuditListener listener : this.auditListeners) {
            listener.auditEvent(event);
        }
    }

    public void addAuditListener(AuditListener listener) {
        this.auditListeners.add(listener);
    }

    public void clearAuditListeners() {
        this.auditListeners.clear();
    }

    public void removeAuditListener(AuditListener listener) {
        this.auditListeners.remove(listener);
    }

    private void setHeaders(DavServletResponse response, DavResourceLocator locator, DavResource resource) {
        if (locator.getResourcePath().endsWith("/maven-metadata.xml")) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        response.addDateHeader("last-modified", resource.getModificationTime());
    }

    private ArchivaDavResourceLocator checkLocatorIsInstanceOfRepositoryLocator(DavResourceLocator locator) throws DavException {
        if (!(locator instanceof ArchivaDavResourceLocator)) {
            throw new DavException(500, "Locator does not implement RepositoryLocator");
        }
        if (locator.getResourcePath().startsWith(".")) {
            throw new DavException(404);
        }
        ArchivaDavResourceLocator archivaLocator = (ArchivaDavResourceLocator)locator;
        if (StringUtils.isEmpty((String)archivaLocator.getRepositoryId())) {
            throw new DavException(204);
        }
        return archivaLocator;
    }

    protected boolean isAuthorized(DavServletRequest request, String repositoryId) throws DavException {
        try {
            AuthenticationResult result = this.httpAuth.getAuthenticationResult((HttpServletRequest)request, null);
            SecuritySession securitySession = this.httpAuth.getSecuritySession(request.getSession(true));
            return this.servletAuth.isAuthenticated((HttpServletRequest)request, result) && this.servletAuth.isAuthorized((HttpServletRequest)request, securitySession, repositoryId, WebdavMethodUtil.getMethodPermission(request.getMethod()));
        }
        catch (AuthenticationException e) {
            String guest = "guest";
            try {
                if (this.servletAuth.isAuthorized(guest, ((ArchivaDavResourceLocator)request.getRequestLocator()).getRepositoryId(), WebdavMethodUtil.getMethodPermission(request.getMethod()))) {
                    return true;
                }
            }
            catch (UnauthorizedException ae) {
                throw new UnauthorizedDavException(repositoryId, "You are not authenticated and authorized to access any repository.");
            }
            throw new UnauthorizedDavException(repositoryId, "You are not authenticated");
        }
        catch (MustChangePasswordException e) {
            throw new UnauthorizedDavException(repositoryId, "You must change your password.");
        }
        catch (AccountLockedException e) {
            throw new UnauthorizedDavException(repositoryId, "User account is locked.");
        }
        catch (AuthorizationException e) {
            throw new DavException(500, "Fatal Authorization Subsystem Error.");
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedDavException(repositoryId, e.getMessage());
        }
    }

    private DavResource getResource(DavServletRequest request, List<String> repositories, ArchivaDavResourceLocator locator) throws DavException {
        ArrayList<File> mergedRepositoryContents = new ArrayList<File>();
        String path = RepositoryPathUtil.getLogicalResource(locator.getResourcePath());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        LogicalResource logicalResource = new LogicalResource(path);
        String activePrincipal = this.getActivePrincipal(request);
        boolean allow = this.isAllowedToContinue(request, repositories, activePrincipal);
        if (allow) {
            for (String repository : repositories) {
                ManagedRepositoryContent managedRepository = null;
                try {
                    managedRepository = this.repositoryFactory.getManagedRepositoryContent(repository);
                }
                catch (RepositoryNotFoundException e) {
                    throw new DavException(500, "Invalid managed repository <" + repository + ">: " + e.getMessage());
                }
                catch (RepositoryException e) {
                    throw new DavException(500, "Invalid managed repository <" + repository + ">: " + e.getMessage());
                }
                File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource.getPath());
                if (!resourceFile.exists()) continue;
                if (this.httpAuth.getSecuritySession(request.getSession(true)) != null) {
                    try {
                        if (!this.isAuthorized(request, repository)) continue;
                        mergedRepositoryContents.add(resourceFile);
                        this.log.debug("Repository '" + repository + "' accessed by '" + activePrincipal + "'");
                    }
                    catch (DavException e) {
                        this.log.debug("Skipping repository '" + managedRepository + "' for user '" + activePrincipal + "': " + e.getMessage());
                    }
                    continue;
                }
                try {
                    if (!this.servletAuth.isAuthorized(activePrincipal, repository, WebdavMethodUtil.getMethodPermission(request.getMethod()))) continue;
                    mergedRepositoryContents.add(resourceFile);
                    this.log.debug("Repository '" + repository + "' accessed by '" + activePrincipal + "'");
                }
                catch (UnauthorizedException e) {
                    this.log.debug("Skipping repository '" + managedRepository + "' for user '" + activePrincipal + "': " + e.getMessage());
                }
            }
        } else {
            throw new UnauthorizedDavException(locator.getRepositoryId(), "User not authorized.");
        }
        ArchivaVirtualDavResource resource = new ArchivaVirtualDavResource(mergedRepositoryContents, logicalResource.getPath(), this.mimeTypes, locator, this);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        return resource;
    }

    protected String getActivePrincipal(DavServletRequest request) {
        User sessionUser = this.httpAuth.getSessionUser(request.getSession());
        return sessionUser != null ? sessionUser.getUsername() : "guest";
    }

    private boolean isAllowedToContinue(DavServletRequest request, List<String> repositories, String activePrincipal) {
        boolean allow = false;
        if (this.httpAuth.getSecuritySession(request.getSession()) != null) {
            for (String repository : repositories) {
                try {
                    if (!this.isAuthorized(request, repository)) continue;
                    allow = true;
                    break;
                }
                catch (DavException e) {
                }
            }
        } else {
            for (String repository : repositories) {
                try {
                    if (!this.servletAuth.isAuthorized(activePrincipal, repository, WebdavMethodUtil.getMethodPermission(request.getMethod()))) continue;
                    allow = true;
                    break;
                }
                catch (UnauthorizedException e) {
                }
            }
        }
        return allow;
    }

    private File writeMergedMetadataToFile(ArchivaRepositoryMetadata mergedMetadata, String outputFilename) throws RepositoryMetadataException, DigesterException, IOException {
        File outputFile = new File(outputFilename);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        outputFile.getParentFile().mkdirs();
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)mergedMetadata, (File)outputFile);
        this.createChecksumFile(outputFilename, this.digestSha1);
        this.createChecksumFile(outputFilename, this.digestMd5);
        return outputFile;
    }

    private void createChecksumFile(String path, Digester digester) throws DigesterException, IOException {
        File checksumFile = new File(path + digester.getFilenameExtension());
        if (!checksumFile.exists()) {
            FileUtils.deleteQuietly((File)checksumFile);
            this.checksum.createChecksum(new File(path), digester);
        } else if (!checksumFile.isFile()) {
            this.log.error("Checksum file is not a file.");
        }
    }

    private boolean isProjectReference(String requestedResource) {
        try {
            this.metadataTools.toVersionedReference(requestedResource);
            return false;
        }
        catch (RepositoryMetadataException re) {
            return true;
        }
    }

    public void setServletAuth(ServletAuthenticator servletAuth) {
        this.servletAuth = servletAuth;
    }

    public void setHttpAuth(HttpAuthenticator httpAuth) {
        this.httpAuth = httpAuth;
    }

    public void setScheduler(ArchivaTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public void setRepositoryFactory(RepositoryContentFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public void setRepositoryRequest(RepositoryRequest repositoryRequest) {
        this.repositoryRequest = repositoryRequest;
    }

    public void setConnectors(RepositoryProxyConnectors connectors) {
        this.connectors = connectors;
    }

    public void setAuditLogsDao(ArchivaAuditLogsDao auditLogsDao) {
        this.auditLogsDao = auditLogsDao;
    }

    private static class LogicalResource {
        private String path;

        public LogicalResource(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

