/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.webdav.util;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.io.OutputContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexWriter {
    private final String logicalResource;
    private final List<File> localResources;
    private final boolean isVirtual;

    public IndexWriter(DavResource resource, File localResource, String logicalResource) {
        this.localResources = new ArrayList<File>();
        this.localResources.add(localResource);
        this.logicalResource = logicalResource;
        this.isVirtual = false;
    }

    public IndexWriter(DavResource resource, List<File> localResources, String logicalResource) {
        this.logicalResource = logicalResource;
        this.localResources = localResources;
        this.isVirtual = true;
    }

    public void write(OutputContext outputContext) {
        outputContext.setModificationTime(new Date().getTime());
        outputContext.setContentType("text/html");
        outputContext.setETag("");
        if (outputContext.hasStream()) {
            PrintWriter writer = new PrintWriter(outputContext.getOutputStream());
            this.writeDocumentStart(writer);
            this.writeHyperlinks(writer);
            this.writeDocumentEnd(writer);
            writer.flush();
            writer.close();
        }
    }

    private void writeDocumentStart(PrintWriter writer) {
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>Collection: /" + this.logicalResource + "</title>");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("<h3>Collection: /" + this.logicalResource + "</h3>");
        if (this.logicalResource.length() > 0) {
            File file = new File(this.logicalResource);
            String parentName = file.getParent() == null ? "/" : file.getParent();
            parentName = StringUtils.replace((String)parentName, (String)"\\", (String)"/");
            writer.println("<ul>");
            writer.println("<li><a href=\"../\">" + parentName + "</a> <i><small>(Parent)</small></i></li>");
            writer.println("</ul>");
        }
        writer.println("<ul>");
    }

    private void writeDocumentEnd(PrintWriter writer) {
        writer.println("</ul>");
        writer.println("</body>");
        writer.println("</html>");
    }

    private void writeHyperlinks(PrintWriter writer) {
        if (!this.isVirtual) {
            for (File localResource : this.localResources) {
                ArrayList<File> files = new ArrayList<File>(Arrays.asList(localResource.listFiles()));
                Collections.sort(files);
                for (File file : files) {
                    this.writeHyperlink(writer, file.getName(), file.isDirectory());
                }
            }
        } else {
            HashMap<String, List<String>> uniqueChildFiles = new HashMap<String, List<String>>();
            ArrayList<String> sortedList = new ArrayList<String>();
            for (File resource : this.localResources) {
                ArrayList<File> files = new ArrayList<File>(Arrays.asList(resource.listFiles()));
                for (File file : files) {
                    List<String> mergedChildFiles = new ArrayList<String>();
                    if (uniqueChildFiles.get(file.getName()) == null) {
                        mergedChildFiles.add(file.getAbsolutePath());
                    } else {
                        mergedChildFiles = (List)uniqueChildFiles.get(file.getName());
                        if (!mergedChildFiles.contains(file.getAbsolutePath())) {
                            mergedChildFiles.add(file.getAbsolutePath());
                        }
                    }
                    uniqueChildFiles.put(file.getName(), mergedChildFiles);
                    sortedList.add(file.getName());
                }
            }
            Collections.sort(sortedList);
            ArrayList<String> written = new ArrayList<String>();
            for (String fileName : sortedList) {
                List childFilesFromMap = (List)uniqueChildFiles.get(fileName);
                for (String childFilePath : childFilesFromMap) {
                    File childFile = new File(childFilePath);
                    if (written.contains(childFile.getName())) continue;
                    written.add(childFile.getName());
                    this.writeHyperlink(writer, fileName, childFile.isDirectory());
                }
            }
        }
    }

    private void writeHyperlink(PrintWriter writer, String resourceName, boolean directory) {
        if (directory) {
            writer.println("<li><a href=\"" + resourceName + "/\">" + resourceName + "</a></li>");
        } else {
            writer.println("<li><a href=\"" + resourceName + "\">" + resourceName + "</a></li>");
        }
    }
}

