/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.dependency.tree.maven2;

import java.util.List;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.maven2.model.TreeEntry;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class TreeDependencyNodeVisitor
implements DependencyVisitor {
    final List<TreeEntry> treeEntries;
    private TreeEntry currentEntry;
    private DependencyNode firstDependencyNode;

    public TreeDependencyNodeVisitor(List<TreeEntry> treeEntries) {
        this.treeEntries = treeEntries;
    }

    public boolean visitEnter(DependencyNode dependencyNode) {
        TreeEntry entry = new TreeEntry((Artifact)this.getModelMapper().map((Object)dependencyNode.getDependency().getArtifact(), Artifact.class));
        entry.getArtifact().setScope(dependencyNode.getDependency().getScope());
        entry.setParent(this.currentEntry);
        this.currentEntry = entry;
        if (this.firstDependencyNode == null) {
            this.firstDependencyNode = dependencyNode;
            this.treeEntries.add(this.currentEntry);
        } else {
            this.currentEntry.getParent().getChilds().add(this.currentEntry);
        }
        return true;
    }

    public boolean visitLeave(DependencyNode dependencyNode) {
        this.currentEntry = this.currentEntry.getParent();
        return true;
    }

    protected ModelMapper getModelMapper() {
        return ModelMapperHolder.MODEL_MAPPER;
    }

    private static class ModelMapperHolder {
        private static ModelMapper MODEL_MAPPER = new ModelMapper();

        private ModelMapperHolder() {
        }

        static {
            MODEL_MAPPER.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        }
    }
}

