/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content.maven2;

import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.content.PathParser;
import org.apache.archiva.repository.content.legacy.LegacyPathParser;
import org.apache.archiva.repository.content.legacy.ManagedLegacyRepositoryContent;
import org.apache.archiva.repository.content.maven2.DefaultPathParser;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.StringUtils;

public class RepositoryRequest {
    private PathParser defaultPathParser = new DefaultPathParser();
    private PathParser legacyPathParser;

    public RepositoryRequest(LegacyPathParser legacyPathParser) {
        this.legacyPathParser = legacyPathParser;
    }

    public ArtifactReference toArtifactReference(String requestedPath) throws LayoutException {
        if (StringUtils.isBlank((String)requestedPath)) {
            throw new LayoutException("Blank request path is not a valid.");
        }
        String path = requestedPath;
        while (path.startsWith("/")) {
            if (!"/".equals(path = path.substring(1))) continue;
            throw new LayoutException("Invalid request path: Slash only.");
        }
        if (this.isDefault(path)) {
            return this.defaultPathParser.toArtifactReference(path);
        }
        if (this.isLegacy(path)) {
            return this.legacyPathParser.toArtifactReference(path);
        }
        throw new LayoutException("Not a valid request path layout, too short.");
    }

    public boolean isMetadata(String requestedPath) {
        return requestedPath.endsWith("/maven-metadata.xml");
    }

    public boolean isArchetypeCatalog(String requestedPath) {
        return requestedPath.endsWith("/archetype-catalog.xml");
    }

    public boolean isSupportFile(String requestedPath) {
        int idx = requestedPath.lastIndexOf(46);
        if (idx <= 0) {
            return false;
        }
        String ext = requestedPath.substring(idx);
        return ".sha1".equals(ext) || ".md5".equals(ext) || ".asc".equals(ext) || ".pgp".equals(ext);
    }

    public boolean isMetadataSupportFile(String requestedPath) {
        String basefilePath;
        return this.isSupportFile(requestedPath) && this.isMetadata(basefilePath = StringUtils.substring((String)requestedPath, (int)0, (int)requestedPath.lastIndexOf(46)));
    }

    public boolean isDefault(String requestedPath) {
        if (StringUtils.isBlank((String)requestedPath)) {
            return false;
        }
        String[] pathParts = StringUtils.splitPreserveAllTokens((String)requestedPath, (char)'/');
        if (pathParts.length > 3) {
            return true;
        }
        if (pathParts.length == 3) {
            String base;
            if (this.isMetadata(requestedPath)) {
                return true;
            }
            int idx = requestedPath.lastIndexOf(46);
            return idx > 0 && this.isMetadata(base = requestedPath.substring(0, idx)) && this.isSupportFile(requestedPath);
        }
        return false;
    }

    public boolean isLegacy(String requestedPath) {
        if (StringUtils.isBlank((String)requestedPath)) {
            return false;
        }
        String[] pathParts = StringUtils.splitPreserveAllTokens((String)requestedPath, (char)'/');
        return pathParts.length == 3;
    }

    public String toNativePath(String requestedPath, ManagedRepositoryContent repository) throws LayoutException {
        if (StringUtils.isBlank((String)requestedPath)) {
            throw new LayoutException("Request Path is blank.");
        }
        String referencedResource = requestedPath;
        String supportfile = "";
        if (this.isSupportFile(requestedPath)) {
            int idx = requestedPath.lastIndexOf(46);
            referencedResource = requestedPath.substring(0, idx);
            supportfile = requestedPath.substring(idx);
        }
        if (this.isMetadata(referencedResource)) {
            if (repository instanceof ManagedLegacyRepositoryContent) {
                throw new LayoutException("Cannot translate metadata request to legacy layout.");
            }
            return requestedPath;
        }
        ArtifactReference ref = this.toArtifactReference(referencedResource);
        String adjustedPath = repository.toPath(ref);
        return adjustedPath + supportfile;
    }
}

