/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.atlas.AtlasException;
import org.apache.atlas.security.InMemoryJAASConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationProperties
extends PropertiesConfiguration {
    public static final String ATLAS_CONFIGURATION_DIRECTORY_PROPERTY = "atlas.conf";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String APPLICATION_PROPERTIES = "atlas-application.properties";
    private static volatile Configuration instance = null;

    private ApplicationProperties(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forceReload() {
        if (instance == null) return;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance == null) return;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration get() throws AtlasException {
        if (instance != null) return instance;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance != null) return instance;
            instance = ApplicationProperties.get(APPLICATION_PROPERTIES);
            InMemoryJAASConfiguration.init(instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Configuration get(String fileName) throws AtlasException {
        String confLocation = System.getProperty(ATLAS_CONFIGURATION_DIRECTORY_PROPERTY);
        try {
            URL url = null;
            if (confLocation == null) {
                LOG.info("Looking for {} in classpath", (Object)fileName);
                url = ApplicationProperties.class.getClassLoader().getResource(fileName);
                if (url == null) {
                    LOG.info("Looking for /{} in classpath", (Object)fileName);
                    url = ApplicationProperties.class.getClassLoader().getResource("/" + fileName);
                }
            } else {
                url = new File(confLocation, fileName).toURI().toURL();
            }
            LOG.info("Loading {} from {}", (Object)fileName, (Object)url);
            Configuration configuration = new ApplicationProperties(url).interpolatedConfiguration();
            ApplicationProperties.logConfiguration(configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new AtlasException("Failed to load application properties", e);
        }
    }

    private static void logConfiguration(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            Iterator keys = configuration.getKeys();
            LOG.debug("Configuration loaded:");
            while (keys.hasNext()) {
                String key = (String)keys.next();
                LOG.debug("{} = {}", (Object)key, configuration.getProperty(key));
            }
        }
    }

    public static Configuration getSubsetConfiguration(Configuration inConf, String prefix) {
        return inConf.subset(prefix);
    }

    public static Class getClass(Configuration configuration, String propertyName, String defaultValue, Class assignableClass) throws AtlasException {
        try {
            String propertyValue = configuration.getString(propertyName, defaultValue);
            Class<?> clazz = Class.forName(propertyValue);
            if (assignableClass == null || assignableClass.isAssignableFrom(clazz)) {
                return clazz;
            }
            String message = "Class " + clazz.getName() + " specified in property " + propertyName + " is not assignable to class " + assignableClass.getName();
            LOG.error(message);
            throw new AtlasException(message);
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public static InputStream getFileAsInputStream(Configuration configuration, String propertyName, String defaultFileName) throws AtlasException {
        File fileToLoad = null;
        String fileName = configuration.getString(propertyName);
        if (fileName == null) {
            if (defaultFileName == null) {
                throw new AtlasException(propertyName + " property not set and no default value specified");
            }
            fileName = defaultFileName;
            String atlasConfDir = System.getProperty(ATLAS_CONFIGURATION_DIRECTORY_PROPERTY);
            fileToLoad = atlasConfDir != null ? new File(atlasConfDir, fileName) : new File(fileName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} property not set - defaulting to {}", (Object)propertyName, (Object)fileToLoad.getPath());
            }
        } else {
            fileToLoad = new File(fileName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using {} property setting: {}", (Object)propertyName, (Object)fileToLoad.getPath());
            }
        }
        InputStream inStr = null;
        if (fileToLoad.exists()) {
            try {
                inStr = new FileInputStream(fileToLoad);
            }
            catch (FileNotFoundException e) {
                throw new AtlasException("Error loading file " + fileName, e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded file from : {}", (Object)fileToLoad.getPath());
            }
        } else {
            inStr = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (inStr == null) {
                String msg = fileName + " not found in file system or as class loader resource";
                LOG.error(msg);
                throw new AtlasException(msg);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded {} as resource from : {}", (Object)fileName, (Object)Thread.currentThread().getContextClassLoader().getResource(fileName).toString());
            }
        }
        return inStr;
    }
}

