/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.apache.atlas.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Services {
    public static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private final Set<Service> services;

    @Inject
    public Services(Set<Service> services) {
        this.services = services;
    }

    public void start() {
        try {
            for (Service service : this.services) {
                LOG.info("Starting service {}", (Object)service.getClass().getName());
                service.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        for (Service service : this.services) {
            LOG.info("Stopping service {}", (Object)service.getClass().getName());
            try {
                service.stop();
            }
            catch (Throwable e) {
                LOG.warn("Error stopping service {}", (Object)service.getClass().getName(), (Object)e);
            }
        }
    }
}

