/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.discovery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchParameters {
    private String query;
    private String typeName;
    private String classification;
    private boolean excludeDeletedEntities;
    private int limit;
    private int offset;
    private FilterCriteria entityFilters;
    private FilterCriteria tagFilters;
    private Set<String> attributes;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public boolean getExcludeDeletedEntities() {
        return this.excludeDeletedEntities;
    }

    public void setExcludeDeletedEntities(boolean excludeDeletedEntities) {
        this.excludeDeletedEntities = excludeDeletedEntities;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public FilterCriteria getEntityFilters() {
        return this.entityFilters;
    }

    public void setEntityFilters(FilterCriteria entityFilters) {
        this.entityFilters = entityFilters;
    }

    public FilterCriteria getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(FilterCriteria tagFilters) {
        this.tagFilters = tagFilters;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParameters that = (SearchParameters)o;
        return this.excludeDeletedEntities == that.excludeDeletedEntities && this.limit == that.limit && this.offset == that.offset && Objects.equals(this.query, that.query) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.classification, that.classification) && Objects.equals(this.entityFilters, that.entityFilters) && Objects.equals(this.tagFilters, that.tagFilters) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.typeName, this.classification, this.excludeDeletedEntities, this.limit, this.offset, this.entityFilters, this.tagFilters, this.attributes);
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append('{');
        sb.append("query='").append(this.query).append('\'');
        sb.append(", typeName='").append(this.typeName).append('\'');
        sb.append(", classification='").append(this.classification).append('\'');
        sb.append(", excludeDeletedEntities=").append(this.excludeDeletedEntities);
        sb.append(", limit=").append(this.limit);
        sb.append(", offset=").append(this.offset);
        sb.append(", entityFilters=").append(this.entityFilters);
        sb.append(", tagFilters=").append(this.tagFilters);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum Operator {
        LT(new String[]{"<", "lt"}),
        GT(new String[]{">", "gt"}),
        LTE(new String[]{"<=", "lte"}),
        GTE(new String[]{">=", "gte"}),
        EQ(new String[]{"eq", "="}),
        NEQ(new String[]{"neq", "!="}),
        IN(new String[]{"in", "IN"}),
        LIKE(new String[]{"like", "LIKE"}),
        STARTS_WITH(new String[]{"startsWith", "STARTSWITH", "begins_with", "BEGINS_WITH"}),
        ENDS_WITH(new String[]{"endsWith", "ENDSWITH", "ends_with", "BEGINS_WITH"}),
        CONTAINS(new String[]{"contains", "CONTAINS"});

        static final Map<String, Operator> operatorsMap;
        private String[] symbols;

        private Operator(String[] symbols) {
            this.symbols = symbols;
        }

        @JsonCreator
        public static Operator fromString(String symbol) {
            return operatorsMap.get(symbol);
        }

        @JsonValue
        public String getSymbol() {
            return this.symbols[0];
        }

        public String[] getSymbols() {
            return this.symbols;
        }

        public String toString() {
            return this.getSymbol();
        }

        static {
            operatorsMap = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                for (String s : operator.symbols) {
                    operatorsMap.put(s, operator);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FilterCriteria {
        private String attributeName;
        private Operator operator;
        private String attributeValue;
        private Condition condition;
        private List<FilterCriteria> criterion;

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public List<FilterCriteria> getCriterion() {
            return this.criterion;
        }

        public void setCriterion(List<FilterCriteria> criterion) {
            this.criterion = criterion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterCriteria that = (FilterCriteria)o;
            return Objects.equals(this.attributeName, that.attributeName) && Objects.equals((Object)this.operator, (Object)that.operator) && Objects.equals(this.attributeValue, that.attributeValue) && this.condition == that.condition && Objects.equals(this.criterion, that.criterion);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.attributeName, this.operator, this.attributeValue, this.condition, this.criterion});
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append('{');
            sb.append("attributeName='").append(this.attributeName).append('\'');
            sb.append(", operator=").append((Object)this.operator);
            sb.append(", attributeValue='").append(this.attributeValue).append('\'');
            sb.append(", condition=").append((Object)this.condition);
            sb.append(", criterion=").append(this.criterion);
            sb.append('}');
            return sb;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public static enum Condition {
            AND,
            OR;

        }
    }
}

