/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasImportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TRANSFORMS_KEY = "transforms";
    private static final String START_POSITION_KEY = "startPosition";
    private static final String START_GUID_KEY = "startGuid";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String UPDATE_TYPE_DEFINITION_KEY = "updateTypeDefinition";
    private Map<String, String> options = new HashMap<String, String>();

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasImportRequest{");
        sb.append("options={");
        AtlasBaseTypeDef.dumpObjects(this.options, sb);
        sb.append("}");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonIgnore
    public String getStartGuid() {
        return this.getOptionForKey(START_GUID_KEY);
    }

    @JsonIgnore
    public String getFileName() {
        return this.getOptionForKey(FILE_NAME_KEY);
    }

    @JsonIgnore
    public void setFileName(String fileName) {
        this.setOption(FILE_NAME_KEY, fileName);
    }

    @JsonIgnore
    public String getStartPosition() {
        return this.getOptionForKey(START_POSITION_KEY);
    }

    @JsonIgnore
    public String getUpdateTypeDefs() {
        return this.getOptionForKey(UPDATE_TYPE_DEFINITION_KEY);
    }

    private String getOptionForKey(String key) {
        if (this.options == null || !this.options.containsKey(key)) {
            return null;
        }
        return this.options.get(key);
    }

    @JsonAnySetter
    public void setOption(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, value);
    }
}

