/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntity
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private Status status = Status.ACTIVE;
    private String createdBy = null;
    private String updatedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private Long version = 0L;
    private List<AtlasClassification> classifications;
    @JsonIgnore
    private static AtomicLong s_nextId = new AtomicLong(System.nanoTime());

    public AtlasEntity() {
        this(null, null);
    }

    public AtlasEntity(String typeName) {
        this(typeName, null);
    }

    public AtlasEntity(AtlasEntityDef entityDef) {
        this(entityDef != null ? entityDef.getName() : null, null);
    }

    public AtlasEntity(String typeName, String attrName, Object attrValue) {
        super(typeName, attrName, attrValue);
        this.init();
    }

    public AtlasEntity(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.init();
    }

    public AtlasEntity(AtlasEntity other) {
        super(other);
        if (other != null) {
            this.setGuid(other.getGuid());
            this.setStatus(other.getStatus());
            this.setCreatedBy(other.getCreatedBy());
            this.setUpdatedBy(other.getUpdatedBy());
            this.setCreateTime(other.getCreateTime());
            this.setUpdateTime(other.getUpdateTime());
            this.setVersion(other.getVersion());
            this.setClassifications(other.getClassifications());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
    }

    private void init() {
        this.setGuid(AtlasEntity.nextInternalId());
        this.setStatus(null);
        this.setCreatedBy(null);
        this.setUpdatedBy(null);
        this.setCreateTime(null);
        this.setUpdateTime(null);
        this.setClassifications(null);
    }

    private static String nextInternalId() {
        return "-" + Long.toString(s_nextId.getAndIncrement());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntity{");
        super.toString(sb);
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append(", createdBy='").append(this.createdBy).append('\'');
        sb.append(", updatedBy='").append(this.updatedBy).append('\'');
        AtlasEntity.dumpDateField(", createTime=", this.createTime, sb);
        AtlasEntity.dumpDateField(", updateTime=", this.updateTime, sb);
        sb.append(", version=").append(this.version);
        sb.append(", classifications=[");
        AtlasBaseTypeDef.dumpObjects(this.classifications, sb);
        sb.append(']');
        sb.append(", ");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntity that = (AtlasEntity)o;
        return Objects.equals(this.guid, that.guid) && this.status == that.status && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.updatedBy, that.updatedBy) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.version, that.version) && Objects.equals(this.classifications, that.classifications);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.status, this.createdBy, this.updatedBy, this.createTime, this.updateTime, this.version, this.classifications});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntity.class})
    public static class AtlasEntities
    extends PList<AtlasEntity> {
        private static final long serialVersionUID = 1L;

        public AtlasEntities() {
        }

        public AtlasEntities(List<AtlasEntity> list) {
            super(list);
        }

        public AtlasEntities(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntitiesWithExtInfo
    extends AtlasEntityExtInfo {
        private static final long serialVersionUID = 1L;
        private List<AtlasEntity> entities;

        public AtlasEntitiesWithExtInfo() {
            this(null, null);
        }

        public AtlasEntitiesWithExtInfo(AtlasEntity entity) {
            this(Arrays.asList(entity), null);
        }

        public AtlasEntitiesWithExtInfo(List<AtlasEntity> entities) {
            this(entities, null);
        }

        public AtlasEntitiesWithExtInfo(AtlasEntityWithExtInfo entity) {
            this(Arrays.asList(entity.getEntity()), entity);
        }

        public AtlasEntitiesWithExtInfo(List<AtlasEntity> entities, AtlasEntityExtInfo extInfo) {
            super(extInfo);
            this.entities = entities;
        }

        public List<AtlasEntity> getEntities() {
            return this.entities;
        }

        public void setEntities(List<AtlasEntity> entities) {
            this.entities = entities;
        }

        @Override
        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            AtlasEntity ret = super.getEntity(guid);
            if (ret == null && CollectionUtils.isNotEmpty(this.entities)) {
                for (AtlasEntity entity : this.entities) {
                    if (!StringUtils.equals((String)guid, (String)entity.getGuid())) continue;
                    ret = entity;
                    break;
                }
            }
            return ret;
        }

        public void addEntity(AtlasEntity entity) {
            List<AtlasEntity> entities = this.entities;
            if (entities == null) {
                this.entities = entities = new ArrayList<AtlasEntity>();
            }
            entities.add(entity);
        }

        public void removeEntity(AtlasEntity entity) {
            List<AtlasEntity> entities = this.entities;
            if (entity != null && entities != null) {
                entities.remove(entity);
            }
        }

        @Override
        public void compact() {
            super.compact();
            if (CollectionUtils.isNotEmpty(this.entities)) {
                for (AtlasEntity entity : this.entities) {
                    this.removeReferredEntity(entity.getGuid());
                }
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntitiesWithExtInfo{");
            sb.append("entities=[");
            AtlasBaseTypeDef.dumpObjects(this.entities, sb);
            sb.append("],");
            super.toString(sb);
            sb.append("}");
            return sb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntitiesWithExtInfo that = (AtlasEntitiesWithExtInfo)o;
            return Objects.equals(this.entities, that.entities);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entities);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntityWithExtInfo
    extends AtlasEntityExtInfo {
        private static final long serialVersionUID = 1L;
        private AtlasEntity entity;

        public AtlasEntityWithExtInfo() {
            this(null, null);
        }

        public AtlasEntityWithExtInfo(AtlasEntity entity) {
            this(entity, null);
        }

        public AtlasEntityWithExtInfo(AtlasEntity entity, AtlasEntityExtInfo extInfo) {
            super(extInfo);
            this.entity = entity;
        }

        public AtlasEntity getEntity() {
            return this.entity;
        }

        public void setEntity(AtlasEntity entity) {
            this.entity = entity;
        }

        @Override
        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            AtlasEntity ret = super.getEntity(guid);
            if (ret == null && this.entity != null && StringUtils.equals((String)guid, (String)this.entity.getGuid())) {
                ret = this.entity;
            }
            return ret;
        }

        @Override
        @JsonIgnore
        public void compact() {
            super.compact();
            if (this.entity != null) {
                this.removeEntity(this.entity.getGuid());
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntityWithExtInfo{");
            sb.append("entity=").append(this.entity).append(",");
            super.toString(sb);
            sb.append("}");
            return sb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntityWithExtInfo that = (AtlasEntityWithExtInfo)o;
            return Objects.equals(this.entity, that.entity);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entity);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntityExtInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, AtlasEntity> referredEntities;

        public AtlasEntityExtInfo() {
            this.setReferredEntities(null);
        }

        public AtlasEntityExtInfo(AtlasEntity referredEntity) {
            this.addReferredEntity(referredEntity);
        }

        public AtlasEntityExtInfo(Map<String, AtlasEntity> referredEntities) {
            this.setReferredEntities(referredEntities);
        }

        public AtlasEntityExtInfo(AtlasEntityExtInfo other) {
            if (other != null) {
                this.setReferredEntities(other.getReferredEntities());
            }
        }

        public Map<String, AtlasEntity> getReferredEntities() {
            return this.referredEntities;
        }

        public void setReferredEntities(Map<String, AtlasEntity> referredEntities) {
            this.referredEntities = referredEntities;
        }

        @JsonIgnore
        public final void addReferredEntity(AtlasEntity entity) {
            this.addReferredEntity(entity.getGuid(), entity);
        }

        @JsonIgnore
        public final void addReferredEntity(String guid, AtlasEntity entity) {
            Map<String, AtlasEntity> r = this.referredEntities;
            if (r == null) {
                this.referredEntities = r = new HashMap<String, AtlasEntity>();
            }
            if (guid != null) {
                r.put(guid, entity);
            }
        }

        @JsonIgnore
        public final AtlasEntity removeReferredEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.remove(guid) : null;
        }

        @JsonIgnore
        public final AtlasEntity getReferredEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.get(guid) : null;
        }

        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            return this.getReferredEntity(guid);
        }

        @JsonIgnore
        public AtlasEntity removeEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.remove(guid) : null;
        }

        public void updateEntityGuid(String oldGuid, String newGuid) {
            AtlasEntity entity = this.getEntity(oldGuid);
            if (entity != null) {
                entity.setGuid(newGuid);
                if (this.removeEntity(oldGuid) != null) {
                    this.addReferredEntity(newGuid, entity);
                }
            }
        }

        public boolean hasEntity(String guid) {
            return this.getEntity(guid) != null;
        }

        public void compact() {
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntityExtInfo{");
            sb.append("referredEntities={");
            AtlasBaseTypeDef.dumpObjects(this.referredEntities, sb);
            sb.append("}");
            sb.append("}");
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntityExtInfo that = (AtlasEntityExtInfo)o;
            return Objects.equals(this.referredEntities, that.referredEntities);
        }

        public int hashCode() {
            return Objects.hash(this.referredEntities);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }

    public static enum Status {
        ACTIVE,
        DELETED;

    }
}

