/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_DATE_FORMAT_STR = "yyyyMMdd-HH:mm:ss.SSS-Z";
    public static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z");
    private String typeName;
    private Map<String, Object> attributes;

    public AtlasStruct() {
        this(null, null);
    }

    public AtlasStruct(String typeName) {
        this(typeName, null);
    }

    public AtlasStruct(String typeName, Map<String, Object> attributes) {
        this.setTypeName(typeName);
        this.setAttributes(attributes);
    }

    public AtlasStruct(String typeName, String attrName, Object attrValue) {
        this.setTypeName(typeName);
        this.setAttribute(attrName, attrValue);
    }

    public AtlasStruct(AtlasStruct other) {
        if (other != null) {
            this.setTypeName(other.getTypeName());
            this.setAttributes(new HashMap<String, Object>(other.getAttributes()));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean hasAttribute(String name) {
        Map<String, Object> a = this.attributes;
        return a != null ? a.containsKey(name) : false;
    }

    public Object getAttribute(String name) {
        Map<String, Object> a = this.attributes;
        return a != null ? a.get(name) : null;
    }

    public void setAttribute(String name, Object value) {
        Map<String, Object> a = this.attributes;
        if (a != null) {
            a.put(name, value);
        } else {
            a = new HashMap<String, Object>();
            a.put(name, value);
            this.attributes = a;
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasStruct{");
        sb.append("typeName='").append(this.typeName).append('\'');
        sb.append(", attributes=[");
        AtlasStruct.dumpObjects(this.attributes, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasStruct that = (AtlasStruct)o;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.attributes);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static StringBuilder dumpModelObjects(Collection<? extends AtlasStruct> objList, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (CollectionUtils.isNotEmpty(objList)) {
            int i = 0;
            for (AtlasStruct atlasStruct : objList) {
                if (i > 0) {
                    sb.append(", ");
                }
                atlasStruct.toString(sb);
                ++i;
            }
        }
        return sb;
    }

    public static StringBuilder dumpObjects(Collection<?> objects, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (CollectionUtils.isNotEmpty(objects)) {
            int i = 0;
            for (Object obj : objects) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(obj);
                ++i;
            }
        }
        return sb;
    }

    public static StringBuilder dumpObjects(Map<?, ?> objects, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (MapUtils.isNotEmpty(objects)) {
            int i = 0;
            for (Map.Entry<?, ?> e : objects.entrySet()) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append(":").append(e.getValue());
                ++i;
            }
        }
        return sb;
    }

    public static StringBuilder dumpDateField(String prefix, Date value, StringBuilder sb) {
        sb.append(prefix);
        if (value == null) {
            sb.append(value);
        } else {
            sb.append(DATE_FORMATTER.format(value));
        }
        return sb;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasStruct.class})
    public static class AtlasStructs
    extends PList<AtlasStruct> {
        private static final long serialVersionUID = 1L;

        public AtlasStructs() {
        }

        public AtlasStructs(List<AtlasStruct> list) {
            super(list);
        }

        public AtlasStructs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

