/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityMutationResponse {
    private Map<EntityMutations.EntityOperation, List<AtlasEntityHeader>> mutatedEntities;
    private Map<String, String> guidAssignments;

    public EntityMutationResponse() {
    }

    public EntityMutationResponse(Map<EntityMutations.EntityOperation, List<AtlasEntityHeader>> mutatedEntities) {
        this.mutatedEntities = mutatedEntities;
    }

    public Map<EntityMutations.EntityOperation, List<AtlasEntityHeader>> getMutatedEntities() {
        return this.mutatedEntities;
    }

    public void setMutatedEntities(Map<EntityMutations.EntityOperation, List<AtlasEntityHeader>> mutatedEntities) {
        this.mutatedEntities = mutatedEntities;
    }

    public void setGuidAssignments(Map<String, String> guidAssignments) {
        this.guidAssignments = guidAssignments;
    }

    public Map<String, String> getGuidAssignments() {
        return this.guidAssignments;
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getEntitiesByOperation(EntityMutations.EntityOperation op) {
        if (this.mutatedEntities != null) {
            return this.mutatedEntities.get((Object)op);
        }
        return null;
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getCreatedEntities() {
        if (this.mutatedEntities != null) {
            return this.mutatedEntities.get((Object)EntityMutations.EntityOperation.CREATE);
        }
        return null;
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getUpdatedEntities() {
        if (this.mutatedEntities != null) {
            return this.mutatedEntities.get((Object)EntityMutations.EntityOperation.UPDATE);
        }
        return null;
    }

    public List<AtlasEntityHeader> getPartialUpdatedEntities() {
        if (this.mutatedEntities != null) {
            return this.mutatedEntities.get((Object)EntityMutations.EntityOperation.PARTIAL_UPDATE);
        }
        return null;
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getDeletedEntities() {
        if (this.mutatedEntities != null) {
            return this.mutatedEntities.get((Object)EntityMutations.EntityOperation.DELETE);
        }
        return null;
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstEntityCreated() {
        List<AtlasEntityHeader> entitiesByOperation = this.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE);
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            return entitiesByOperation.get(0);
        }
        return null;
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstEntityUpdated() {
        List<AtlasEntityHeader> entitiesByOperation = this.getEntitiesByOperation(EntityMutations.EntityOperation.UPDATE);
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            return entitiesByOperation.get(0);
        }
        return null;
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstEntityPartialUpdated() {
        List<AtlasEntityHeader> entitiesByOperation = this.getEntitiesByOperation(EntityMutations.EntityOperation.PARTIAL_UPDATE);
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            return entitiesByOperation.get(0);
        }
        return null;
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstCreatedEntityByTypeName(String typeName) {
        return this.getFirstEntityByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE), typeName);
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstDeletedEntityByTypeName(String typeName) {
        return this.getFirstEntityByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.DELETE), typeName);
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getCreatedEntitiesByTypeName(String typeName) {
        return this.getEntitiesByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE), typeName);
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getPartialUpdatedEntitiesByTypeName(String typeName) {
        return this.getEntitiesByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.PARTIAL_UPDATE), typeName);
    }

    @JsonIgnore
    public AtlasEntityHeader getCreatedEntityByTypeNameAndAttribute(String typeName, String attrName, String attrVal) {
        return this.getEntityByTypeAndUniqueAttribute(this.getEntitiesByOperation(EntityMutations.EntityOperation.CREATE), typeName, attrName, attrVal);
    }

    @JsonIgnore
    public AtlasEntityHeader getUpdatedEntityByTypeNameAndAttribute(String typeName, String attrName, String attrVal) {
        return this.getEntityByTypeAndUniqueAttribute(this.getEntitiesByOperation(EntityMutations.EntityOperation.UPDATE), typeName, attrName, attrVal);
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getUpdatedEntitiesByTypeName(String typeName) {
        return this.getEntitiesByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.UPDATE), typeName);
    }

    @JsonIgnore
    public List<AtlasEntityHeader> getDeletedEntitiesByTypeName(String typeName) {
        return this.getEntitiesByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.DELETE), typeName);
    }

    @JsonIgnore
    public AtlasEntityHeader getFirstUpdatedEntityByTypeName(String typeName) {
        return this.getFirstEntityByType(this.getEntitiesByOperation(EntityMutations.EntityOperation.UPDATE), typeName);
    }

    public void addEntity(EntityMutations.EntityOperation op, AtlasEntityHeader header) {
        List<AtlasEntityHeader> opEntities;
        if (this.mutatedEntities == null) {
            this.mutatedEntities = new HashMap<EntityMutations.EntityOperation, List<AtlasEntityHeader>>();
        }
        if ((opEntities = this.mutatedEntities.get((Object)op)) == null) {
            opEntities = new ArrayList<AtlasEntityHeader>();
            this.mutatedEntities.put(op, opEntities);
        }
        if (!this.entityHeaderExists(opEntities, header)) {
            opEntities.add(header);
        }
    }

    private boolean entityHeaderExists(List<AtlasEntityHeader> entityHeaders, AtlasEntityHeader newEntityHeader) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(entityHeaders) && newEntityHeader != null) {
            for (AtlasEntityHeader entityHeader : entityHeaders) {
                if (!StringUtils.equals((String)entityHeader.getGuid(), (String)newEntityHeader.getGuid())) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        AtlasBaseTypeDef.dumpObjects(this.mutatedEntities, sb);
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMutationResponse that = (EntityMutationResponse)o;
        return Objects.equals(this.mutatedEntities, that.mutatedEntities) && Objects.equals(this.guidAssignments, that.guidAssignments);
    }

    public int hashCode() {
        return Objects.hash(this.mutatedEntities, this.guidAssignments);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private AtlasEntityHeader getFirstEntityByType(List<AtlasEntityHeader> entitiesByOperation, String typeName) {
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            for (AtlasEntityHeader header : entitiesByOperation) {
                if (!header.getTypeName().equals(typeName)) continue;
                return header;
            }
        }
        return null;
    }

    private List<AtlasEntityHeader> getEntitiesByType(List<AtlasEntityHeader> entitiesByOperation, String typeName) {
        ArrayList<AtlasEntityHeader> ret = new ArrayList<AtlasEntityHeader>();
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            for (AtlasEntityHeader header : entitiesByOperation) {
                if (!header.getTypeName().equals(typeName)) continue;
                ret.add(header);
            }
        }
        return ret;
    }

    private AtlasEntityHeader getEntityByTypeAndUniqueAttribute(List<AtlasEntityHeader> entitiesByOperation, String typeName, String attrName, String attrVal) {
        if (entitiesByOperation != null && entitiesByOperation.size() > 0) {
            for (AtlasEntityHeader header : entitiesByOperation) {
                if (!header.getTypeName().equals(typeName) || attrVal == null || !attrVal.equals(header.getAttribute(attrName))) continue;
                return header;
            }
        }
        return null;
    }
}

