/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.legacy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityResult {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String OP_CREATED = "created";
    public static final String OP_UPDATED = "updated";
    public static final String OP_DELETED = "deleted";
    Map<String, List<String>> entities = new HashMap<String, List<String>>();

    public EntityResult() {
    }

    public EntityResult(List<String> created, List<String> updated, List<String> deleted) {
        this.set(OP_CREATED, created);
        this.set(OP_UPDATED, updated);
        this.set(OP_DELETED, deleted);
    }

    public void set(String type, List<String> list) {
        if (list != null && list.size() > 0) {
            this.entities.put(type, list);
        }
    }

    private List<String> get(String type) {
        List<String> list = this.entities.get(type);
        if (list == null) {
            list = new ArrayList<String>();
        }
        return list;
    }

    public Map<String, List<String>> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<String, List<String>> entities) {
        this.entities = entities;
    }

    @JsonIgnore
    public List<String> getCreatedEntities() {
        return this.get(OP_CREATED);
    }

    @JsonIgnore
    public List<String> getUpdateEntities() {
        return this.get(OP_UPDATED);
    }

    @JsonIgnore
    public List<String> getDeletedEntities() {
        return this.get(OP_DELETED);
    }

    public String toString() {
        return gson.toJson((Object)this);
    }

    public static EntityResult fromString(String json) {
        return (EntityResult)gson.fromJson(json, EntityResult.class);
    }
}

