/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasStructDef
extends AtlasBaseTypeDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AtlasAttributeDef> attributeDefs;

    public AtlasStructDef() {
        this((String)null, (String)null, (String)null, (List<AtlasAttributeDef>)null, (Map<String, String>)null);
    }

    public AtlasStructDef(String name) {
        this(name, null, null, null, null);
    }

    public AtlasStructDef(String name, String description) {
        this(name, description, null, null, null);
    }

    public AtlasStructDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null);
    }

    public AtlasStructDef(String name, String description, String typeVersion, List<AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, attributeDefs, null);
    }

    public AtlasStructDef(String name, String description, String typeVersion, List<AtlasAttributeDef> attributeDefs, Map<String, String> options) {
        this(TypeCategory.STRUCT, name, description, typeVersion, attributeDefs, options);
    }

    protected AtlasStructDef(TypeCategory category, String name, String description, String typeVersion, List<AtlasAttributeDef> attributeDefs, Map<String, String> options) {
        super(category, name, description, typeVersion, options);
        this.setAttributeDefs(attributeDefs);
    }

    public AtlasStructDef(AtlasStructDef other) {
        super(other);
        this.setAttributeDefs(other != null ? other.getAttributeDefs() : null);
    }

    public List<AtlasAttributeDef> getAttributeDefs() {
        return this.attributeDefs;
    }

    public void setAttributeDefs(List<AtlasAttributeDef> attributeDefs) {
        if (this.attributeDefs != null && this.attributeDefs == attributeDefs) {
            return;
        }
        if (CollectionUtils.isEmpty(attributeDefs)) {
            this.attributeDefs = new ArrayList<AtlasAttributeDef>();
        } else {
            ArrayList<AtlasAttributeDef> tmpList = new ArrayList<AtlasAttributeDef>(attributeDefs.size());
            HashSet<String> attribNames = new HashSet<String>();
            ListIterator<AtlasAttributeDef> iter = attributeDefs.listIterator(attributeDefs.size());
            while (iter.hasPrevious()) {
                AtlasAttributeDef attributeDef = iter.previous();
                String attribName = attributeDef != null ? attributeDef.getName() : null;
                if (attribName == null || attribNames.contains(attribName = attribName.toLowerCase())) continue;
                tmpList.add(new AtlasAttributeDef(attributeDef));
                attribNames.add(attribName);
            }
            Collections.reverse(tmpList);
            this.attributeDefs = tmpList;
        }
    }

    public AtlasAttributeDef getAttribute(String attrName) {
        return AtlasStructDef.findAttribute(this.attributeDefs, attrName);
    }

    public void addAttribute(AtlasAttributeDef attributeDef) {
        if (attributeDef == null) {
            return;
        }
        List<AtlasAttributeDef> a = this.attributeDefs;
        ArrayList<AtlasAttributeDef> tmpList = new ArrayList<AtlasAttributeDef>();
        if (CollectionUtils.isNotEmpty(a)) {
            for (AtlasAttributeDef existingAttrDef : a) {
                if (StringUtils.equalsIgnoreCase((String)existingAttrDef.getName(), (String)attributeDef.getName())) continue;
                tmpList.add(existingAttrDef);
            }
        }
        tmpList.add(new AtlasAttributeDef(attributeDef));
        this.attributeDefs = tmpList;
    }

    public void removeAttribute(String attrName) {
        List<AtlasAttributeDef> a = this.attributeDefs;
        if (AtlasStructDef.hasAttribute(a, attrName)) {
            ArrayList<AtlasAttributeDef> tmpList = new ArrayList<AtlasAttributeDef>();
            for (AtlasAttributeDef existingAttrDef : a) {
                if (StringUtils.equalsIgnoreCase((String)existingAttrDef.getName(), (String)attrName)) continue;
                tmpList.add(existingAttrDef);
            }
            this.attributeDefs = tmpList;
        }
    }

    public boolean hasAttribute(String attrName) {
        return this.getAttribute(attrName) != null;
    }

    private static boolean hasAttribute(List<AtlasAttributeDef> attributeDefs, String attrName) {
        return AtlasStructDef.findAttribute(attributeDefs, attrName) != null;
    }

    public static AtlasAttributeDef findAttribute(Collection<AtlasAttributeDef> attributeDefs, String attrName) {
        AtlasAttributeDef ret = null;
        if (CollectionUtils.isNotEmpty(attributeDefs)) {
            for (AtlasAttributeDef attributeDef : attributeDefs) {
                if (!StringUtils.equalsIgnoreCase((String)attributeDef.getName(), (String)attrName)) continue;
                ret = attributeDef;
                break;
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasStructDef{");
        super.toString(sb);
        sb.append(", attributeDefs=[");
        if (CollectionUtils.isNotEmpty(this.attributeDefs)) {
            int i = 0;
            for (AtlasAttributeDef attributeDef : this.attributeDefs) {
                attributeDef.toString(sb);
                if (i > 0) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasStructDef that = (AtlasStructDef)o;
        return Objects.equals(this.attributeDefs, that.attributeDefs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attributeDefs);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasStructDef.class})
    public static class AtlasStructDefs
    extends PList<AtlasStructDef> {
        private static final long serialVersionUID = 1L;

        public AtlasStructDefs() {
        }

        public AtlasStructDefs(List<AtlasStructDef> list) {
            super(list);
        }

        public AtlasStructDefs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasConstraintDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String CONSTRAINT_TYPE_OWNED_REF = "ownedRef";
        public static final String CONSTRAINT_TYPE_INVERSE_REF = "inverseRef";
        public static final String CONSTRAINT_PARAM_ATTRIBUTE = "attribute";
        private String type;
        private Map<String, Object> params;

        public AtlasConstraintDef() {
        }

        public AtlasConstraintDef(String type) {
            this(type, null);
        }

        public AtlasConstraintDef(String type, Map<String, Object> params) {
            this.type = type;
            if (params != null) {
                this.params = new HashMap<String, Object>(params);
            }
        }

        public AtlasConstraintDef(AtlasConstraintDef that) {
            if (that != null) {
                this.type = that.type;
                if (that.params != null) {
                    this.params = new HashMap<String, Object>(that.params);
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        @JsonIgnore
        public boolean isConstraintType(String name) {
            return StringUtils.equalsIgnoreCase((String)name, (String)this.type);
        }

        @JsonIgnore
        public Object getParam(String name) {
            Map<String, Object> params = this.params;
            return params != null ? params.get(name) : null;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasConstraintDef{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", params='").append(this.params).append('\'');
            sb.append('}');
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasConstraintDef that = (AtlasConstraintDef)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.params);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasAttributeDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int COUNT_NOT_SET = -1;
        private String name;
        private String typeName;
        private boolean isOptional;
        private Cardinality cardinality;
        private int valuesMinCount;
        private int valuesMaxCount;
        private boolean isUnique;
        private boolean isIndexable;
        private List<AtlasConstraintDef> constraints;

        public AtlasAttributeDef() {
            this(null, null);
        }

        public AtlasAttributeDef(String name, String typeName) {
            this(name, typeName, false, Cardinality.SINGLE, -1, -1, false, false, null);
        }

        public AtlasAttributeDef(String name, String typeName, boolean isOptional, Cardinality cardinality, int valuesMinCount, int valuesMaxCount, boolean isUnique, boolean isIndexable, List<AtlasConstraintDef> constraints) {
            this.setName(name);
            this.setTypeName(typeName);
            this.setIsOptional(isOptional);
            this.setCardinality(cardinality);
            this.setValuesMinCount(valuesMinCount);
            this.setValuesMaxCount(valuesMaxCount);
            this.setIsUnique(isUnique);
            this.setIsIndexable(isIndexable);
            this.setConstraints(constraints);
        }

        public AtlasAttributeDef(AtlasAttributeDef other) {
            if (other != null) {
                this.setName(other.getName());
                this.setTypeName(other.getTypeName());
                this.setIsOptional(other.getIsOptional());
                this.setCardinality(other.getCardinality());
                this.setValuesMinCount(other.getValuesMinCount());
                this.setValuesMaxCount(other.getValuesMaxCount());
                this.setIsUnique(other.getIsUnique());
                this.setIsIndexable(other.getIsIndexable());
                this.setConstraints(other.getConstraints());
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public boolean getIsOptional() {
            return this.isOptional;
        }

        public void setIsOptional(boolean optional) {
            this.isOptional = optional;
        }

        public void setCardinality(Cardinality cardinality) {
            this.cardinality = cardinality;
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public int getValuesMinCount() {
            return this.valuesMinCount;
        }

        public void setValuesMinCount(int valuesMinCount) {
            this.valuesMinCount = valuesMinCount;
        }

        public int getValuesMaxCount() {
            return this.valuesMaxCount;
        }

        public void setValuesMaxCount(int valuesMaxCount) {
            this.valuesMaxCount = valuesMaxCount;
        }

        public boolean getIsUnique() {
            return this.isUnique;
        }

        public void setIsUnique(boolean unique) {
            this.isUnique = unique;
        }

        public boolean getIsIndexable() {
            return this.isIndexable;
        }

        public void setIsIndexable(boolean idexable) {
            this.isIndexable = idexable;
        }

        public List<AtlasConstraintDef> getConstraints() {
            return this.constraints;
        }

        public void setConstraints(List<AtlasConstraintDef> constraints) {
            if (this.constraints != null && this.constraints == constraints) {
                return;
            }
            this.constraints = CollectionUtils.isEmpty(constraints) ? null : new ArrayList<AtlasConstraintDef>(constraints);
        }

        public void addConstraint(AtlasConstraintDef constraintDef) {
            List<AtlasConstraintDef> cDefs = this.constraints;
            if (cDefs == null) {
                this.constraints = cDefs = new ArrayList<AtlasConstraintDef>();
            }
            cDefs.add(constraintDef);
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasAttributeDef{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", typeName='").append(this.typeName).append('\'');
            sb.append(", getIsOptional=").append(this.isOptional);
            sb.append(", cardinality=").append((Object)this.cardinality);
            sb.append(", valuesMinCount=").append(this.valuesMinCount);
            sb.append(", valuesMaxCount=").append(this.valuesMaxCount);
            sb.append(", isUnique=").append(this.isUnique);
            sb.append(", isIndexable=").append(this.isIndexable);
            sb.append(", constraints=[");
            if (CollectionUtils.isNotEmpty(this.constraints)) {
                int i = 0;
                for (AtlasConstraintDef constraintDef : this.constraints) {
                    constraintDef.toString(sb);
                    if (i > 0) {
                        sb.append(", ");
                    }
                    ++i;
                }
            }
            sb.append("]");
            sb.append('}');
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasAttributeDef that = (AtlasAttributeDef)o;
            return this.isOptional == that.isOptional && this.valuesMinCount == that.valuesMinCount && this.valuesMaxCount == that.valuesMaxCount && this.isUnique == that.isUnique && this.isIndexable == that.isIndexable && Objects.equals(this.name, that.name) && Objects.equals(this.typeName, that.typeName) && this.cardinality == that.cardinality && Objects.equals(this.constraints, that.constraints);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.typeName, this.isOptional, this.cardinality, this.valuesMinCount, this.valuesMaxCount, this.isUnique, this.isIndexable, this.constraints});
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public static enum Cardinality {
            SINGLE,
            LIST,
            SET;

        }
    }
}

