/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasArrayType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasArrayType.class);
    private final String elementTypeName;
    private int minCount;
    private int maxCount;
    private AtlasType elementType;

    public AtlasArrayType(AtlasType elementType) {
        this(elementType, -1, -1);
    }

    public AtlasArrayType(AtlasType elementType, int minCount, int maxCount) {
        super(AtlasBaseTypeDef.getArrayTypeName(elementType.getTypeName()), TypeCategory.ARRAY);
        this.elementTypeName = elementType.getTypeName();
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.elementType = elementType;
    }

    public AtlasArrayType(String elementTypeName) {
        this(elementTypeName, -1, -1);
    }

    public AtlasArrayType(String elementTypeName, int minCount, int maxCount) {
        super(AtlasBaseTypeDef.getArrayTypeName(elementTypeName), TypeCategory.ARRAY);
        this.elementTypeName = elementTypeName;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.elementType = null;
    }

    public AtlasArrayType(String elementTypeName, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this(elementTypeName, -1, -1, typeRegistry);
    }

    public AtlasArrayType(String elementTypeName, int minCount, int maxCount, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(AtlasBaseTypeDef.getArrayTypeName(elementTypeName), TypeCategory.ARRAY);
        this.elementTypeName = elementTypeName;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.resolveReferences(typeRegistry);
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public AtlasType getElementType() {
        return this.elementType;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this.elementType = typeRegistry.getType(this.elementTypeName);
    }

    @Override
    public Collection<?> createDefaultValue() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(this.elementType.createDefaultValue());
        if (this.minCount != -1) {
            for (int i = 1; i < this.minCount; ++i) {
                ret.add(this.elementType.createDefaultValue());
            }
        }
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    return false;
                }
                for (Object element : objList) {
                    if (this.elementType.isValidValue(element)) continue;
                    return false;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    return false;
                }
                for (int i = 0; i < arrayLen; ++i) {
                    if (this.elementType.isValidValue(Array.get(obj, i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    return false;
                }
                for (Object element : objList) {
                    if (this.elementType.isValidValueForUpdate(element)) continue;
                    return false;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    return false;
                }
                for (int i = 0; i < arrayLen; ++i) {
                    if (this.elementType.isValidValueForUpdate(Array.get(obj, i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<?> getNormalizedValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List || obj instanceof Set) {
            ArrayList<Object> ret = new ArrayList<Object>();
            Collection objList = (Collection)obj;
            if (!this.isValidElementCount(objList.size())) {
                return null;
            }
            for (Object element : objList) {
                if (element != null) {
                    Object normalizedValue = this.elementType.getNormalizedValue(element);
                    if (normalizedValue != null) {
                        ret.add(normalizedValue);
                        continue;
                    }
                    return null;
                }
                ret.add(element);
            }
            return ret;
        }
        if (obj.getClass().isArray()) {
            ArrayList<Object> ret = new ArrayList<Object>();
            int arrayLen = Array.getLength(obj);
            if (!this.isValidElementCount(arrayLen)) {
                return null;
            }
            for (int i = 0; i < arrayLen; ++i) {
                Object element = Array.get(obj, i);
                if (element != null) {
                    Object normalizedValue = this.elementType.getNormalizedValue(element);
                    if (normalizedValue != null) {
                        ret.add(normalizedValue);
                        continue;
                    }
                    return null;
                }
                ret.add(element);
            }
            return ret;
        }
        return null;
    }

    @Override
    public Collection<?> getNormalizedValueForUpdate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List || obj instanceof Set) {
            ArrayList<Object> ret = new ArrayList<Object>();
            Collection objList = (Collection)obj;
            if (!this.isValidElementCount(objList.size())) {
                return null;
            }
            for (Object element : objList) {
                if (element != null) {
                    Object normalizedValue = this.elementType.getNormalizedValueForUpdate(element);
                    if (normalizedValue != null) {
                        ret.add(normalizedValue);
                        continue;
                    }
                    return null;
                }
                ret.add(element);
            }
            return ret;
        }
        if (obj.getClass().isArray()) {
            ArrayList<Object> ret = new ArrayList<Object>();
            int arrayLen = Array.getLength(obj);
            if (!this.isValidElementCount(arrayLen)) {
                return null;
            }
            for (int i = 0; i < arrayLen; ++i) {
                Object element = Array.get(obj, i);
                if (element != null) {
                    Object normalizedValue = this.elementType.getNormalizedValueForUpdate(element);
                    if (normalizedValue != null) {
                        ret.add(normalizedValue);
                        continue;
                    }
                    return null;
                }
                ret.add(element);
            }
            return ret;
        }
        return null;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + objList.size() + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                int idx = 0;
                for (Object element : objList) {
                    ret = this.elementType.validateValue(element, objName + "[" + idx + "]", messages) && ret;
                    ++idx;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + arrayLen + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                for (int i = 0; i < arrayLen; ++i) {
                    ret = this.elementType.validateValue(Array.get(obj, i), objName + "[" + i + "]", messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + objList.size() + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                int idx = 0;
                for (Object element : objList) {
                    ret = this.elementType.validateValueForUpdate(element, objName + "[" + idx + "]", messages) && ret;
                    ++idx;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + arrayLen + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                for (int i = 0; i < arrayLen; ++i) {
                    ret = this.elementType.validateValueForUpdate(Array.get(obj, i), objName + "[" + i + "]", messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasType elementAttributeType = this.elementType.getTypeForAttribute();
        if (elementAttributeType == this.elementType) {
            return this;
        }
        AtlasArrayType attributeType = new AtlasArrayType(elementAttributeType, this.minCount, this.maxCount);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    private boolean isValidElementCount(int count) {
        if (this.minCount != -1 && count < this.minCount) {
            return false;
        }
        return this.maxCount == -1 || count <= this.maxCount;
    }
}

