/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.atlas.entitytransform.Action;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.Condition;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.model.impexp.AttributeTransform;
import org.apache.commons.collections.MapUtils;

public class AtlasEntityTransformer {
    private final List<Condition> conditions;
    private final List<Action> actions;

    public AtlasEntityTransformer(AttributeTransform attributeTransform, TransformerContext context) {
        this(attributeTransform.getConditions(), attributeTransform.getAction(), context);
    }

    public AtlasEntityTransformer(Map<String, String> conditions, Map<String, String> actions, TransformerContext context) {
        this.conditions = this.createConditions(conditions, context);
        this.actions = this.createActions(actions, context);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void transform(BaseEntityHandler.AtlasTransformableEntity entity) {
        if (entity != null) {
            boolean matches = true;
            for (Condition condition : this.conditions) {
                matches = matches && condition.matches(entity);
            }
            if (matches) {
                for (Action action : this.actions) {
                    action.apply(entity);
                }
            }
        }
    }

    private List<Condition> createConditions(Map<String, String> conditions, TransformerContext context) {
        ArrayList<Condition> ret = new ArrayList<Condition>();
        if (MapUtils.isNotEmpty(conditions)) {
            for (Map.Entry<String, String> entry : conditions.entrySet()) {
                Condition condition = Condition.createCondition(entry.getKey(), entry.getValue(), context);
                ret.add(condition);
            }
        }
        return ret;
    }

    private List<Action> createActions(Map<String, String> actions, TransformerContext context) {
        ArrayList<Action> ret = new ArrayList<Action>();
        if (MapUtils.isNotEmpty(actions)) {
            for (Map.Entry<String, String> entry : actions.entrySet()) {
                Action action = Action.createAction(entry.getKey(), entry.getValue(), context);
                ret.add(action);
            }
        }
        return ret;
    }
}

