/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.audit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.type.AtlasType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityAuditEventV2
implements Serializable {
    private String entityId;
    private long timestamp;
    private String user;
    private EntityAuditActionV2 action;
    private String details;
    private String eventKey;
    private AtlasEntity entity;
    private EntityAuditType type;

    public EntityAuditEventV2() {
    }

    public EntityAuditEventV2(String entityId, long timestamp, String user, EntityAuditActionV2 action, String details, AtlasEntity entity) {
        this(entityId, timestamp, user, action, details, entity, EntityAuditType.ENTITY_AUDIT_V2);
    }

    public EntityAuditEventV2(String entityId, long timestamp, String user, EntityAuditActionV2 action, String details, AtlasEntity entity, EntityAuditType auditType) {
        this.setEntityId(entityId);
        this.setTimestamp(timestamp);
        this.setUser(user);
        this.setAction(action);
        this.setDetails(details);
        this.setEntity(entity);
        this.setType(auditType);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public EntityAuditActionV2 getAction() {
        return this.action;
    }

    public void setAction(EntityAuditActionV2 action) {
        this.action = action;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public AtlasEntity getEntity() {
        return this.entity;
    }

    public void setEntity(AtlasEntity entity) {
        this.entity = entity;
    }

    public EntityAuditType getType() {
        return this.type;
    }

    public void setType(EntityAuditType type) {
        this.type = type;
    }

    @JsonIgnore
    public String getEntityDefinitionString() {
        if (this.entity != null) {
            return AtlasType.toJson(this.entity);
        }
        return null;
    }

    @JsonIgnore
    public void setEntityDefinition(String entityDefinition) {
        this.entity = AtlasType.fromJson(entityDefinition, AtlasEntity.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityAuditEventV2 that = (EntityAuditEventV2)o;
        return this.timestamp == that.timestamp && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.user, that.user) && this.action == that.action && Objects.equals(this.details, that.details) && Objects.equals(this.eventKey, that.eventKey) && Objects.equals(this.entity, that.entity) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityId, this.timestamp, this.user, this.action, this.details, this.eventKey, this.entity, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityAuditEventV2{");
        sb.append("entityId='").append(this.entityId).append('\'');
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", user='").append(this.user).append('\'');
        sb.append(", action=").append((Object)this.action);
        sb.append(", details='").append(this.details).append('\'');
        sb.append(", eventKey='").append(this.eventKey).append('\'');
        sb.append(", entity=").append(this.entity);
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }

    public static enum EntityAuditActionV2 {
        ENTITY_CREATE,
        ENTITY_UPDATE,
        ENTITY_DELETE,
        ENTITY_IMPORT_CREATE,
        ENTITY_IMPORT_UPDATE,
        ENTITY_IMPORT_DELETE,
        CLASSIFICATION_ADD,
        CLASSIFICATION_DELETE,
        CLASSIFICATION_UPDATE,
        PROPAGATED_CLASSIFICATION_ADD,
        PROPAGATED_CLASSIFICATION_DELETE,
        PROPAGATED_CLASSIFICATION_UPDATE,
        TERM_ADD,
        TERM_DELETE;


        public static EntityAuditActionV2 fromString(String strValue) {
            switch (strValue) {
                case "ENTITY_CREATE": {
                    return ENTITY_CREATE;
                }
                case "ENTITY_UPDATE": {
                    return ENTITY_UPDATE;
                }
                case "ENTITY_DELETE": {
                    return ENTITY_DELETE;
                }
                case "ENTITY_IMPORT_CREATE": {
                    return ENTITY_IMPORT_CREATE;
                }
                case "ENTITY_IMPORT_UPDATE": {
                    return ENTITY_IMPORT_UPDATE;
                }
                case "ENTITY_IMPORT_DELETE": {
                    return ENTITY_IMPORT_DELETE;
                }
                case "CLASSIFICATION_ADD": 
                case "TAG_ADD": {
                    return CLASSIFICATION_ADD;
                }
                case "CLASSIFICATION_DELETE": 
                case "TAG_DELETE": {
                    return CLASSIFICATION_DELETE;
                }
                case "CLASSIFICATION_UPDATE": 
                case "TAG_UPDATE": {
                    return CLASSIFICATION_UPDATE;
                }
                case "PROPAGATED_CLASSIFICATION_ADD": {
                    return PROPAGATED_CLASSIFICATION_ADD;
                }
                case "PROPAGATED_CLASSIFICATION_DELETE": {
                    return PROPAGATED_CLASSIFICATION_DELETE;
                }
                case "PROPAGATED_CLASSIFICATION_UPDATE": {
                    return PROPAGATED_CLASSIFICATION_UPDATE;
                }
                case "TERM_ADD": {
                    return TERM_ADD;
                }
                case "TERM_DELETE": {
                    return TERM_DELETE;
                }
            }
            throw new IllegalArgumentException("No enum constant " + EntityAuditActionV2.class.getCanonicalName() + "." + strValue);
        }
    }

    public static enum EntityAuditType {
        ENTITY_AUDIT_V1,
        ENTITY_AUDIT_V2;

    }
}

