/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasExportResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENTITY_COUNT = "entityCount";
    private AtlasExportRequest request;
    private String userName;
    private String clientIpAddress;
    private String hostName;
    private long timeStamp;
    private Map<String, Integer> metrics;
    private AtlasExportData data;
    private OperationStatus operationStatus;
    private String sourceClusterName;
    private long changeMarker;

    public AtlasExportResult() {
        this(null, null, null, null, System.currentTimeMillis(), 0L);
    }

    public AtlasExportResult(AtlasExportRequest request, String userName, String clientIpAddress, String hostName, long timeStamp, long changeMarker) {
        this.request = request;
        this.userName = userName;
        this.clientIpAddress = clientIpAddress;
        this.hostName = hostName;
        this.timeStamp = timeStamp;
        this.metrics = new HashMap<String, Integer>();
        this.operationStatus = OperationStatus.FAIL;
        this.data = new AtlasExportData();
        this.changeMarker = changeMarker;
    }

    public AtlasExportRequest getRequest() {
        return this.request;
    }

    public void setRequest(AtlasExportRequest request) {
        this.request = request;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Map<String, Integer> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Integer> metrics) {
        this.metrics = metrics;
    }

    public AtlasExportData getData() {
        return this.data;
    }

    public void setData(AtlasExportData data) {
        this.data = data;
    }

    public void setChangeMarker(long changeMarker) {
        this.changeMarker = changeMarker;
    }

    public long getChangeMarker() {
        return this.changeMarker;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(OperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void setMetric(String key, int value) {
        this.metrics.put(key, value);
    }

    public String getSourceClusterName() {
        return this.sourceClusterName;
    }

    public void setSourceClusterName(String sourceClusterName) {
        this.sourceClusterName = sourceClusterName;
    }

    public void incrementMeticsCounter(String key) {
        this.incrementMeticsCounter(key, 1);
    }

    public void incrementMeticsCounter(String key, int incrementBy) {
        int currentValue = this.metrics.containsKey(key) ? this.metrics.get(key) : 0;
        this.metrics.put(key, currentValue + incrementBy);
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasExportResult{");
        sb.append("request={").append(this.request).append("}");
        sb.append(", userName='").append(this.userName).append("'");
        sb.append(", clientIpAddress='").append(this.clientIpAddress).append("'");
        sb.append(", hostName='").append(this.hostName).append("'");
        sb.append(", changeMarker='").append(this.changeMarker).append("'");
        sb.append(", sourceCluster='").append(this.sourceClusterName).append("'");
        sb.append(", timeStamp='").append(this.timeStamp).append("'");
        sb.append(", metrics={");
        AtlasBaseTypeDef.dumpObjects(this.metrics, sb);
        sb.append("}");
        sb.append(", operationStatus='").append((Object)this.operationStatus).append("'");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.metrics != null) {
            this.metrics.clear();
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasExportData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AtlasTypesDef typesDef = new AtlasTypesDef();
        private List<String> entityCreationOrder = new ArrayList<String>();

        public AtlasTypesDef getTypesDef() {
            return this.typesDef;
        }

        public void setTypesDef(AtlasTypesDef typesDef) {
            this.typesDef = typesDef;
        }

        public List<String> getEntityCreationOrder() {
            return this.entityCreationOrder;
        }

        public void setEntityCreationOrder(List<String> entityCreationOrder) {
            this.entityCreationOrder = entityCreationOrder;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasExportData {");
            sb.append(", typesDef={").append(this.typesDef).append("}");
            sb.append(", entities={");
            sb.append("}");
            sb.append(", entityCreationOrder={");
            AtlasBaseTypeDef.dumpObjects(this.entityCreationOrder, sb);
            sb.append("}");
            sb.append("}");
            return sb;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public void clear() {
            if (this.typesDef != null) {
                this.typesDef.clear();
            }
            if (this.entityCreationOrder != null) {
                this.entityCreationOrder.clear();
            }
        }
    }

    public static enum OperationStatus {
        SUCCESS,
        PARTIAL_SUCCESS,
        INPROGRESS,
        FAIL;

    }
}

