/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.metrics;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasMetrics {
    private Map<String, Map<String, Object>> data;

    public AtlasMetrics() {
        this.setData(null);
    }

    public AtlasMetrics(Map<String, Map<String, Object>> data) {
        this.setData(data);
    }

    public AtlasMetrics(AtlasMetrics other) {
        if (other != null) {
            this.setData(other.getData());
        }
    }

    public Map<String, Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(Map<String, Map<String, Object>> data) {
        this.data = data;
    }

    @JsonIgnore
    public void addMetric(String groupKey, String key, Object value) {
        Map<String, Map<String, Object>> data = this.data;
        if (data == null) {
            data = new HashMap<String, Map<String, Object>>();
        }
        Map metricMap = data.computeIfAbsent(groupKey, k -> new HashMap());
        metricMap.put(key, value);
        this.setData(data);
    }

    @JsonIgnore
    public Number getNumericMetric(String groupKey, String key) {
        Object metric = this.getMetric(groupKey, key);
        return metric instanceof Number ? (Number)((Number)metric) : (Number)null;
    }

    @JsonIgnore
    public Object getMetric(String groupKey, String key) {
        Map<String, Object> metricMap;
        Map<String, Map<String, Object>> data = this.data;
        Object ret = null;
        if (data != null && (metricMap = data.get(groupKey)) != null && !metricMap.isEmpty()) {
            ret = metricMap.get(key);
        }
        return ret;
    }
}

