/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypeDefHeader;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.ClassTypeDefinition;
import org.apache.atlas.v1.model.typedef.Multiplicity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AtlasTypeUtil {
    private static final Set<String> ATLAS_BUILTIN_TYPENAMES = new HashSet<String>();
    private static final String NAME_REGEX = "[a-zA-Z][a-zA-Z0-9_ ]*";
    private static final String TRAIT_NAME_REGEX = "[a-zA-Z][a-zA-Z0-9_ .]*";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_ ]*");
    private static final Pattern TRAIT_NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_ .]*");
    private static final String InvalidTypeNameErrorMessage = "Name must consist of a letter followed by a sequence of [ letter, number, '_' ] characters.";
    private static final String InvalidTraitTypeNameErrorMessage = "Name must consist of a letter followed by a sequence of [ letter,  number, '_', '.' ] characters.";

    public static Set<String> getReferencedTypeNames(String typeName) {
        HashSet<String> ret = new HashSet<String>();
        AtlasTypeUtil.getReferencedTypeNames(typeName, ret);
        return ret;
    }

    public static boolean isBuiltInType(String typeName) {
        return ATLAS_BUILTIN_TYPENAMES.contains(typeName);
    }

    public static boolean isArrayType(String typeName) {
        return StringUtils.startsWith((String)typeName, (String)"array<") && StringUtils.endsWith((String)typeName, (String)">");
    }

    public static boolean isMapType(String typeName) {
        return StringUtils.startsWith((String)typeName, (String)"map<") && StringUtils.endsWith((String)typeName, (String)">");
    }

    public static boolean isValidTypeName(String typeName) {
        Matcher m = NAME_PATTERN.matcher(typeName);
        return m.matches();
    }

    public static String getInvalidTypeNameErrorMessage() {
        return InvalidTypeNameErrorMessage;
    }

    public static boolean isValidTraitTypeName(String typeName) {
        Matcher m = TRAIT_NAME_PATTERN.matcher(typeName);
        return m.matches();
    }

    public static String getInvalidTraitTypeNameErrorMessage() {
        return InvalidTraitTypeNameErrorMessage;
    }

    public static String getStringValue(Map map, Object key) {
        Object ret = map != null ? (Object)map.get(key) : null;
        return ret != null ? ret.toString() : null;
    }

    private static void getReferencedTypeNames(String typeName, Set<String> referencedTypeNames) {
        if (StringUtils.isNotBlank((String)typeName) && !referencedTypeNames.contains(typeName)) {
            if (typeName.startsWith("array<") && typeName.endsWith(">")) {
                int startIdx = "array<".length();
                int endIdx = typeName.length() - ">".length();
                String elementTypeName = typeName.substring(startIdx, endIdx);
                AtlasTypeUtil.getReferencedTypeNames(elementTypeName, referencedTypeNames);
            } else if (typeName.startsWith("map<") && typeName.endsWith(">")) {
                int endIdx;
                int startIdx = "map<".length();
                String[] keyValueTypes = typeName.substring(startIdx, endIdx = typeName.length() - ">".length()).split(",", 2);
                String keyTypeName = keyValueTypes.length > 0 ? keyValueTypes[0] : null;
                String valueTypeName = keyValueTypes.length > 1 ? keyValueTypes[1] : null;
                AtlasTypeUtil.getReferencedTypeNames(keyTypeName, referencedTypeNames);
                AtlasTypeUtil.getReferencedTypeNames(valueTypeName, referencedTypeNames);
            } else {
                referencedTypeNames.add(typeName);
            }
        }
    }

    public static AtlasRelationshipType findRelationshipWithLegacyRelationshipEnd(String entityTypeName, String attributeName, AtlasTypeRegistry typeRegistry) {
        AtlasRelationshipType ret = null;
        for (AtlasRelationshipDef relationshipDef : typeRegistry.getAllRelationshipDefs()) {
            AtlasRelationshipEndDef end1Def = relationshipDef.getEndDef1();
            AtlasRelationshipEndDef end2Def = relationshipDef.getEndDef2();
            if ((!end1Def.getIsLegacyAttribute() || !StringUtils.equals((String)end1Def.getType(), (String)entityTypeName) || !StringUtils.equals((String)end1Def.getName(), (String)attributeName)) && (!end2Def.getIsLegacyAttribute() || !StringUtils.equals((String)end2Def.getType(), (String)entityTypeName) || !StringUtils.equals((String)end2Def.getName(), (String)attributeName))) continue;
            ret = typeRegistry.getRelationshipTypeByName(relationshipDef.getName());
            break;
        }
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, true, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createListRequiredAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, false, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, 1, Integer.MAX_VALUE, false, true, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalListAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, true, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, 1, Integer.MAX_VALUE, false, true, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredListAttrDefWithConstraint(String name, String dataType, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createListRequiredAttrDef(name, dataType);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDefWithConstraint(String name, String typeName, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createRequiredAttrDef(name, typeName);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDefWithConstraint(String name, String typeName, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createOptionalAttrDef(name, typeName);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createUniqueRequiredAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, true, true, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createUniqueRequiredAttrDef(String name, String typeName) {
        return new AtlasStructDef.AtlasAttributeDef(name, typeName, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, true, true, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, true, false, Collections.emptyList());
    }

    public static AtlasEnumDef createEnumTypeDef(String name, String description, AtlasEnumDef.AtlasEnumElementDef ... enumValues) {
        return new AtlasEnumDef(name, description, "1.0", Arrays.asList(enumValues));
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createTraitTypeDef(name, null, superTypes, attrDefs);
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, String description, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createTraitTypeDef(name, description, "1.0", superTypes, attrDefs);
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, String description, String version, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasClassificationDef(name, description, version, Arrays.asList(attrDefs), superTypes);
    }

    public static AtlasClassificationDef createAtlasClassificationDef(String name, String description, String version, Set<String> superTypes, Set<String> entityTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasClassificationDef(name, description, version, Arrays.asList(attrDefs), superTypes, entityTypes, null);
    }

    public static AtlasStructDef createStructTypeDef(String name, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createStructTypeDef(name, null, attrDefs);
    }

    public static AtlasStructDef createStructTypeDef(String name, String description, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasStructDef(name, description, "1.0", Arrays.asList(attrDefs));
    }

    public static AtlasEntityDef createClassTypeDef(String name, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createClassTypeDef(name, null, "1.0", superTypes, attrDefs);
    }

    public static AtlasEntityDef createClassTypeDef(String name, String description, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createClassTypeDef(name, description, "1.0", superTypes, attrDefs);
    }

    public static AtlasEntityDef createClassTypeDef(String name, String description, String version, Set<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasEntityDef(name, description, version, Arrays.asList(attrDefs), superTypes);
    }

    public static AtlasRelationshipDef createRelationshipTypeDef(String name, String description, String version, AtlasRelationshipDef.RelationshipCategory relationshipCategory, AtlasRelationshipDef.PropagateTags propagateTags, AtlasRelationshipEndDef endDef1, AtlasRelationshipEndDef endDef2, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasRelationshipDef(name, description, version, relationshipCategory, propagateTags, endDef1, endDef2, Arrays.asList(attrDefs));
    }

    public static AtlasTypesDef getTypesDef(List<AtlasEnumDef> enums, List<AtlasStructDef> structs, List<AtlasClassificationDef> traits, List<AtlasEntityDef> classes) {
        return new AtlasTypesDef(enums, structs, traits, classes);
    }

    public static List<AtlasTypeDefHeader> toTypeDefHeader(AtlasTypesDef typesDef) {
        LinkedList<AtlasTypeDefHeader> headerList = new LinkedList<AtlasTypeDefHeader>();
        if (CollectionUtils.isNotEmpty(typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                headerList.add(new AtlasTypeDefHeader(enumDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                headerList.add(new AtlasTypeDefHeader(structDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classificationDef : typesDef.getClassificationDefs()) {
                headerList.add(new AtlasTypeDefHeader(classificationDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                headerList.add(new AtlasTypeDefHeader(entityDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getRelationshipDefs())) {
            for (AtlasRelationshipDef relationshipDef : typesDef.getRelationshipDefs()) {
                headerList.add(new AtlasTypeDefHeader(relationshipDef));
            }
        }
        return headerList;
    }

    public static AtlasTypesDef getTypesDef(AtlasBaseTypeDef typeDef) {
        AtlasTypesDef ret = new AtlasTypesDef();
        if (typeDef != null) {
            if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                ret.getEntityDefs().add((AtlasEntityDef)typeDef);
            } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                ret.getClassificationDefs().add((AtlasClassificationDef)typeDef);
            } else if (typeDef.getClass().equals(AtlasStructDef.class)) {
                ret.getStructDefs().add((AtlasStructDef)typeDef);
            } else if (typeDef.getClass().equals(AtlasEnumDef.class)) {
                ret.getEnumDefs().add((AtlasEnumDef)typeDef);
            }
        }
        return ret;
    }

    public static Collection<AtlasObjectId> toObjectIds(Collection<AtlasEntity> entities) {
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (AtlasEntity entity : entities) {
                if (entity == null) continue;
                ret.add(AtlasTypeUtil.getAtlasObjectId(entity));
            }
        }
        return ret;
    }

    public static Map toStructAttributes(Map map) {
        if (map != null && map.containsKey("typeName") && map.containsKey("attributes") && map.get("attributes") instanceof Map) {
            return (Map)map.get("attributes");
        }
        return map;
    }

    public static Map toRelationshipAttributes(Map map) {
        Map ret = null;
        if (map != null && map.containsKey("typeName") && map.containsKey("relationshipAttributes") && map.get("relationshipAttributes") instanceof Map) {
            ret = (Map)map.get("relationshipAttributes");
        }
        return ret;
    }

    public static AtlasRelatedObjectId toAtlasRelatedObjectId(AtlasEntity entity) {
        return new AtlasRelatedObjectId(AtlasTypeUtil.getAtlasObjectId(entity));
    }

    public static AtlasRelatedObjectId toAtlasRelatedObjectId(AtlasEntity entity, AtlasTypeRegistry typeRegistry) {
        return new AtlasRelatedObjectId(AtlasTypeUtil.getAtlasObjectId(entity, typeRegistry));
    }

    public static AtlasObjectId getAtlasObjectId(AtlasEntity entity) {
        return new AtlasObjectId(entity.getGuid(), entity.getTypeName());
    }

    public static AtlasObjectId getAtlasObjectId(AtlasEntity entity, AtlasTypeRegistry typeRegistry) {
        String typeName = entity.getTypeName();
        AtlasEntityType entityType = typeRegistry.getEntityTypeByName(typeName);
        HashMap<String, Object> uniqAttributes = null;
        if (entityType != null && MapUtils.isNotEmpty(entityType.getUniqAttributes())) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getUniqAttributes().values()) {
                Object attrValue = entity.getAttribute(attribute.getName());
                if (attrValue == null) continue;
                if (uniqAttributes == null) {
                    uniqAttributes = new HashMap<String, Object>();
                }
                uniqAttributes.put(attribute.getName(), attrValue);
            }
        }
        return new AtlasObjectId(entity.getGuid(), typeName, uniqAttributes);
    }

    public static AtlasObjectId getAtlasObjectId(AtlasEntityHeader header) {
        return new AtlasObjectId(header.getGuid(), header.getTypeName());
    }

    public static List<AtlasObjectId> getAtlasObjectIds(List<AtlasEntity> entities) {
        ArrayList<AtlasObjectId> ret;
        if (CollectionUtils.isNotEmpty(entities)) {
            ret = new ArrayList(entities.size());
            for (AtlasEntity entity : entities) {
                ret.add(AtlasTypeUtil.getAtlasObjectId(entity));
            }
        } else {
            ret = new ArrayList<AtlasObjectId>();
        }
        return ret;
    }

    public static boolean isValidGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isValidGuid(objId.getGuid());
    }

    public static boolean isAssignedGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isAssignedGuid(objId.getGuid());
    }

    public static boolean isUnAssignedGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isUnAssignedGuid(objId.getGuid());
    }

    public static boolean isValidGuid(String guid) {
        return AtlasTypeUtil.isAssignedGuid(guid) || AtlasTypeUtil.isUnAssignedGuid(guid);
    }

    public static boolean isAssignedGuid(String guid) {
        if (guid != null) {
            return guid != null && guid.length() > 0 && guid.charAt(0) != '-';
        }
        return false;
    }

    public static boolean isUnAssignedGuid(String guid) {
        return guid != null && guid.length() > 0 && guid.charAt(0) == '-';
    }

    public static boolean isValid(AtlasObjectId objId) {
        if (AtlasTypeUtil.isAssignedGuid(objId) || AtlasTypeUtil.isUnAssignedGuid(objId)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)objId.getTypeName()) && MapUtils.isNotEmpty(objId.getUniqueAttributes());
    }

    public static String toDebugString(AtlasTypesDef typesDef) {
        StringBuilder sb = new StringBuilder();
        sb.append("typesDef={");
        if (typesDef != null) {
            sb.append("enumDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getEnumDefs(), sb);
            sb.append("],");
            sb.append("structDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getStructDefs(), sb);
            sb.append("],");
            sb.append("classificationDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getClassificationDefs(), sb);
            sb.append("],");
            sb.append("entityDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getEntityDefs(), sb);
            sb.append("]");
            sb.append("relationshipDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getRelationshipDefs(), sb);
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    public static ClassTypeDefinition toClassTypeDefinition(AtlasEntityType entityType) {
        ClassTypeDefinition ret = null;
        if (entityType != null) {
            AtlasEntityDef entityDef = entityType.getEntityDef();
            ret = new ClassTypeDefinition();
            ret.setTypeName(entityDef.getName());
            ret.setTypeDescription(entityDef.getDescription());
            ret.setTypeVersion(entityDef.getTypeVersion());
            ret.setSuperTypes(entityDef.getSuperTypes());
            if (MapUtils.isNotEmpty(entityType.getAllAttributes())) {
                List<AttributeDefinition> attributeDefinitions = entityType.getAllAttributes().entrySet().stream().map(e -> AtlasTypeUtil.toV1AttributeDefinition((AtlasStructType.AtlasAttribute)e.getValue())).collect(Collectors.toList());
                ret.setAttributeDefinitions(attributeDefinitions);
            }
        }
        return ret;
    }

    public static AttributeDefinition toV1AttributeDefinition(AtlasStructType.AtlasAttribute attribute) {
        AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
        AttributeDefinition ret = new AttributeDefinition();
        ret.setName(attributeDef.getName());
        ret.setDataTypeName(attributeDef.getTypeName());
        ret.setIsUnique(attributeDef.getIsUnique());
        ret.setIsIndexable(attributeDef.getIsIndexable());
        ret.setIsComposite(attribute.isOwnedRef());
        ret.setReverseAttributeName(attribute.getInverseRefAttributeName());
        ret.setDefaultValue(attributeDef.getDefaultValue());
        ret.setDescription(attributeDef.getDescription());
        ret.setOptions(attributeDef.getOptions());
        ret.setMultiplicity(AtlasTypeUtil.getMultiplicity(attributeDef));
        return ret;
    }

    public static Multiplicity getMultiplicity(AtlasStructDef.AtlasAttributeDef attributeDef) {
        int upper;
        int lower;
        if (attributeDef.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE) {
            lower = attributeDef.getIsOptional() ? 0 : 1;
            upper = 1;
        } else {
            lower = attributeDef.getIsOptional() ? 0 : (attributeDef.getValuesMinCount() < 1 ? 1 : attributeDef.getValuesMinCount());
            upper = attributeDef.getValuesMaxCount() < 2 ? Integer.MAX_VALUE : attributeDef.getValuesMaxCount();
        }
        return new Multiplicity(lower, upper, AtlasStructDef.AtlasAttributeDef.Cardinality.SET.equals((Object)attributeDef.getCardinality()));
    }

    public static Map<String, Object> toMap(final AtlasEntity entity) {
        LinkedHashMap<String, Object> ret = null;
        if (entity != null) {
            ret = new LinkedHashMap<String, Object>();
            ret.put("$typeName$", entity.getTypeName());
            ret.put("$id$", new LinkedHashMap<String, Object>(){
                {
                    this.put("id", entity.getGuid());
                    this.put("$typeName$", entity.getTypeName());
                    this.put("version", entity.getVersion().intValue());
                    this.put("state", entity.getStatus().name());
                }
            });
            ret.put("$systemAttributes$", new LinkedHashMap<String, String>(){
                {
                    this.put("createdBy", entity.getCreatedBy());
                    this.put("modifiedBy", entity.getUpdatedBy());
                    this.put("createdTime", entity.getCreateTime().toString());
                    this.put("modifiedTime", entity.getUpdateTime().toString());
                }
            });
            if (CollectionUtils.isNotEmpty(entity.getClassifications())) {
                Map<String, HashMap> traitDetails = entity.getClassifications().stream().collect(Collectors.toMap(AtlasStruct::getTypeName, AtlasTypeUtil::getNestedTraitDetails));
                ret.put("$traits$", traitDetails);
            }
            if (MapUtils.isNotEmpty(entity.getAttributes())) {
                for (final Map.Entry<String, Object> entry : entity.getAttributes().entrySet()) {
                    if (entry.getValue() instanceof AtlasObjectId) {
                        ret.put(entry.getKey(), new LinkedHashMap<String, Object>(){
                            {
                                this.put("id", ((AtlasObjectId)entry.getValue()).getGuid());
                                this.put("$typeName$", ((AtlasObjectId)entry.getValue()).getTypeName());
                            }
                        });
                        continue;
                    }
                    ret.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return ret;
    }

    private static HashMap getNestedTraitDetails(final AtlasClassification atlasClassification) {
        return new HashMap<String, Object>(){
            {
                this.put("$typeName$", atlasClassification.getTypeName());
                if (MapUtils.isNotEmpty(atlasClassification.getAttributes())) {
                    this.putAll(atlasClassification.getAttributes());
                }
            }
        };
    }

    private static void dumpTypeNames(List<? extends AtlasBaseTypeDef> typeDefs, StringBuilder sb) {
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (int i = 0; i < typeDefs.size(); ++i) {
                AtlasBaseTypeDef typeDef = typeDefs.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(typeDef.getName());
            }
        }
    }

    static {
        Collections.addAll(ATLAS_BUILTIN_TYPENAMES, AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES);
    }
}

