/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.idea;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.wsdl.WSDLException;
import org.apache.axis2.tools.bean.CodegenBean;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.idea.WSDLFileFilter;

public class FirstPanel
extends WizardPanel {
    private JLabel lblWSDL;
    private JTextField txtWSDL;
    private JButton btnBrowse;
    private JButton btnHint;
    private JLabel lblHint;
    private boolean flag = false;
    private final String hint = "You can select only *.wsdl/*.xml file location.";
    final JFileChooser FileChooser = new JFileChooser();
    private CodegenBean codegenBean;

    public FirstPanel(WizardComponents wizardComponents, CodegenBean codegenBean) {
        super(wizardComponents, "Axis2 Idea Plugin WSDL2Java Wizards");
        this.codegenBean = codegenBean;
        this.setPanelTopTitle("WSDL selection page");
        this.setPanelBottomTitle("please Select the WSDl file location");
        this.init();
    }

    private void init() {
        this.lblHint = new JLabel("");
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setLayout(new GridBagLayout());
        this.lblWSDL = new JLabel("WSDL File Location");
        this.txtWSDL = new JTextField();
        this.btnBrowse = new JButton("Browse");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblWSDL, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.txtWSDL, new GridBagConstraints(1, 0, -1, 1, 2.0, 0.0, 10, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FirstPanel.this.FileChooser.setFileFilter(new WSDLFileFilter());
                int returnVal = FirstPanel.this.FileChooser.showOpenDialog(FirstPanel.this.btnBrowse);
                if (returnVal == 0) {
                    File file = FirstPanel.this.FileChooser.getSelectedFile();
                    FirstPanel.this.txtWSDL.setText(file.getAbsolutePath());
                    FirstPanel.this.codegenBean.setWSDLFileName(file.getAbsolutePath());
                    FirstPanel.this.update();
                }
            }
        });
        this.add((Component)this.btnHint, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FirstPanel.this.flag) {
                    FirstPanel.this.btnHint.setText("Hint >>");
                    FirstPanel.this.lblHint.setText("");
                    FirstPanel.this.flag = false;
                } else {
                    FirstPanel.this.btnHint.setText("Hint <<");
                    FirstPanel.this.lblHint.setText("You can select only *.wsdl/*.xml file location.");
                    FirstPanel.this.flag = true;
                }
            }
        });
        this.add((Component)this.lblHint, new GridBagConstraints(0, 2, 0, 1, 0.1, 1.0, 18, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.setPageComplete(false);
    }

    public void next() {
        if (this.txtWSDL.getText() != null && this.isPageComplete()) {
            this.codegenBean.setWSDLFileName(this.txtWSDL.getText());
            this.switchPanel(3);
        } else {
            this.switchPanel(1);
        }
    }

    public void back() {
        this.switchPanel(0);
    }

    public void update() {
        if (!this.txtWSDL.getText().trim().equals("")) {
            try {
                this.codegenBean.readWSDL();
                this.setNextButtonEnabled(true);
                this.setFinishButtonEnabled(false);
                this.setPageComplete(true);
            }
            catch (WSDLException e) {
                this.setNextButtonEnabled(false);
                this.setFinishButtonEnabled(false);
                this.setPageComplete(false);
                JOptionPane.showMessageDialog(this, "An error occured while parsing the specified WSDL. Please make sure that the selected file is a valid WSDL.", "Error!", 0);
            }
        } else {
            this.setNextButtonEnabled(false);
            this.setFinishButtonEnabled(false);
            this.setPageComplete(false);
        }
        this.setBackButtonEnabled(true);
    }

    public int getPageType() {
        return 1;
    }

    public String getWSDLFileName() {
        return this.txtWSDL.getText().trim();
    }
}

