/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.idea;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.bean.CodegenBean;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;

public class WSDL2JavaOutputPanel
extends WizardPanel {
    private JTextField txtoutput;
    private JTextField txtaxisHome;
    private JTextField txtjarFileName;
    private JButton btnBrowseOutput;
    private JButton btnBrowseAxisHome;
    private JButton btnCheckLib;
    private JRadioButton radCurrentProject;
    private JRadioButton radCustomLocation;
    private JCheckBox chbAddAxisCodegenJar;
    private JCheckBox chbAddAxisLib;
    private JCheckBox chbCreateJar;
    private JLabel lblMessage;
    private JTextArea txtaTilte;
    private JComboBox cmbCurrentProject;
    private JComboBox cmbModuleSrc;
    private JLabel lblAsixHome;
    private JLabel lblJarFileName;
    private JLabel lbloutput;
    private JLabel lblModule;
    private JLabel lblDirectory;
    final JFileChooser DirChooser = new JFileChooser();
    private final String title = "Select one of below to save the codegen output either on idea workspace project or on file system and then browse to enter the output path";
    private final String hint = "If you have Axis2 binary distribution or Axis source, then you can add those libs also to the resulted codegen project by checking the \"Add Axis2 Libraries to the codegen resulted project\" check box and specifying the Axis2 home. Another option you have is to compile the codegen  result project and add it as a jar file in the lib directory of the resulted project, for that you can check the \"Create a jar file of codegen result project and add to resulted project lib folder\" checkbox and then give the jar file name that you prefer. \n If you are adding the codegen result to a eclipse project on current eclipse workspace, please make sure to refresh that particular eclipse project.\n Also if you select the options to add libs to the project, make sure to add those libs to the project library path.";
    private CodegenBean codegenBean;
    private boolean flag = true;
    private Project project;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean jarFileCopyOption = false;
    private String axis2LibsLocation = null;

    public WSDL2JavaOutputPanel(WizardComponents wizardComponents, CodegenBean codegenBean, Project project) {
        super(wizardComponents, "Axis2 Idea Plugin WSDL2Java Wizards");
        this.codegenBean = codegenBean;
        this.project = project;
        this.setPanelTopTitle("Output");
        this.setPanelBottomTitle("set the out location for the generated code");
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.lblMessage = new JLabel();
        this.lblMessage.setOpaque(true);
        this.lblMessage.setBackground(Color.white);
        this.btnBrowseAxisHome = new JButton("Browse..");
        this.btnBrowseOutput = new JButton("Browse..");
        this.btnCheckLib = new JButton("Check Libs..");
        this.cmbCurrentProject = new JComboBox();
        this.cmbCurrentProject.setEnabled(false);
        this.cmbModuleSrc = new JComboBox();
        this.cmbModuleSrc.setEnabled(false);
        this.txtoutput = new JTextField();
        this.txtaxisHome = new JTextField("Unpacked Axis2 binary home Or Axis2 source location");
        this.txtjarFileName = new JTextField();
        this.txtaTilte = new JTextArea("Select one of below to save the codegen output either on idea workspace project or on file system and then browse to enter the output path");
        this.txtaTilte.setBorder(null);
        this.txtaTilte.setFocusable(false);
        this.txtaTilte.setLineWrap(true);
        this.txtaTilte.setWrapStyleWord(true);
        this.txtaTilte.setOpaque(false);
        this.lblAsixHome = new JLabel("Axis2 Home");
        this.lblAsixHome.setEnabled(false);
        this.lblJarFileName = new JLabel("Jar File Name");
        this.lblJarFileName.setEnabled(false);
        this.lblDirectory = new JLabel("Select the Directory");
        this.lblModule = new JLabel("Select the Module");
        this.lbloutput = new JLabel("Out put path");
        this.chbAddAxisCodegenJar = new JCheckBox("Add the Axis2 Codegen jars to the codegen resulted project");
        this.chbAddAxisLib = new JCheckBox(" Add Axis2 libraries to the codegen result project ");
        this.chbCreateJar = new JCheckBox(" Create a jar file of codegen result project and add to resulted project lib folder(Default :CodegenResults.jar)");
        this.radCurrentProject = new JRadioButton("Browse and select a project on current idea workspace", false);
        this.radCustomLocation = new JRadioButton("Browse and select location on local file system", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radCurrentProject);
        buttonGroup.add(this.radCustomLocation);
        this.codegenBean.setProject(this.project);
        this.setNextButtonEnabled(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.txtaTilte, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.radCurrentProject, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.radCurrentProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.cmbCurrentProject.setEnabled(true);
                WSDL2JavaOutputPanel.this.cmbModuleSrc.setEnabled(true);
                WSDL2JavaOutputPanel.this.txtoutput.setEnabled(false);
                WSDL2JavaOutputPanel.this.btnBrowseOutput.setEnabled(false);
                WSDL2JavaOutputPanel.this.loadCmbCurrentProject();
                WSDL2JavaOutputPanel.this.loadcmbModuleSrcProject();
                WSDL2JavaOutputPanel.this.setFinishButtonEnabled(true);
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lblModule, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.cmbCurrentProject, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.cmbCurrentProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.loadcmbModuleSrcProject();
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lblDirectory, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.cmbModuleSrc, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.cmbModuleSrc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.radCustomLocation, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.radCustomLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.cmbCurrentProject.setEnabled(false);
                WSDL2JavaOutputPanel.this.cmbModuleSrc.setEnabled(false);
                WSDL2JavaOutputPanel.this.txtoutput.setEnabled(true);
                WSDL2JavaOutputPanel.this.btnBrowseOutput.setEnabled(true);
                WSDL2JavaOutputPanel.this.setEnabledForCustomProject();
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lbloutput, new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtoutput, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowseOutput, new GridBagConstraints(2, 5, 1, 1, 0.1, 0.0, 13, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.btnBrowseOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.DirChooser.setFileSelectionMode(1);
                int returnVal = WSDL2JavaOutputPanel.this.DirChooser.showOpenDialog(WSDL2JavaOutputPanel.this.btnBrowseOutput);
                if (returnVal == 0) {
                    WSDL2JavaOutputPanel.this.DirChooser.setFileSelectionMode(0);
                    File newfile = WSDL2JavaOutputPanel.this.DirChooser.getSelectedFile();
                    WSDL2JavaOutputPanel.this.txtoutput.setText(newfile.getAbsolutePath());
                }
                WSDL2JavaOutputPanel.this.setFinishButtonEnabled(true);
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.chbAddAxisCodegenJar, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.chbAddAxisCodegenJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 7, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 1, 0, 1), 0, 0));
        this.add((Component)this.chbAddAxisLib, new GridBagConstraints(0, 8, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.chbAddAxisLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.setEnabledForAddAxisLib();
                WSDL2JavaOutputPanel.this.handleLoadLibsBrowse();
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lblAsixHome, new GridBagConstraints(0, 9, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.txtaxisHome, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowseAxisHome, new GridBagConstraints(2, 9, 1, 1, 0.1, 0.0, 13, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.btnBrowseAxisHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.DirChooser.setFileSelectionMode(1);
                int returnVal = WSDL2JavaOutputPanel.this.DirChooser.showOpenDialog(WSDL2JavaOutputPanel.this.btnBrowseAxisHome);
                if (returnVal == 0) {
                    WSDL2JavaOutputPanel.this.DirChooser.setFileSelectionMode(0);
                    File newfile = WSDL2JavaOutputPanel.this.DirChooser.getSelectedFile();
                    WSDL2JavaOutputPanel.this.txtaxisHome.setText(newfile.getAbsolutePath());
                }
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.btnCheckLib, new GridBagConstraints(0, 10, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnCheckLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.handleLoadLibsBrowse();
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lblMessage, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 11, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 1, 0, 1), 0, 0));
        this.add((Component)this.chbCreateJar, new GridBagConstraints(0, 12, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.chbCreateJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.lblJarFileName, new GridBagConstraints(0, 13, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.txtjarFileName, new GridBagConstraints(1, 13, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 14, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 1, 0, 1), 0, 0));
        this.add((Component)this.btnHint, new GridBagConstraints(0, 15, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WSDL2JavaOutputPanel.this.flag) {
                    WSDL2JavaOutputPanel.this.btnHint.setText("Hint >>");
                    WSDL2JavaOutputPanel.this.txaHint.setText("");
                    WSDL2JavaOutputPanel.this.flag = false;
                } else {
                    WSDL2JavaOutputPanel.this.btnHint.setText("Hint <<");
                    WSDL2JavaOutputPanel.this.txaHint.setText("If you have Axis2 binary distribution or Axis source, then you can add those libs also to the resulted codegen project by checking the \"Add Axis2 Libraries to the codegen resulted project\" check box and specifying the Axis2 home. Another option you have is to compile the codegen  result project and add it as a jar file in the lib directory of the resulted project, for that you can check the \"Create a jar file of codegen result project and add to resulted project lib folder\" checkbox and then give the jar file name that you prefer. \n If you are adding the codegen result to a eclipse project on current eclipse workspace, please make sure to refresh that particular eclipse project.\n Also if you select the options to add libs to the project, make sure to add those libs to the project library path.");
                    WSDL2JavaOutputPanel.this.flag = true;
                }
                WSDL2JavaOutputPanel.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 16, 0, 1, 0.1, 1.0, 18, 1, new Insets(10, 20, 0, 0), 0, 0));
        this.update();
    }

    public void back() {
        this.switchPanel(3);
    }

    public void next() {
    }

    public void update() {
        this.setNextButtonEnabled(false);
        this.checkPageComlete();
        this.setEnabledForAddAxisLib();
    }

    public void loadCmbCurrentProject() {
        Module[] modules = this.codegenBean.getModules();
        if (modules != null) {
            for (int count = 0; count < modules.length; ++count) {
                this.cmbCurrentProject.addItem(modules[count].getName());
            }
        }
    }

    public void loadcmbModuleSrcProject() {
        String module = null;
        module = (String)this.cmbCurrentProject.getSelectedItem();
        this.cmbModuleSrc.removeAllItems();
        int count = 0;
        if (module != null) {
            String[] src = this.codegenBean.getModuleSrc(module);
            for (count = 0; count < src.length; ++count) {
                this.cmbModuleSrc.addItem(src[count]);
            }
            count = src.length;
        }
        if (this.flag) {
            if (count == 0) {
                this.flag = false;
                this.setEnabledForCustomProject();
            } else {
                this.setEnabledForCurrentProject();
            }
        }
    }

    private void setEnabledForCurrentProject() {
        this.radCurrentProject.setSelected(true);
        this.radCurrentProject.setEnabled(true);
        this.cmbCurrentProject.setEnabled(true);
        this.cmbModuleSrc.setEnabled(true);
        this.lblDirectory.setEnabled(true);
        this.lblModule.setEnabled(true);
        this.radCurrentProject.setSelected(true);
        this.txtoutput.setEnabled(false);
        this.lbloutput.setEnabled(false);
        this.btnBrowseOutput.setEnabled(false);
    }

    private void setEnabledForCustomProject() {
        if (!this.flag) {
            this.radCurrentProject.setEnabled(false);
        } else {
            this.radCurrentProject.setEnabled(true);
            this.radCurrentProject.setSelected(true);
        }
        this.cmbCurrentProject.setEnabled(false);
        this.cmbModuleSrc.setEnabled(false);
        this.lblDirectory.setEnabled(false);
        this.lblModule.setEnabled(false);
        this.radCustomLocation.setSelected(true);
        this.txtoutput.setEnabled(true);
        this.lbloutput.setEnabled(true);
        this.btnBrowseOutput.setEnabled(true);
    }

    private void setEnabledForAddAxisLib() {
        if (this.chbAddAxisLib.isSelected()) {
            this.lblAsixHome.setEnabled(true);
            this.lblMessage.setEnabled(true);
            this.lblJarFileName.setEnabled(true);
            this.txtaxisHome.setEnabled(true);
            this.txtjarFileName.setEnabled(true);
            this.chbCreateJar.setEnabled(true);
            this.btnBrowseAxisHome.setEnabled(true);
            this.btnCheckLib.setEnabled(true);
        } else {
            this.lblAsixHome.setEnabled(false);
            this.lblMessage.setEnabled(false);
            this.lblJarFileName.setEnabled(false);
            this.txtaxisHome.setEnabled(false);
            this.txtjarFileName.setEnabled(false);
            this.chbCreateJar.setEnabled(false);
            this.btnBrowseAxisHome.setEnabled(false);
            this.btnCheckLib.setEnabled(false);
            this.txtaxisHome.setText("Unpacked Axis2 binary home Or Axis2 source location");
            this.lblMessage.setBackground(Color.WHITE);
        }
    }

    private void handleLoadLibsBrowse() {
        if (this.txtaxisHome.getText().equals("")) {
            this.lblMessage.setText("Axis libs are not available !! ");
            this.jarFileCopyOption = false;
        } else {
            String axis_home = this.txtaxisHome.getText().trim();
            String axis_target_lib = axis_home + File.separator + "target" + File.separator + "lib";
            String axis_std_lib_directory = axis_home + File.separator + "lib";
            File axis_target_libs_directory = new File(axis_target_lib);
            File axis_libs_directory = new File(axis_std_lib_directory);
            if (axis_libs_directory.isDirectory() || axis_target_libs_directory.isDirectory()) {
                this.lblMessage.setText("Axis libs loaded successfully!!");
                if (axis_libs_directory.isDirectory()) {
                    this.axis2LibsLocation = axis_std_lib_directory;
                } else if (axis_target_libs_directory.isDirectory()) {
                    this.axis2LibsLocation = axis_target_lib;
                }
                this.jarFileCopyOption = true;
                this.lblMessage.setBackground(Color.WHITE);
            } else {
                this.lblMessage.setText("Axis libs are not available !! ");
                this.lblMessage.setBackground(Color.RED);
                this.jarFileCopyOption = false;
            }
        }
    }

    public String getOutputLocation() {
        if (this.radCurrentProject.isSelected()) {
            return this.cmbModuleSrc.getSelectedItem().toString();
        }
        return this.txtoutput.getText();
    }

    public String getAxisHomeLocation() {
        return this.txtaxisHome.getText();
    }

    public String getJarFilename() {
        return this.txtjarFileName.getText();
    }

    public boolean getAxis2PluginLibCopyCheckBoxSelection() {
        return this.chbAddAxisCodegenJar.isSelected();
    }

    public boolean getAxisLibCopyCheckBoxSelection() {
        return this.chbAddAxisLib.isSelected();
    }

    public boolean getCreateJarCheckBoxSelection() {
        return this.chbCreateJar.isSelected();
    }

    public String getAxisJarsLocation() {
        return this.axis2LibsLocation;
    }

    public boolean oktoLoadLibs() {
        return this.jarFileCopyOption;
    }

    public void setJarFileName(String jarFileName) {
        this.txtjarFileName.setText(jarFileName);
    }

    private void checkPageComlete() {
        if (this.getAxisLibCopyCheckBoxSelection()) {
            if (this.radCurrentProject.isSelected()) {
                if (this.jarFileCopyOption) {
                    this.setPageComplete(true);
                    this.setFinishButtonEnabled(true);
                    this.codegenBean.setOutput(this.getOutputLocation());
                } else {
                    this.setPageComplete(false);
                    this.setFinishButtonEnabled(false);
                }
            } else if (!this.getOutputLocation().equals("")) {
                if (this.jarFileCopyOption) {
                    this.setPageComplete(true);
                    this.setFinishButtonEnabled(true);
                    this.codegenBean.setOutput(this.getOutputLocation());
                } else {
                    this.setPageComplete(false);
                    this.setFinishButtonEnabled(false);
                }
            } else {
                this.setPageComplete(false);
                this.setFinishButtonEnabled(false);
            }
        } else if (this.radCurrentProject.isSelected()) {
            this.setPageComplete(true);
            this.setFinishButtonEnabled(true);
            this.codegenBean.setOutput(this.getOutputLocation());
        } else if (!this.getOutputLocation().equals("")) {
            this.setPageComplete(true);
            this.setFinishButtonEnabled(true);
            this.codegenBean.setOutput(this.getOutputLocation());
        } else {
            this.setPageComplete(false);
            this.setFinishButtonEnabled(false);
        }
    }

    public int getPageType() {
        return 1;
    }

    private void handleModifyEvent() {
        String text = this.txtoutput.getText();
        if (text == null || text.trim().equals("")) {
            return;
        }
    }

    private void handleAxisHomeModifyEvent() {
        String text = this.txtaxisHome.getText();
        if (text == null || text.trim().equals("")) {
            return;
        }
    }

    private void handleJarNameModifyEvent() {
        String text = this.txtjarFileName.getText();
        if (text == null || text.trim().equals("")) {
            return;
        }
    }
}

