/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;

public class OperationContext
extends AbstractContext {
    private boolean isComplete;
    private transient AxisOperation axisOperation;
    private HashMap messageContexts = new HashMap();
    private Map operationContextMap;

    public OperationContext(AxisOperation axisOperation) {
        super(null);
        this.axisOperation = axisOperation;
    }

    public OperationContext(AxisOperation axisOperation, ServiceContext serviceContext) {
        super(serviceContext);
        this.axisOperation = axisOperation;
        this.operationContextMap = this.getServiceContext().getConfigurationContext().getOperationContextMap();
    }

    public void addMessageContext(MessageContext msgContext) throws AxisFault {
        if (this.axisOperation != null) {
            this.axisOperation.addMessageContext(msgContext, this);
            this.touch();
        }
    }

    public void cleanup() {
        Iterator msgContexts = this.messageContexts.values().iterator();
        while (msgContexts.hasNext()) {
            MessageContext messageContext = (MessageContext)msgContexts.next();
            if (null == messageContext || this.operationContextMap == null) continue;
            this.operationContextMap.remove(messageContext.getMessageID());
        }
    }

    public AxisOperation getAxisOperation() {
        return this.axisOperation;
    }

    public ConfigurationContext getConfigurationContext() {
        return ((ServiceContext)this.parent).getConfigurationContext();
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        return (MessageContext)this.messageContexts.get(messageLabel);
    }

    public HashMap getMessageContexts() {
        return this.messageContexts;
    }

    public ServiceContext getServiceContext() {
        return (ServiceContext)this.parent;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public void setParent(AbstractContext context) {
        super.setParent(context);
        this.operationContextMap = this.getServiceContext().getConfigurationContext().getOperationContextMap();
    }
}

