/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.Scheduler;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL2AxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentEngine
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)DeploymentEngine.class);
    private boolean hotUpdate = true;
    private boolean hotDeployment = true;
    private List wsToDeploy = new ArrayList();
    private List wsToUnDeploy = new ArrayList();
    private PhasesInfo phasesinfo = new PhasesInfo();
    private ArrayList modulelist = new ArrayList();
    private String webLocationString = null;
    private AxisConfiguration axisConfig;
    private ArchiveFileData currentArchiveFile;
    private RepositoryListener repoListener;

    public void loadServices() {
        this.repoListener.checkServices();
        if (this.hotDeployment) {
            this.startSearch(this.repoListener);
        }
    }

    public void loadRepository(String repoDir) throws DeploymentException {
        File axisRepo = new File(repoDir);
        if (!axisRepo.exists()) {
            throw new DeploymentException(Messages.getMessage("cannotfindrepo", repoDir));
        }
        this.prepareRepository(repoDir);
        this.setClassLoaders(repoDir);
        this.setDeploymentFeatures();
        this.repoListener = new RepositoryListener(repoDir, this);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        try {
            try {
                this.axisConfig.setRepository(axisRepo.toURL());
            }
            catch (MalformedURLException e) {
                log.info((Object)e.getMessage());
            }
            this.validateSystemPredefinedPhases();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    public void loadFromClassPath() throws DeploymentException {
        new RepositoryListener(this);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        this.validateSystemPredefinedPhases();
        try {
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            log.info((Object)Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
    }

    public void loadServicesFromUrl(URL repoURL) {
        try {
            URL servicesDir = new URL(repoURL, "services");
            InputStream serviceStream = servicesDir.openStream();
            if (serviceStream == null) {
                log.info((Object)"No services dir found");
            } else {
                URL filelisturl = new URL(servicesDir, "services/services.list");
                ArrayList files = this.getFileList(filelisturl);
                Iterator fileIterator = files.iterator();
                while (fileIterator.hasNext()) {
                    String fileUrl = (String)fileIterator.next();
                    if (!fileUrl.endsWith(".aar")) continue;
                    AxisServiceGroup serviceGroup = new AxisServiceGroup();
                    URL servicesURL = new URL(servicesDir, "services/" + fileUrl);
                    ArrayList servicelist = this.populateService(serviceGroup, servicesURL, fileUrl.substring(0, fileUrl.indexOf(".aar")));
                    this.addServiceGroup(serviceGroup, servicelist, servicesURL);
                }
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e.getMessage());
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void loadRepositoryFromURL(URL repoURL) throws DeploymentException {
        try {
            URL moduleDir = new URL(repoURL, "modules");
            InputStream moduleStream = moduleDir.openStream();
            if (moduleStream == null) {
                log.info((Object)"No module dir found");
            } else {
                URL filelisturl = new URL(moduleDir, "modules/modules.list");
                ArrayList files = this.getFileList(filelisturl);
                Iterator fileIterator = files.iterator();
                while (fileIterator.hasNext()) {
                    String fileUrl = (String)fileIterator.next();
                    if (!fileUrl.endsWith(".mar")) continue;
                    URL moduleurl = new URL(moduleDir, "modules/" + fileUrl);
                    DeploymentClassLoader deploymentClassLoader = new DeploymentClassLoader(new URL[]{moduleurl}, this.axisConfig.getModuleClassLoader());
                    AxisModule module = new AxisModule();
                    module.setModuleClassLoader(deploymentClassLoader);
                    module.setParent(this.axisConfig);
                    String moduleName = fileUrl.substring(0, fileUrl.indexOf(".mar"));
                    module.setName(new QName(moduleName));
                    this.populateModule(module, moduleurl);
                    module.setFileName(moduleurl);
                    this.addNewModule(module);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoadere = module.getModuleClassLoader();
            InputStream moduleStream = classLoadere.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoadere.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    private ArrayList populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            serviceGroup.setServiceGroupName(serviceName);
            DeploymentClassLoader serviceClassLoader = new DeploymentClassLoader(new URL[]{servicesURL}, this.axisConfig.getServiceClassLoader());
            String metainf = "meta-inf";
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            InputStream servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml");
            if (servicexmlStream == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            } else {
                metainf = "META-INF";
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage("servicexmlnotfound", servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, this.axisConfig);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if ("service".equals(elementName)) {
                AxisDescription axisService = null;
                InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                if (wsdlStream == null && (wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl")) != null) {
                    WSDL2AxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL2AxisServiceBuilder(wsdlStream, null, null);
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    ((AxisService)axisService).setWsdlfound(true);
                    ((AxisService)axisService).setName(serviceName);
                }
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                }
                axisService.setParent(serviceGroup);
                ((AxisService)axisService).setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.axisConfig, (AxisService)axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            }
            if ("serviceGroup".equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, new HashMap(), this.axisConfig);
                ArrayList servicList = groupBuilder.populateServiceGroup(serviceGroup);
                Iterator serviceIterator = servicList.iterator();
                while (serviceIterator.hasNext()) {
                    AxisService axisService = (AxisService)serviceIterator.next();
                    InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                    if (wsdlStream != null || (wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl")) == null) continue;
                    WSDL2AxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL2AxisServiceBuilder(wsdlStream, axisService);
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    axisService.setWsdlfound(true);
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation operation = (AxisOperation)operations.next();
                        if (operation.getMessageReceiver() != null) continue;
                        operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), axisService));
                    }
                }
                return servicList;
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return null;
    }

    protected MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2004/08/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    public void addModule(QName moduleName) {
        this.modulelist.add(moduleName);
    }

    private void addNewModule(AxisModule modulemetadata) throws AxisFault {
        Flow faultOutFlow;
        Flow faultInFlow;
        Flow outFlow;
        Flow inflow = modulemetadata.getInFlow();
        ClassLoader moduleClassLoader = modulemetadata.getModuleClassLoader();
        if (inflow != null) {
            Utils.addFlowHandlers(inflow, moduleClassLoader);
        }
        if ((outFlow = modulemetadata.getOutFlow()) != null) {
            Utils.addFlowHandlers(outFlow, moduleClassLoader);
        }
        if ((faultInFlow = modulemetadata.getFaultInFlow()) != null) {
            Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
        }
        if ((faultOutFlow = modulemetadata.getFaultOutFlow()) != null) {
            Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
        }
        this.axisConfig.addModule(modulemetadata);
        log.debug((Object)Messages.getMessage("addingnewmodule"));
    }

    private void addServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList, URL serviceLocation) throws AxisFault {
        serviceGroup.setParent(this.axisConfig);
        ArrayList groupModules = serviceGroup.getModuleRefs();
        for (int i = 0; i < groupModules.size(); ++i) {
            QName moduleName = (QName)groupModules.get(i);
            AxisModule module = this.axisConfig.getModule(moduleName);
            if (module == null) {
                throw new DeploymentException(Messages.getMessage("badModuleFromService", serviceGroup.getServiceGroupName(), moduleName.getLocalPart()));
            }
            serviceGroup.engageModule(this.axisConfig.getModule(moduleName));
        }
        Iterator services = serviceList.iterator();
        while (services.hasNext()) {
            int i;
            ArrayList<AxisOperation> contolops = new ArrayList<AxisOperation>();
            AxisService axisService = (AxisService)services.next();
            axisService.setUseDefaultChains(false);
            axisService.setFileName(serviceLocation);
            serviceGroup.addService(axisService);
            ArrayList list = axisService.getModules();
            for (i = 0; i < list.size(); ++i) {
                AxisModule module = this.axisConfig.getModule((QName)list.get(i));
                if (module == null) {
                    throw new DeploymentException(Messages.getMessage("badModuleFromService", axisService.getName(), ((QName)list.get(i)).getLocalPart()));
                }
                axisService.engageModule(module, this.axisConfig);
            }
            Iterator iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation opDesc = (AxisOperation)iterator.next();
                ArrayList modules = opDesc.getModuleRefs();
                for (int i2 = 0; i2 < modules.size(); ++i2) {
                    QName moduleName = (QName)modules.get(i2);
                    AxisModule module = this.axisConfig.getModule(moduleName);
                    if (module != null) {
                        ArrayList controlops = opDesc.engageModule(module, this.axisConfig);
                        for (int j = 0; j < controlops.size(); ++j) {
                            AxisOperation axisOperation = (AxisOperation)controlops.get(j);
                            contolops.add(axisOperation);
                        }
                        continue;
                    }
                    throw new DeploymentException(Messages.getMessage("badModuleFromOperation", opDesc.getName().getLocalPart(), moduleName.getLocalPart()));
                }
            }
            for (i = 0; i < contolops.size(); ++i) {
                AxisOperation axisOperation = (AxisOperation)contolops.get(i);
                axisService.addOperation(axisOperation);
            }
            contolops.clear();
        }
        this.axisConfig.addServiceGroup(serviceGroup);
        if (this.currentArchiveFile != null) {
            this.addAsWebResources(this.currentArchiveFile.getFile(), serviceGroup.getServiceGroupName());
        }
    }

    private void addAsWebResources(File in, String serviceFileName) {
        try {
            ZipEntry entry;
            if (this.webLocationString == null) {
                return;
            }
            if (in.isDirectory()) {
                return;
            }
            File webLocation = new File(this.webLocationString);
            File out = new File(webLocation, serviceFileName);
            int BUFFER = 1024;
            byte[] data = new byte[BUFFER];
            ZipInputStream zin = new ZipInputStream(new FileInputStream(in));
            while ((entry = zin.getNextEntry()) != null) {
                int count;
                ZipEntry zip = new ZipEntry(entry);
                if (!zip.getName().toUpperCase().startsWith("WWW")) continue;
                String fileName = zip.getName();
                fileName = fileName.substring("WWW/".length(), fileName.length());
                if (zip.isDirectory()) {
                    new File(out, fileName).mkdirs();
                    continue;
                }
                FileOutputStream tempOut = new FileOutputStream(new File(out, fileName));
                while ((count = zin.read(data, 0, BUFFER)) != -1) {
                    tempOut.write(data, 0, count);
                }
                tempOut.close();
                tempOut.flush();
            }
            zin.close();
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void addWSToDeploy(ArchiveFileData file) {
        this.wsToDeploy.add(file);
    }

    public void addWSToUndeploy(WSInfo file) {
        this.wsToUnDeploy.add(file);
    }

    public AxisModule buildModule(File modulearchive, AxisConfiguration config) throws DeploymentException {
        AxisModule axismodule;
        try {
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            this.setPhasesinfo(config.getPhasesInfo());
            this.currentArchiveFile = new ArchiveFileData(modulearchive, 1);
            axismodule = new AxisModule();
            ArchiveReader archiveReader = new ArchiveReader();
            this.currentArchiveFile.setClassLoader(false, config.getModuleClassLoader());
            axismodule.setModuleClassLoader(this.currentArchiveFile.getClassLoader());
            archiveReader.readModuleArchive(this.currentArchiveFile.getAbsolutePath(), this, axismodule, false, this.axisConfig);
            ClassLoader moduleClassLoader = axismodule.getModuleClassLoader();
            Flow inflow = axismodule.getInFlow();
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axismodule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axismodule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axismodule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        this.currentArchiveFile = null;
        return axismodule;
    }

    public AxisService buildService(AxisService axisService, InputStream serviceInputStream, ClassLoader classLoader, AxisConfiguration axisConfig) throws DeploymentException {
        try {
            this.currentArchiveFile = new ArchiveFileData(0, "");
            this.currentArchiveFile.setClassLoader(classLoader);
            ServiceBuilder builder = new ServiceBuilder(serviceInputStream, axisConfig, axisService);
            builder.populateService(builder.buildOM());
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return axisService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDeploy() {
        if (this.wsToDeploy.size() > 0) {
            for (int i = 0; i < this.wsToDeploy.size(); ++i) {
                this.currentArchiveFile = (ArchiveFileData)this.wsToDeploy.get(i);
                boolean explodedDir = this.currentArchiveFile.getFile().isDirectory();
                int type = this.currentArchiveFile.getType();
                try {
                    StringWriter errorWriter = new StringWriter();
                    switch (type) {
                        case 0: {
                            Object var13_20;
                            this.currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getServiceClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String serviceStatus = "";
                            try {
                                PrintWriter pw;
                                StringWriter sw;
                                PrintWriter error_ptintWriter;
                                try {
                                    HashMap wsdlservice = archiveReader.processWSDLs(this.currentArchiveFile, this);
                                    if (wsdlservice != null && wsdlservice.size() > 0) {
                                        Iterator services = wsdlservice.values().iterator();
                                        while (services.hasNext()) {
                                            AxisService service = (AxisService)services.next();
                                            Iterator operations = service.getOperations();
                                            while (operations.hasNext()) {
                                                AxisOperation axisOperation = (AxisOperation)operations.next();
                                                this.phasesinfo.setOperationPhases(axisOperation);
                                            }
                                        }
                                    }
                                    AxisServiceGroup sericeGroup = new AxisServiceGroup(this.axisConfig);
                                    sericeGroup.setServiceGroupClassLoader(this.currentArchiveFile.getClassLoader());
                                    ArrayList serviceList = archiveReader.processServiceGroup(this.currentArchiveFile.getAbsolutePath(), this, sericeGroup, explodedDir, wsdlservice, this.axisConfig);
                                    this.addServiceGroup(sericeGroup, serviceList, this.currentArchiveFile.getFile().toURL());
                                    log.debug((Object)Messages.getMessage("deployingws", this.currentArchiveFile.getName()));
                                }
                                catch (DeploymentException de) {
                                    log.error((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), de.getMessage()), (Throwable)de);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    de.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var13_20 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    log.error((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), axisFault.getMessage()), (Throwable)axisFault);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var13_20 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (Exception e) {
                                    if (log.isInfoEnabled()) {
                                        sw = new StringWriter();
                                        pw = new PrintWriter(sw);
                                        e.printStackTrace(pw);
                                        log.info((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), sw.getBuffer().toString()));
                                    }
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var13_20 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (Throwable t) {
                                    if (log.isInfoEnabled()) {
                                        sw = new StringWriter();
                                        pw = new PrintWriter(sw);
                                        t.printStackTrace(pw);
                                        log.info((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), sw.getBuffer().toString()));
                                    }
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    t.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var13_20 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                var13_20 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                }
                                this.currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var13_20 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(this.currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                }
                                this.currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                        case 1: {
                            Object var15_21;
                            this.currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getModuleClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String moduleStatus = "";
                            try {
                                PrintWriter error_ptintWriter;
                                try {
                                    AxisModule metaData = new AxisModule();
                                    metaData.setModuleClassLoader(this.currentArchiveFile.getClassLoader());
                                    metaData.setParent(this.axisConfig);
                                    archiveReader.readModuleArchive(this.currentArchiveFile.getAbsolutePath(), this, metaData, explodedDir, this.axisConfig);
                                    metaData.setFileName(this.currentArchiveFile.getFile().toURL());
                                    this.addNewModule(metaData);
                                    log.info((Object)Messages.getMessage("deployeingmodule", metaData.getName().getLocalPart()));
                                }
                                catch (DeploymentException e) {
                                    log.error((Object)Messages.getMessage("invalidmodule", this.currentArchiveFile.getName(), e.getMessage()), (Throwable)e);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var15_21 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    log.error((Object)Messages.getMessage("invalidmodule", this.currentArchiveFile.getName(), axisFault.getMessage()), (Throwable)axisFault);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var15_21 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (MalformedURLException e) {
                                    log.error((Object)Messages.getMessage("invalidmodule", this.currentArchiveFile.getName(), e.getMessage()), (Throwable)e);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var15_21 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                var15_21 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                }
                                this.currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var15_21 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                }
                                this.currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.info((Object)Messages.getMessage("settingcl", axisFault.getMessage()), (Throwable)axisFault);
                }
            }
        }
        this.wsToDeploy.clear();
    }

    public void engageModules() throws AxisFault {
        Iterator iterator = this.modulelist.iterator();
        while (iterator.hasNext()) {
            QName name = (QName)iterator.next();
            this.axisConfig.engageModule(name);
        }
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        this.axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this, this.axisConfig);
        builder.populateConfig();
        this.axisConfig.setPhasesinfo(this.phasesinfo);
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.info((Object)"error in closing input stream");
        }
        return this.axisConfig;
    }

    private void startSearch(RepositoryListener listener) {
        Scheduler scheduler = new Scheduler();
        scheduler.schedule(new SchedulerTask(listener), new DeploymentIterator());
    }

    public void unDeploy() {
        try {
            if (this.wsToUnDeploy.size() > 0) {
                for (int i = 0; i < this.wsToUnDeploy.size(); ++i) {
                    WSInfo wsInfo = (WSInfo)this.wsToUnDeploy.get(i);
                    if (wsInfo.getType() != 0) continue;
                    String fileName = this.getAxisServiceName(wsInfo.getFileName());
                    this.axisConfig.removeServiceGroup(fileName);
                    log.info((Object)Messages.getMessage("serviceremoved", wsInfo.getFileName()));
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e);
        }
        this.wsToUnDeploy.clear();
    }

    private void validateSystemPredefinedPhases() throws DeploymentException {
        this.axisConfig.setInPhasesUptoAndIncludingPostDispatch(this.phasesinfo.getGlobalInflow());
        this.axisConfig.setInFaultPhases(this.phasesinfo.getGlobalInFaultPhases());
        this.axisConfig.setGlobalOutPhase(this.phasesinfo.getGlobalOutPhaseList());
        this.axisConfig.setOutFaultPhases(this.phasesinfo.getOUT_FaultPhases());
    }

    public AxisConfiguration getAxisConfig() {
        return this.axisConfig;
    }

    private String getAxisServiceName(String fileName) {
        int seperator = 46;
        int index = fileName.indexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    public ArchiveFileData getCurrentFileItem() {
        return this.currentArchiveFile;
    }

    public AxisModule getModule(QName moduleName) throws AxisFault {
        return this.axisConfig.getModule(moduleName);
    }

    public PhasesInfo getPhasesinfo() {
        return this.phasesinfo;
    }

    public boolean isHotUpdate() {
        return this.hotUpdate;
    }

    private void setClassLoaders(String axis2repoURI) throws DeploymentException {
        ClassLoader sysClassLoader = Utils.getClassLoader(Thread.currentThread().getContextClassLoader(), axis2repoURI);
        this.axisConfig.setSystemClassLoader(sysClassLoader);
        File axis2repo = new File(axis2repoURI);
        File services = new File(axis2repo, "services");
        if (services.exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), services));
        } else {
            this.axisConfig.setServiceClassLoader(this.axisConfig.getSystemClassLoader());
        }
        File modules = new File(axis2repo, "modules");
        if (modules.exists()) {
            this.axisConfig.setModuleClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), modules));
        } else {
            this.axisConfig.setModuleClassLoader(this.axisConfig.getSystemClassLoader());
        }
    }

    private void setDeploymentFeatures() {
        String value;
        Parameter parahotdeployment = this.axisConfig.getParameter("hotdeployment");
        Parameter parahotupdate = this.axisConfig.getParameter("hotupdate");
        if (parahotdeployment != null && "false".equalsIgnoreCase(value = (String)parahotdeployment.getValue())) {
            this.hotDeployment = false;
        }
        if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.hotUpdate = false;
        }
    }

    public void setPhasesinfo(PhasesInfo phasesinfo) {
        this.phasesinfo = phasesinfo;
    }

    private void prepareRepository(String repositoryName) {
        File modules;
        File repository = new File(repositoryName);
        File services = new File(repository, "services");
        if (!services.exists()) {
            log.info((Object)Messages.getMessage("noservicedirfound"));
        }
        if (!(modules = new File(repository, "modules")).exists()) {
            log.info((Object)Messages.getMessage("nomoduledirfound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList getFileList(URL fileListUrl) {
        ArrayList<String> fileList;
        block14: {
            String line;
            InputStream in;
            fileList = new ArrayList<String>();
            try {
                in = fileListUrl.openStream();
            }
            catch (IOException e) {
                return fileList;
            }
            BufferedReader input = null;
            input = new BufferedReader(new InputStreamReader(in));
            while ((line = input.readLine()) != null) {
                fileList.add(line);
            }
            Object var7_8 = null;
            try {
                if (input != null) {
                    input.close();
                }
                break block14;
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
            break block14;
            {
                catch (IOException ex) {
                    ex.printStackTrace();
                    Object var7_9 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block14;
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
        return fileList;
    }

    public String getWebLocationString() {
        return this.webLocationString;
    }

    public void setWebLocationString(String webLocationString) {
        this.webLocationString = webLocationString;
    }
}

