/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.WSInfoList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryListener
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)RepositoryListener.class);
    private DeploymentEngine deploymentEngine;
    private File rootDir;
    private WSInfoList wsInfoList;

    public RepositoryListener(String folderName, DeploymentEngine deploymentEngine) {
        this.rootDir = new File(folderName);
        this.wsInfoList = new WSInfoList(deploymentEngine);
        this.deploymentEngine = deploymentEngine;
        this.init();
        this.loadClassPathModules();
    }

    public RepositoryListener(DeploymentEngine deploymentEngine) {
        this.deploymentEngine = deploymentEngine;
        this.wsInfoList = new WSInfoList(deploymentEngine);
        this.loadClassPathModules();
    }

    public void checkModules() {
        File root = new File(this.rootDir, "modules");
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 1);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
    }

    private boolean isSourceControlDir(File file) {
        String name;
        return file.isDirectory() && ((name = file.getName()).equalsIgnoreCase("CVS") || name.equalsIgnoreCase(".svn"));
    }

    private void loadClassPathModules() {
        String classPath = this.getLocation();
        int lstindex = classPath.lastIndexOf(File.separatorChar);
        classPath = lstindex > 0 ? classPath.substring(0, lstindex) : ".";
        File root = new File(classPath);
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory() || !ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
        this.deploymentEngine.doDeploy();
    }

    private String getLocation() {
        try {
            Class<?> clazz = Class.forName("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                File file = new File(url.getFile());
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return "an unknown location";
        }
    }

    public void checkServices() {
        this.findServicesInDirectory();
        this.update();
    }

    public void init() {
        this.wsInfoList.init();
        this.checkModules();
        this.deploymentEngine.doDeploy();
    }

    private void findServicesInDirectory() {
        File root = new File(this.rootDir, "services");
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isServiceArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 0);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 0);
            }
        }
    }

    public void startListener() {
        this.checkServices();
        this.update();
    }

    public void update() {
        this.wsInfoList.update();
    }
}

