/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WarBasedAxisConfigurator
implements AxisConfigurator {
    private AxisConfiguration axisConfig;
    private static final Log log = LogFactory.getLog((Class)WarBasedAxisConfigurator.class);
    private ServletConfig config;
    private DeploymentEngine deploymentEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public WarBasedAxisConfigurator(ServletConfig svconfig) {
        block20: {
            this.config = svconfig;
            this.deploymentEngine = new DeploymentEngine();
            String axis2xmlpath = this.config.getInitParameter("axis2.xml.path");
            if (axis2xmlpath != null) {
                FileInputStream axis2Steram = new FileInputStream(axis2xmlpath);
                this.axisConfig = this.deploymentEngine.populateAxisConfiguration(axis2Steram);
            } else {
                String axisurl = this.config.getInitParameter("axis2.xml.url");
                if (axisurl != null) {
                    InputStream axis2Steram = new URL(axisurl).openStream();
                    this.deploymentEngine.populateAxisConfiguration(axis2Steram);
                } else {
                    try {
                        String repository = this.config.getServletContext().getRealPath("/WEB-INF");
                        FileInputStream axis2Steram = new FileInputStream(repository + "/conf/axis2.xml");
                        this.axisConfig = this.deploymentEngine.populateAxisConfiguration(axis2Steram);
                        this.setWebLocationProperty(this.config.getServletContext(), this.deploymentEngine);
                    }
                    catch (Exception e) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        InputStream axis2Steram = cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
                        this.axisConfig = this.deploymentEngine.populateAxisConfiguration(axis2Steram);
                    }
                }
            }
            Object var9_15 = null;
            try {
                Parameter unableHttp = new Parameter("enableHTTP", "true");
                this.axisConfig.addParameter(unableHttp);
            }
            catch (AxisFault axisFault) {
                log.info((Object)axisFault.getMessage());
            }
            break block20;
            {
                catch (FileNotFoundException e) {
                    log.info((Object)e.getMessage());
                    Object var9_16 = null;
                    try {
                        Parameter unableHttp = new Parameter("enableHTTP", "true");
                        this.axisConfig.addParameter(unableHttp);
                    }
                    catch (AxisFault axisFault) {
                        log.info((Object)axisFault.getMessage());
                    }
                    break block20;
                }
                catch (DeploymentException e) {
                    log.info((Object)e.getMessage());
                    Object var9_17 = null;
                    try {
                        Parameter unableHttp = new Parameter("enableHTTP", "true");
                        this.axisConfig.addParameter(unableHttp);
                    }
                    catch (AxisFault axisFault) {
                        log.info((Object)axisFault.getMessage());
                    }
                    break block20;
                }
                catch (MalformedURLException e) {
                    log.info((Object)e.getMessage());
                    Object var9_18 = null;
                    try {
                        Parameter unableHttp = new Parameter("enableHTTP", "true");
                        this.axisConfig.addParameter(unableHttp);
                    }
                    catch (AxisFault axisFault) {
                        log.info((Object)axisFault.getMessage());
                    }
                    break block20;
                }
                catch (IOException e) {
                    log.info((Object)e.getMessage());
                    Object var9_19 = null;
                    try {
                        Parameter unableHttp = new Parameter("enableHTTP", "true");
                        this.axisConfig.addParameter(unableHttp);
                    }
                    catch (AxisFault axisFault) {
                        log.info((Object)axisFault.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_20 = null;
                try {
                    Parameter unableHttp = new Parameter("enableHTTP", "true");
                    this.axisConfig.addParameter(unableHttp);
                }
                catch (AxisFault axisFault) {
                    log.info((Object)axisFault.getMessage());
                }
                throw throwable;
            }
        }
    }

    private void setWebLocationProperty(ServletContext context, DeploymentEngine depeng) {
        String webpath = context.getRealPath("");
        if (webpath == null || "".equals(webpath)) {
            return;
        }
        File weblocation = new File(webpath);
        depeng.setWebLocationString(weblocation.getAbsolutePath());
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            String axis2repopath = this.config.getInitParameter("axis2.repository.path");
            if (axis2repopath != null) {
                this.deploymentEngine.loadRepository(axis2repopath);
            } else {
                String axis2repourl = this.config.getInitParameter("axis2.repository.url");
                if (axis2repourl != null) {
                    this.deploymentEngine.loadRepositoryFromURL(new URL(axis2repourl));
                } else {
                    try {
                        String repository = this.config.getServletContext().getRealPath("/WEB-INF");
                        this.deploymentEngine.loadRepository(repository);
                    }
                    catch (Exception e) {
                        this.deploymentEngine.loadFromClassPath();
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e.getMessage());
        }
        return this.axisConfig;
    }

    public void loadServices() {
        try {
            String axis2repopath = this.config.getInitParameter("axis2.repository.path");
            if (axis2repopath != null) {
                this.deploymentEngine.loadServices();
            } else {
                String axis2repourl = this.config.getInitParameter("axis2.repository.url");
                if (axis2repourl != null) {
                    this.deploymentEngine.loadServicesFromUrl(new URL(axis2repourl));
                } else {
                    try {
                        this.config.getServletContext().getRealPath("/WEB-INF");
                        this.deploymentEngine.loadServices();
                    }
                    catch (Exception e) {
                        log.info((Object)e.getMessage());
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void engageGlobalModules() throws AxisFault {
        this.deploymentEngine.engageModules();
    }
}

