/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService2OM;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.WSDL2AxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.java2wsdl.SchemaGenerator;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JMethod;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AxisService
extends AxisDescription {
    private int nsCount = 0;
    private static final Log log = LogFactory.getLog((Class)AxisService.class);
    private URL fileName;
    private HashMap operationsAliasesMap = new HashMap();
    private ArrayList moduleRefs = null;
    private ArrayList engagedModules = null;
    private String serviceDescription;
    private long lastupdate;
    private HashMap moduleConfigmap = new HashMap();
    private String name;
    private ClassLoader serviceClassLoader;
    private ArrayList schemaList;
    private boolean wsdlfound = false;
    private String scope = "request";
    private HashMap messageReceivers = new HashMap();
    private boolean useDefaultChains = true;
    private boolean active = true;
    private String targetNamespace = "http://ws.apache.org/axis2";
    private String targetNamespacePrefix = "tns";
    private String schematargetNamespace;
    private String schematargetNamespacePrefix = "ns";
    private boolean enableAllTransport = true;
    private String[] exposeTransports;
    private boolean schemaLocationsAdjusted = false;
    private Hashtable schemaMappingTable = null;
    private int count = 0;
    private String customSchemaNamePrefix = null;
    private String customSchemaNameSuffix = null;
    private Map nameSpacesMap;
    private String soapNsUri;
    private String endpoint;

    public boolean isSchemaLocationsAdjusted() {
        return this.schemaLocationsAdjusted;
    }

    public void setSchemaLocationsAdjusted(boolean schemaLocationsAdjusted) {
        this.schemaLocationsAdjusted = schemaLocationsAdjusted;
    }

    public Hashtable getSchemaMappingTable() {
        return this.schemaMappingTable;
    }

    public void setSchemaMappingTable(Hashtable schemaMappingTable) {
        this.schemaMappingTable = schemaMappingTable;
    }

    public String getCustomSchemaNamePrefix() {
        return this.customSchemaNamePrefix;
    }

    public void setCustomSchemaNamePrefix(String customSchemaNamePrefix) {
        this.customSchemaNamePrefix = customSchemaNamePrefix;
    }

    public String getCustomSchemaNameSuffix() {
        return this.customSchemaNameSuffix;
    }

    public void setCustomSchemaNameSuffix(String customSchemaNameSuffix) {
        this.customSchemaNameSuffix = customSchemaNameSuffix;
    }

    public AxisService() {
        this.moduleRefs = new ArrayList();
        this.engagedModules = new ArrayList();
        this.schemaList = new ArrayList();
        this.serviceClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public String getSoapNsUri() {
        return this.soapNsUri;
    }

    public void setSoapNsUri(String soapNsUri) {
        this.soapNsUri = soapNsUri;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public AxisService(String name) {
        this();
        this.name = name;
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleOperations(AxisModule module, AxisConfiguration axisConfig) throws AxisFault {
        HashMap map = module.getOperations();
        Collection col = map.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation((AxisOperation)iterator.next());
            if (this.getOperation(axisOperation.getName()) != null) continue;
            ArrayList wsamappings = axisOperation.getWsamappingList();
            if (wsamappings != null) {
                for (int j = 0; j < wsamappings.size(); ++j) {
                    String mapping = (String)wsamappings.get(j);
                    this.mapActionToOperation(mapping, axisOperation);
                }
            }
            axisOperation.setControlOperation(true);
            this.addOperation(axisOperation);
        }
    }

    public void addModuleref(QName moduleref) {
        this.moduleRefs.add(moduleref);
    }

    public void addOperation(AxisOperation axisOperation) {
        axisOperation.setParent(this);
        Iterator modules = this.getEngagedModules().iterator();
        while (modules.hasNext()) {
            AxisModule module = (AxisModule)modules.next();
            AxisServiceGroup parent = (AxisServiceGroup)this.getParent();
            AxisConfiguration axisConfig = null;
            if (parent != null) {
                axisConfig = (AxisConfiguration)parent.getParent();
            }
            try {
                Module moduleImpl = module.getModule();
                if (moduleImpl != null) {
                    moduleImpl.engageNotify(axisOperation);
                }
                axisOperation.engageModule(module, axisConfig);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("modulealredyengagetoservice", module.getName().getLocalPart()));
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
        if (axisOperation.getSoapAction() == null) {
            axisOperation.setSoapAction("urn:" + axisOperation.getName().getLocalPart());
        }
        this.addChild(axisOperation);
        this.operationsAliasesMap.put(axisOperation.getName().getLocalPart(), axisOperation);
        this.operationsAliasesMap.put(axisOperation.getSoapAction(), axisOperation);
    }

    private MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2004/08/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        if (this.getParent() != null && this.getParent().getParent() != null) {
            return ((AxisConfiguration)this.getParent().getParent()).getMessageReceiver(mepURL);
        }
        return null;
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        Iterator parameters = axisOperation.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            operation.addParameter(parameter);
        }
        operation.setWsamappingList(axisOperation.getWsamappingList());
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        return operation;
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        if (axisModule == null) {
            throw new AxisFault(Messages.getMessage("modulenf"));
        }
        Iterator itr_engageModules = this.engagedModules.iterator();
        while (itr_engageModules.hasNext()) {
            AxisModule module = (AxisModule)itr_engageModules.next();
            if (!module.getName().equals(axisModule.getName())) continue;
            log.debug((Object)Messages.getMessage("modulealredyengagetoservice", axisModule.getName().getLocalPart()));
            throw new AxisFault(Messages.getMessage("modulealredyengagetoservice", axisModule.getName().getLocalPart()));
        }
        Module moduleImpl = axisModule.getModule();
        if (moduleImpl != null) {
            moduleImpl.engageNotify(this);
        }
        this.addModuleOperations(axisModule, axisConfig);
        Iterator operations = this.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (moduleImpl != null) {
                moduleImpl.engageNotify(axisOperation);
            }
            axisOperation.engageModule(axisModule, axisConfig);
        }
        this.engagedModules.add(axisModule);
    }

    public void mapActionToOperation(String action, AxisOperation axisOperation) {
        this.operationsAliasesMap.put(action, axisOperation);
    }

    public void printSchema(OutputStream out) throws AxisFault {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchema schema = this.addNameSpaces(i);
            schema.write(out);
        }
    }

    public XmlSchema getSchema(int index) {
        return this.addNameSpaces(index);
    }

    private XmlSchema addNameSpaces(int i) {
        XmlSchema schema = (XmlSchema)this.schemaList.get(i);
        Iterator keys = this.nameSpacesMap.keySet().iterator();
        Hashtable prefixTable = schema.getPrefixToNamespaceMap();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (prefixTable.get(key) != null) continue;
            prefixTable.put(key, this.nameSpacesMap.get(key));
        }
        return schema;
    }

    public void printPolicy(OutputStream out) throws AxisFault {
        PolicyUtil.writePolicy(this.getPolicyInclude(), out);
    }

    public void printPolicy(OutputStream out, String operationName) throws AxisFault {
        AxisOperation axisOperation = this.getOperation(new QName(operationName));
        if (axisOperation == null) {
            throw new AxisFault(Messages.getMessage("invalidoperation", operationName));
        }
        PolicyUtil.writePolicy(axisOperation.getPolicyInclude(), out);
    }

    public AxisConfiguration getAxisConfiguration() {
        if (this.getParent() != null) {
            return (AxisConfiguration)this.getParent().getParent();
        }
        return null;
    }

    public void printWSDL(OutputStream out, String requestIP) throws AxisFault {
        ArrayList<String> eprList = new ArrayList<String>();
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (this.enableAllTransport) {
            Iterator transports = axisConfig.getTransportsIn().values().iterator();
            while (transports.hasNext()) {
                TransportInDescription transportIn = (TransportInDescription)transports.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null) continue;
                try {
                    String address;
                    if (listener.getEPRForService(this.getName(), requestIP) == null || (address = listener.getEPRForService(this.getName(), requestIP).getAddress()) == null) continue;
                    eprList.add(address);
                }
                catch (AxisFault axisFault) {
                    log.info((Object)axisFault.getMessage());
                }
            }
        } else {
            String[] trs = this.getExposeTransports();
            for (int i = 0; i < trs.length; ++i) {
                TransportListener listener;
                String trsName = trs[i];
                TransportInDescription transportIn = axisConfig.getTransportIn(new QName(trsName));
                if (transportIn == null || (listener = transportIn.getReceiver()) == null) continue;
                try {
                    String address;
                    if (listener.getEPRForService(this.getName(), requestIP) == null || (address = listener.getEPRForService(this.getName(), requestIP).getAddress()) == null) continue;
                    eprList.add(address);
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.info((Object)axisFault.getMessage());
                }
            }
        }
        String[] eprArray = eprList.toArray(new String[eprList.size()]);
        this.getWSDL(out, eprArray);
    }

    public void printWSDL(OutputStream out) throws AxisFault {
        this.setWsdlfound(true);
        this.getWSDL(out, new String[]{this.getEndpoint()});
    }

    private void getWSDL(OutputStream out, String[] serviceURL) throws AxisFault {
        if (this.isWsdlfound()) {
            AxisService2OM axisService2WOM = new AxisService2OM(this, serviceURL, "document", "literal");
            try {
                OMElement wsdlElement = axisService2WOM.generateOM();
                wsdlElement.serialize(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        }
        try {
            String wsdlntfound = "<error><description>Unable to generate WSDL for this service</description><reason>Either user has not dropped the wsdl into META-INF or operations use message receivers other than RPC.</reason></error>";
            out.write(wsdlntfound.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ArrayList getControlOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (!operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public long getLastupdate() {
        return this.lastupdate;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModules() {
        return this.moduleRefs;
    }

    public String getName() {
        return this.name;
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation = (AxisOperation)this.getChild(operationName);
        if (axisOperation == null) {
            axisOperation = (AxisOperation)this.operationsAliasesMap.get(operationName.getLocalPart());
        }
        return axisOperation;
    }

    public AxisOperation getOperationByAction(String action) {
        return (AxisOperation)this.operationsAliasesMap.get(action);
    }

    public AxisOperation getOperationBySOAPAction(String soapAction) {
        if (soapAction == null || soapAction.equals("")) {
            return null;
        }
        AxisOperation operation = (AxisOperation)this.getChild(new QName(soapAction));
        if (operation != null) {
            return operation;
        }
        operation = (AxisOperation)this.operationsAliasesMap.get(soapAction);
        return operation;
    }

    public Iterator getOperations() {
        return this.getChildren();
    }

    public ArrayList getPublishedOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }

    public void setLastupdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getSchema() {
        return this.schemaList;
    }

    public void addSchema(XmlSchema schema) {
        this.schemaList.add(schema);
        this.addSchemaNameSpace(schema.getTargetNamespace());
    }

    public void addSchema(Collection schemas) {
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext()) {
            XmlSchema schema = (XmlSchema)iterator.next();
            this.schemaList.add(schema);
            this.addSchemaNameSpace(schema.getTargetNamespace());
        }
    }

    public boolean isWsdlfound() {
        return this.wsdlfound;
    }

    public void setWsdlfound(boolean wsdlfound) {
        this.wsdlfound = wsdlfound;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if ("application".equals(scope) || "transportsession".equals(scope) || "soapsession".equals(scope) || "request".equals(scope)) {
            this.scope = scope;
        }
    }

    public boolean isUseDefaultChains() {
        return this.useDefaultChains;
    }

    public void setUseDefaultChains(boolean useDefaultChains) {
        this.useDefaultChains = useDefaultChains;
    }

    public Object getKey() {
        return this.getName();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSchematargetNamespace() {
        return this.schematargetNamespace;
    }

    public void setSchematargetNamespace(String schematargetNamespace) {
        this.schematargetNamespace = schematargetNamespace;
    }

    public String getSchematargetNamespacePrefix() {
        return this.schematargetNamespacePrefix;
    }

    public void setSchematargetNamespacePrefix(String schematargetNamespacePrefix) {
        this.schematargetNamespacePrefix = schematargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public XmlSchemaElement getSchemaElement(QName elementQName) {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchemaElement element;
            XmlSchema schema = (XmlSchema)this.schemaList.get(i);
            if (schema == null || (element = schema.getElementByName(elementQName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean isEnableAllTransport() {
        return this.enableAllTransport;
    }

    public String[] getExposeTransports() {
        return this.exposeTransports;
    }

    public void setExposeTransports(String[] exposeTransports) {
        if (exposeTransports.length > 0) {
            this.enableAllTransport = false;
            this.exposeTransports = exposeTransports;
        }
    }

    public void disEngageModule(AxisModule module) {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig != null) {
            PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
            if (axisConfig.isEngaged(module.getName())) {
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disEngageModulefromOperationChian(module, axisOperation);
                    axisOperation.removeFromEngageModueList(module);
                }
            } else if (this.isEngaged(module.getName())) {
                phaseResolver.disEngageModulefromGlobalChains(module);
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disEngageModulefromOperationChian(module, axisOperation);
                    axisOperation.removeFromEngageModueList(module);
                }
            }
        }
        this.engagedModules.remove(module);
    }

    private void removeModuleOperations(AxisModule module) {
        HashMap moduleOerations = module.getOperations();
        if (moduleOerations != null) {
            Iterator moduleOperations_itr = moduleOerations.values().iterator();
            while (moduleOperations_itr.hasNext()) {
                AxisOperation operation = (AxisOperation)moduleOperations_itr.next();
                this.removeOperation(operation.getName());
            }
        }
    }

    public boolean isEngaged(QName moduleName) {
        AxisModule module = this.getAxisConfiguration().getModule(moduleName);
        if (module == null) {
            return false;
        }
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            AxisModule axisModule = (AxisModule)engagedModuleItr.next();
            if (!axisModule.getName().getLocalPart().equals(module.getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public static AxisService createClientSideAxisService(URL wsdlURL, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        try {
            InputStream in = wsdlURL.openConnection().getInputStream();
            Document doc = XMLUtils.newDocument(in);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(null, doc);
            return AxisService.createClientSideAxisService(wsdlDefinition, wsdlServiceName, portName, options);
        }
        catch (IOException e) {
            throw new AxisFault("IOException" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new AxisFault("ParserConfigurationException" + e.getMessage());
        }
        catch (SAXException e) {
            throw new AxisFault("SAXException" + e.getMessage());
        }
        catch (WSDLException e) {
            throw new AxisFault("WSDLException" + e.getMessage());
        }
    }

    public static AxisService createClientSideAxisService(Definition wsdlDefinition, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        WSDL2AxisServiceBuilder serviceBuilder = new WSDL2AxisServiceBuilder(wsdlDefinition, wsdlServiceName, portName);
        serviceBuilder.setServerSide(false);
        AxisService axisService = serviceBuilder.populateService();
        options.setTo(new EndpointReference(axisService.getEndpoint()));
        options.setSoapVersionURI(axisService.getSoapNsUri());
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass) throws AxisFault {
        SchemaGenerator schemaGenerator;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        int index = implClass.lastIndexOf(".");
        String serviceName = index > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, axisService.getSchematargetNamespace(), axisService.getSchematargetNamespacePrefix());
            ArrayList<String> excludeOpeartion = new ArrayList<String>();
            excludeOpeartion.add("init");
            excludeOpeartion.add("setOperationContext");
            excludeOpeartion.add("destroy");
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || "init".equals(jmethod.getSimpleName())) continue;
            AxisOperation operation = Utils.getAxisOperationforJmethod(jmethod, table);
            try {
                MessageReceiver messageReceiver = (MessageReceiver)messageReceiverClass.newInstance();
                operation.setMessageReceiver(messageReceiver);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault("IllegalAccessException occured during message receiver loading" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new AxisFault("InstantiationException occured during message receiver loading" + e.getMessage());
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass, String targetNameSpace, String scheamNameSpace) throws AxisFault {
        SchemaGenerator schemaGenerator;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        int index = implClass.lastIndexOf(".");
        String serviceName = index > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, scheamNameSpace, axisService.getSchematargetNamespacePrefix());
            ArrayList<String> excludeOpeartion = new ArrayList<String>();
            excludeOpeartion.add("init");
            excludeOpeartion.add("setOperationContext");
            excludeOpeartion.add("destroy");
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
            if (targetNameSpace != null && !"".equals(targetNameSpace)) {
                axisService.setTargetNamespace(targetNameSpace);
            }
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || "init".equals(jmethod.getSimpleName())) continue;
            AxisOperation operation = Utils.getAxisOperationforJmethod(jmethod, table);
            try {
                MessageReceiver messageReceiver = (MessageReceiver)messageReceiverClass.newInstance();
                operation.setMessageReceiver(messageReceiver);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault("IllegalAccessException occured during message receiver loading" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new AxisFault("InstantiationException occured during message receiver loading" + e.getMessage());
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig) throws AxisFault {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("ClassNotFoundException occured during message receiver loading" + e.getMessage());
        }
        return AxisService.createService(implClass, axisConfig, clazz);
    }

    public void removeOperation(QName opName) {
        AxisOperation operation = this.getOperation(opName);
        if (operation != null) {
            this.removeChild(opName);
            ArrayList mappingList = operation.getWsamappingList();
            if (mappingList != null) {
                for (int i = 0; i < mappingList.size(); ++i) {
                    String actionMapping = (String)mappingList.get(i);
                    this.operationsAliasesMap.remove(actionMapping);
                }
            }
            this.operationsAliasesMap.remove(operation.getName().getLocalPart());
        }
    }

    public Map getNameSpacesMap() {
        return this.nameSpacesMap;
    }

    public void setNameSpacesMap(Map nameSpacesMap) {
        this.nameSpacesMap = nameSpacesMap;
    }

    private void addSchemaNameSpace(String targetNameSpace) {
        boolean found = false;
        if (this.nameSpacesMap != null && this.nameSpacesMap.size() > 0) {
            Iterator itr = this.nameSpacesMap.values().iterator();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                if (!value.equals(targetNameSpace)) continue;
                found = true;
            }
        }
        if (this.nameSpacesMap == null) {
            this.nameSpacesMap = new HashMap();
        }
        if (!found) {
            this.nameSpacesMap.put("ns" + this.nsCount, targetNameSpace);
            ++this.nsCount;
        }
    }

    public void populateSchemaMappings() {
        ArrayList schema = this.getSchema();
        if (!this.isSchemaLocationsAdjusted()) {
            Hashtable nameTable = new Hashtable();
            this.calcualteSchemaNames(schema, nameTable);
            this.adjustSchemaNames(schema, nameTable);
            this.setSchemaMappingTable(this.swapMappingTable(nameTable));
            this.setSchemaLocationsAdjusted(true);
        }
    }

    private void calcualteSchemaNames(List schemas, Hashtable nameTable) {
        for (int i = 0; i < schemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)schemas.get(i);
            XmlSchemaObjectCollection includes = schema.getIncludes();
            for (int j = 0; j < includes.getCount(); ++j) {
                XmlSchemaExternal externalSchema;
                XmlSchema s;
                XmlSchemaObject item = includes.getItem(j);
                if (!(item instanceof XmlSchemaExternal) || (s = (externalSchema = (XmlSchemaExternal)item).getSchema()) == null) continue;
                this.calcualteSchemaNames(Arrays.asList(s), nameTable);
                nameTable.put(s, "xsd" + this.count++ + (this.customSchemaNameSuffix != null ? this.customSchemaNameSuffix : ""));
            }
        }
    }

    private void adjustSchemaNames(List schemas, Hashtable nameTable) {
        for (int i = 0; i < schemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)schemas.get(i);
            XmlSchemaObjectCollection includes = schema.getIncludes();
            for (int j = 0; j < includes.getCount(); ++j) {
                XmlSchemaExternal xmlSchemaExternal;
                XmlSchema s;
                XmlSchemaObject item = includes.getItem(j);
                if (!(item instanceof XmlSchemaExternal) || (s = (xmlSchemaExternal = (XmlSchemaExternal)item).getSchema()) == null) continue;
                this.adjustSchemaNames(Arrays.asList(s), nameTable);
                xmlSchemaExternal.setSchemaLocation(this.customSchemaNamePrefix == null ? this.getName() + "?xsd=" + nameTable.get(s) : this.customSchemaNamePrefix + nameTable.get(s));
            }
        }
    }

    private Hashtable swapMappingTable(Hashtable originalTable) {
        Hashtable swappedTable = new Hashtable(originalTable.size());
        Iterator keys = originalTable.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            swappedTable.put(originalTable.get(key), key);
        }
        return swappedTable;
    }
}

