/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyRegistry;
import org.apache.ws.policy.util.StAXPolicyWriter;

public class AxisService2OM
implements Java2WSDLConstants {
    private AxisService axisService;
    private String[] url;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private String style;
    private String use;
    private boolean generateHttp = false;

    public AxisService2OM(AxisService service, String[] serviceURL, String style, String use) {
        this.axisService = service;
        this.url = serviceURL;
        this.style = style == null ? "document" : style;
        this.use = use == null ? "literal" : use;
        this.targetNamespace = service.getTargetNamespace();
    }

    public OMElement generateOM() throws Exception {
        Object value;
        AxisDescription axisdesc;
        Parameter parameter;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        Map nameSpaceMap = this.axisService.getNameSpacesMap();
        Iterator keys = nameSpaceMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("".equals(key)) {
                ele.declareDefaultNamespace((String)nameSpaceMap.get(key));
                continue;
            }
            ele.declareNamespace((String)nameSpaceMap.get(key), key);
        }
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        String prefix = this.getPrefix(this.axisService.getTargetNamespace());
        if (prefix == null || "".equals(prefix)) {
            prefix = "axis2";
        }
        this.axisService.getNameSpacesMap().put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        ele.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        ele.addChild((OMNode)wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            schema.write((Writer)writer);
            if ("".equals(writer.toString())) continue;
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(writer.toString().getBytes()));
            StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
            wsdlTypes.addChild((OMNode)staxOMBuilder.getDocumentElement());
        }
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateSOAP11Binding(fac, ele);
        this.generateSOAP12Binding(fac, ele);
        if (this.axisService.getParent() != null && (parameter = (axisdesc = this.axisService.getParent().getParent()).getParameter("enableHTTP")) != null && "true".equals((value = parameter.getValue()).toString())) {
            this.generateHttp = true;
            this.generatePostBinding(fac, ele);
        }
        this.generateService(fac, ele);
        return ele;
    }

    private void generateMessages(OMFactory fac, OMElement defintions) {
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                this.writeMessage(inaxisMessage, fac, defintions);
                this.generateHeaderMessages(inaxisMessage, fac, defintions);
            }
            if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                this.writeMessage(outAxisMessage, fac, defintions);
                this.generateHeaderMessages(outAxisMessage, fac, defintions);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage axisMessage = (AxisMessage)faultyMessages.get(i);
                this.writeMessage(axisMessage, fac, defintions);
                this.generateHeaderMessages(axisMessage, fac, defintions);
            }
        }
    }

    private void generateHeaderMessages(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        ArrayList extList = axismessage.getSoapHeaders();
        for (int i = 0; i < extList.size(); ++i) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)extList.get(i);
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            defintions.addChild((OMNode)messageElement);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild((OMNode)messagePart);
            messagePart.addAttribute("name", "part1", null);
            messagePart.addAttribute("element", this.getPrefix(header.getElement().getNamespaceURI()) + ":" + header.getElement().getLocalPart(), null);
        }
    }

    private void writeMessage(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        QName scheamElementName = axismessage.getElementQName();
        OMElement messageElement = fac.createOMElement("message", this.wsdl);
        messageElement.addAttribute("name", axismessage.getName(), null);
        defintions.addChild((OMNode)messageElement);
        if (scheamElementName != null) {
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild((OMNode)messagePart);
            messagePart.addAttribute("name", "part1", null);
            messagePart.addAttribute("element", this.getPrefix(scheamElementName.getNamespaceURI()) + ":" + scheamElementName.getLocalPart(), null);
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) throws Exception {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild((OMNode)portType);
        portType.addAttribute("name", this.axisService.getName() + "PortType", null);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            portType.addChild((OMNode)operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicy(10, axisOperation.getPolicyInclude(), operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inaxisMessage.getName(), null);
                this.addPolicy(12, inaxisMessage.getPolicyInclude(), input, fac);
                operation.addChild((OMNode)input);
            }
            if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outAxisMessage.getName(), null);
                this.addPolicy(13, outAxisMessage.getPolicyInclude(), output, fac);
                operation.addChild((OMNode)output);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessge = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultyMessge.getName(), null);
                fault.addAttribute("name", faultyMessge.getName(), null);
                operation.addChild((OMNode)fault);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions) throws Exception {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild((OMNode)service);
        service.addAttribute("name", this.axisService.getName(), null);
        this.generateSOAP11Port(fac, service);
        this.generateSOAP12Port(fac, service);
        this.addPolicy(6, this.axisService.getPolicyInclude(), service, fac);
        if (this.generateHttp) {
            this.generateHTTPPort(fac, service);
        }
    }

    private void generateSOAP11Port(OMFactory fac, OMElement service) throws Exception {
        for (int i = 0; i < this.url.length; ++i) {
            String urlString = this.url[i];
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", this.axisService.getName() + "SOAP11port" + i, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "SOAP11Binding", null);
            this.addExtensionElemnet(fac, port, "address", "location", urlString, this.soap);
            this.addPolicy(7, this.axisService.getPolicyInclude(), service, fac);
        }
    }

    private void generateHTTPPort(OMFactory fac, OMElement service) throws Exception {
        for (int i = 0; i < this.url.length; ++i) {
            String urlString = this.url[i];
            if (!urlString.startsWith("http")) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", this.axisService.getName() + "Httpport" + i, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "HttpBinding", null);
            OMElement extElement = fac.createOMElement("address", this.http);
            port.addChild((OMNode)extElement);
            urlString = urlString.replaceAll("services", "rest");
            extElement.addAttribute("location", urlString, null);
        }
    }

    private void generateSOAP12Port(OMFactory fac, OMElement service) throws Exception {
        for (int i = 0; i < this.url.length; ++i) {
            String urlString = this.url[i];
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", this.axisService.getName() + "SOAP12port" + i, null);
            port.addAttribute("binding", this.tns.getPrefix() + ":" + this.axisService.getName() + "SOAP12Binding", null);
            this.addExtensionElemnet(fac, port, "address", "location", urlString, this.soap12);
            this.addPolicy(7, this.axisService.getPolicyInclude(), service, fac);
        }
    }

    private void generateSOAP11Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP11Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicy(9, this.axisService.getPolicyInclude(), binding, fac);
        this.addExtensionElemnet(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElemnet(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            this.addPolicy(11, axisOperation.getPolicyInclude(), operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElemnet(fac, input, "body", "use", this.use, "namespace", this.targetNamespace, this.soap);
                this.addPolicy(14, inaxisMessage.getPolicyInclude(), input, fac);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap);
            }
            if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElemnet(fac, output, "body", "use", this.use, "namespace", this.targetNamespace, this.soap);
                this.addPolicy(15, outAxisMessage.getPolicyInclude(), output, fac);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessge = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElemnet(fac, fault, "body", "use", this.use, "namespace", this.targetNamespace, this.soap);
                fault.addAttribute("name", faultyMessge.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessge, fac, fault, this.soap);
            }
        }
    }

    private void generateSOAP12Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP12Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicy(9, this.axisService.getPolicyInclude(), binding, fac);
        this.addExtensionElemnet(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElemnet(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            this.addPolicy(11, axisOperation.getPolicyInclude(), operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElemnet(fac, input, "body", "use", this.use, "namespace", this.targetNamespace, this.soap12);
                this.addPolicy(14, inaxisMessage.getPolicyInclude(), input, fac);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElemnet(fac, output, "body", "use", this.use, "namespace", this.targetNamespace, this.soap12);
                this.addPolicy(15, outAxisMessage.getPolicyInclude(), output, fac);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessge = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElemnet(fac, fault, "body", "use", this.use, "namespace", this.targetNamespace, this.soap12);
                fault.addAttribute("name", faultyMessge.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessge, fac, fault, this.soap12);
            }
        }
    }

    private void generatePostBinding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "HttpBinding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild((OMNode)httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild((OMNode)httpOperation);
            httpOperation.addAttribute("location", axisOperation.getName().getLocalPart(), null);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild((OMNode)inputelement);
                inputelement.addAttribute("type", "text/xml", null);
                operation.addChild((OMNode)input);
            }
            if (!"http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/in-out".equals(MEP) || (outAxisMessage = axisOperation.getMessage("Out")) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild((OMNode)outElement);
            outElement.addAttribute("type", "text/xml", null);
            output.addChild((OMNode)outElement);
            operation.addChild((OMNode)output);
        }
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws Exception {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            Iterator elements = extElementList.iterator();
            while (elements.hasNext()) {
                SOAPHeaderMessage soapheader = (SOAPHeaderMessage)elements.next();
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElemnet(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        soapbinding.addAttribute(att2Name, att2Value, null);
    }

    private void addExtensionElemnet(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)extElement);
        extElement.addAttribute(att1Name, att1Value, null);
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private OMElement getDefinitionElement() {
        return this.definition;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild((OMNode)extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", this.getPrefix(this.targetNamespace) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private String getPrefix(String targetNameSpace) {
        Map map = this.axisService.getNameSpacesMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!map.get(key).equals(targetNameSpace)) continue;
            return key;
        }
        return null;
    }

    private void addPolicy(int type, PolicyInclude policyInclude, OMElement element, OMFactory factory) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        StAXPolicyWriter pwrt = (StAXPolicyWriter)PolicyFactory.getPolicyWriter((int)2);
        Iterator iterator = elementList.iterator();
        while (iterator.hasNext()) {
            Object policyElement = iterator.next();
            if (policyElement instanceof Policy) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                pwrt.writePolicy((Policy)policyElement, (OutputStream)baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                element.addChild((OMNode)OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)factory, (XMLStreamReader)StAXUtils.createXMLStreamReader((InputStream)bais)).getDocumentElement());
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMNamespace ns = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMElement refElement = factory.createOMElement("PolicyReference", ns);
            String policyURIString = ((PolicyReference)policyElement).getPolicyURIString();
            OMAttribute attribute = factory.createOMAttribute("URI", null, policyURIString);
            refElement.addAttribute(attribute);
            element.addChild((OMNode)refElement);
            PolicyRegistry reg = policyInclude.getPolicyRegistry();
            Policy p = reg.lookup(policyURIString);
            if (p == null) {
                throw new Exception("Policy not found for uri : " + policyURIString);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pwrt.writePolicy(p, (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.getDefinitionElement().addChild((OMNode)OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)factory, (XMLStreamReader)StAXUtils.createXMLStreamReader((InputStream)bais)).getDocumentElement());
        }
    }
}

