/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSDL2AxisServiceBuilder {
    private static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String XMLSCHEMA_NAMESPACE_PREFIX = "xs";
    private static final String XML_SCHEMA_LOCAL_NAME = "schema";
    private static final String XML_SCHEMA_SEQUENCE_LOCAL_NAME = "sequence";
    private static final String XML_SCHEMA_COMPLEX_TYPE_LOCAL_NAME = "complexType";
    private static final String XML_SCHEMA_ELEMENT_LOCAL_NAME = "element";
    private static final String XML_SCHEMA_IMPORT_LOCAL_NAME = "import";
    private static final String XSD_NAME = "name";
    private static final String XSD_TARGETNAMESPACE = "targetNamespace";
    private static final String XMLNS_AXIS2WRAPPED = "xmlns:axis2wrapped";
    private static final String AXIS2WRAPPED = "axis2wrapped";
    private static final String XSD_TYPE = "type";
    private static final String XSD_REF = "ref";
    private static int nsCount = 0;
    private Map resolvedRpcWrappedElementMap = new HashMap();
    private static final String XSD_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    private static final String XSD_UNQUALIFIED = "unqualified";
    private InputStream in;
    private AxisService axisService;
    private PolicyRegistry registry;
    private QName serviceName;
    private String portName;
    private boolean isServerSide = true;
    private static final String BINDING = "Binding";
    private static final String SERVICE = "Service";
    private static final String PORT = "Port";
    private static final String PORT_TYPE = "PortType";
    private static final String TYPES = "Types";
    private static final String PORT_TYPE_OPERATION = "PortType.Operation";
    private static final String PORT_TYPE_OPERATION_INPUT = "PortType.Operation.Input";
    private static final String PORT_TYPE_OPERATION_OUTPUT = "PortType.Operation.Output";
    private static final String PORT_TYPE_OPERATION_FAULT = "PortType.Operation.Fault";
    private static final String BINDING_OPERATION = "Binding.Operation";
    private static final String BINDING_OPERATION_INPUT = "Binding.Operation.Input";
    private static final String BINDING_OPERATION_OUTPUT = "Binding.Operation.Output";
    private Definition wsdl4jDefinition = null;
    private String style = null;
    private URIResolver customResolver;
    private WSDLLocator customWSLD4JResolver;
    private String baseUri = null;

    public WSDL2AxisServiceBuilder(InputStream in, QName serviceName, String portName) {
        this.in = in;
        this.serviceName = serviceName;
        this.portName = portName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL2AxisServiceBuilder(Definition def, QName serviceName, String portName) {
        this.wsdl4jDefinition = def;
        this.serviceName = serviceName;
        this.portName = portName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL2AxisServiceBuilder(InputStream in, AxisService service) {
        this(in);
        this.axisService = service;
        this.setPolicyRegistryFromService(service);
    }

    public WSDL2AxisServiceBuilder(InputStream in) {
        this(in, null, null);
    }

    public void setCustomResolver(URIResolver customResolver) {
        this.customResolver = customResolver;
    }

    public void setCustomWSLD4JResolver(WSDLLocator customWSLD4JResolver) {
        this.customWSLD4JResolver = customWSLD4JResolver;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public void setServerSide(boolean serverSide) {
        this.isServerSide = serverSide;
    }

    public AxisService populateService() throws AxisFault {
        try {
            Binding binding;
            Element[] schemaElements;
            if (this.wsdl4jDefinition == null) {
                this.wsdl4jDefinition = this.readInTheWSDLFile(this.in);
            }
            Parameter wsdldefintionParamter = new Parameter();
            wsdldefintionParamter.setName("wsdl4jDefinition");
            wsdldefintionParamter.setValue(this.wsdl4jDefinition);
            this.axisService.addParameter(wsdldefintionParamter);
            if (this.wsdl4jDefinition == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.wsdl4jDefinition.getTargetNamespace());
            this.processPoliciesInDefintion(this.wsdl4jDefinition);
            this.processImports(this.wsdl4jDefinition);
            this.axisService.setNameSpacesMap(this.wsdl4jDefinition.getNamespaces());
            Types wsdl4jTypes = this.wsdl4jDefinition.getTypes();
            if (null != wsdl4jTypes) {
                this.copyExtensibleElements(wsdl4jTypes.getExtensibilityElements(), this.wsdl4jDefinition, this.axisService, TYPES);
            }
            if ((schemaElements = this.generateWrapperSchema(this.wsdl4jDefinition, binding = this.findBinding(this.wsdl4jDefinition))) != null && schemaElements.length > 0) {
                for (int i = 0; i < schemaElements.length; ++i) {
                    Element schemaElement = schemaElements[i];
                    if (schemaElement == null) continue;
                    this.axisService.addSchema(this.getXMLSchema(schemaElement, null));
                }
            }
            this.processBinding(binding, this.wsdl4jDefinition);
            return this.axisService;
        }
        catch (WSDLException e) {
            throw new AxisFault(e);
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    private void setPolicyRegistryFromService(AxisService axisService) {
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        this.registry = policyInclude.getPolicyRegistry();
    }

    /*
     * WARNING - void declaration
     */
    private Binding findBinding(Definition dif) throws AxisFault {
        void var3_5;
        Service service;
        Map services = dif.getServices();
        Binding binding = null;
        Port port = null;
        if (this.serviceName != null) {
            service = (Service)services.get(this.serviceName);
            if (service == null) {
                throw new AxisFault("Service not found the WSDL " + this.serviceName.getLocalPart());
            }
        } else if (services.size() > 0) {
            service = (Service)services.values().toArray()[0];
        } else {
            throw new AxisFault("No service element found in the WSDL");
        }
        this.copyExtensibleElements(var3_5.getExtensibilityElements(), dif, this.axisService, SERVICE);
        if (this.portName != null) {
            port = var3_5.getPort(this.portName);
            if (port == null) {
                throw new AxisFault("No port found for the given name :" + this.portName);
            }
        } else {
            Map ports = var3_5.getPorts();
            if (ports != null && ports.size() > 0) {
                port = (Port)ports.values().toArray()[0];
            }
        }
        this.axisService.setName(var3_5.getQName().getLocalPart());
        if (port != null) {
            this.copyExtensibleElements(port.getExtensibilityElements(), dif, this.axisService, PORT);
            binding = port.getBinding();
        }
        return binding;
    }

    private void processBinding(Binding binding, Definition dif) throws Exception {
        if (binding != null) {
            this.copyExtensibleElements(binding.getExtensibilityElements(), this.wsdl4jDefinition, this.axisService, BINDING);
            PortType portType = binding.getPortType();
            this.processPortType(portType, dif);
            List list = binding.getBindingOperations();
            this.copyExtensibleElements(binding.getExtensibilityElements(), dif, this.axisService, BINDING);
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation wsdl4jBindingOperation = (BindingOperation)list.get(i);
                AxisOperation operation = this.axisService.getOperation(new QName(wsdl4jBindingOperation.getName()));
                this.copyExtensibleElements(wsdl4jBindingOperation.getExtensibilityElements(), dif, operation, BINDING_OPERATION);
                BindingInput bindingInput = wsdl4jBindingOperation.getBindingInput();
                BindingOutput bindingOutput = wsdl4jBindingOperation.getBindingOutput();
                String MEP = operation.getMessageExchangePattern();
                if (bindingInput != null && ("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP))) {
                    AxisMessage inMessage = operation.getMessage("In");
                    this.copyExtensibleElements(bindingInput.getExtensibilityElements(), dif, inMessage, BINDING_OPERATION_INPUT);
                }
                if (bindingOutput == null || !"http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) && !"http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) continue;
                AxisMessage outAxisMessage = operation.getMessage("Out");
                this.copyExtensibleElements(bindingOutput.getExtensibilityElements(), dif, outAxisMessage, BINDING_OPERATION_OUTPUT);
            }
        }
    }

    private void processPortType(PortType wsdl4jPortType, Definition dif) throws Exception {
        this.copyExtensionAttributes(wsdl4jPortType.getExtensionAttributes(), dif, this.axisService, PORT_TYPE);
        Iterator wsdl4JOperationsIterator = wsdl4jPortType.getOperations().iterator();
        while (wsdl4JOperationsIterator.hasNext()) {
            Operation wsdl4jOperation = (Operation)wsdl4JOperationsIterator.next();
            this.axisService.addOperation(this.populateOperations(wsdl4jOperation, dif));
        }
    }

    private AxisOperation populateOperations(Operation wsdl4jOperation, Definition dif) throws Exception {
        Message message;
        AxisMessage outMessage;
        Output wsdl4jOutputMessage;
        Message message2;
        AxisMessage inMessage;
        QName opName = new QName(wsdl4jOperation.getName());
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP = this.getMEP(wsdl4jOperation);
            axisOperation = AxisOperationFactory.getOperationDescription(MEP);
            axisOperation.setName(opName);
            PolicyInclude pi = axisOperation.getPolicyInclude();
            if (pi == null) {
                pi = new PolicyInclude();
                axisOperation.setPolicyInclude(pi);
            }
            pi.setPolicyRegistry(this.registry);
        }
        if (this.style != null) {
            axisOperation.setStyle(this.style);
        }
        this.copyExtensibleElements(wsdl4jOperation.getExtensibilityElements(), dif, axisOperation, PORT_TYPE_OPERATION);
        Input wsdl4jInputMessage = wsdl4jOperation.getInput();
        QName wrappedInputName = axisOperation.getName();
        QName wrappedOutputName = new QName(wrappedInputName.getNamespaceURI(), wrappedInputName.getLocalPart() + "Response", wrappedInputName.getPrefix());
        if (this.isServerSide) {
            if (null != wsdl4jInputMessage) {
                inMessage = axisOperation.getMessage("In");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setElementQName(this.generateReferenceQname(wrappedInputName, message2, this.findWrapppable(message2)));
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_INPUT);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("Out");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setElementQName(this.generateReferenceQname(wrappedOutputName, message, this.findWrapppable(message)));
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
            }
        } else {
            if (null != wsdl4jInputMessage) {
                inMessage = axisOperation.getMessage("Out");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setElementQName(this.generateReferenceQname(wrappedInputName, message2, this.findWrapppable(message2)));
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensibleElements(message2.getExtensibilityElements(), dif, inMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("In");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setElementQName(this.generateReferenceQname(wrappedOutputName, message, this.findWrapppable(message)));
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensibleElements(message.getExtensibilityElements(), dif, outMessage, PORT_TYPE_OPERATION_INPUT);
                }
            }
        }
        Map faults = wsdl4jOperation.getFaults();
        Iterator faultKeyIterator = faults.keySet().iterator();
        while (faultKeyIterator.hasNext()) {
            Fault fault = (Fault)faults.get(faultKeyIterator.next());
            AxisMessage faultyMessge = new AxisMessage();
            Message faultMessage = fault.getMessage();
            if (null != faultMessage) {
                faultyMessge.setElementQName(this.generateReferenceQname(faultMessage.getQName(), faultMessage, this.findWrapppable(faultMessage)));
                this.copyExtensibleElements(faultMessage.getExtensibilityElements(), dif, faultyMessge, PORT_TYPE_OPERATION_FAULT);
                faultyMessge.setName(faultMessage.getQName().getLocalPart());
            }
            axisOperation.setFaultMessages(faultyMessge);
        }
        return axisOperation;
    }

    private QName generateReferenceQname(QName outerName, Message wsdl4jMessage, boolean isWrappable) {
        QName referenceQName = null;
        if (isWrappable) {
            referenceQName = (QName)this.resolvedRpcWrappedElementMap.get(outerName.getLocalPart());
        } else {
            Iterator outputIterator = wsdl4jMessage.getParts().values().iterator();
            if (outputIterator.hasNext()) {
                Part outPart = (Part)outputIterator.next();
                QName typeName = outPart.getTypeName();
                referenceQName = null != typeName ? typeName : outPart.getElementName();
            }
        }
        return referenceQName;
    }

    private Element[] generateWrapperSchema(Definition wsdl4jDefinition, Binding binding) {
        ArrayList<Element> schemaElementList = new ArrayList<Element>();
        String targetNamespaceUri = wsdl4jDefinition.getTargetNamespace();
        schemaElementList.add(this.createSchemaForPorttype(binding.getPortType(), targetNamespaceUri, this.findWrapForceable(binding)));
        return schemaElementList.toArray(new Element[schemaElementList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private Element createSchemaForPorttype(PortType porttype, String targetNamespaceUri, boolean forceWrapping) {
        String typeValue;
        QName[] keys;
        HashMap<QName, Message> messagesMap = new HashMap<QName, Message>();
        HashMap<String, Message> inputOperationsMap = new HashMap<String, Message>();
        HashMap<String, Message> outputOperationsMap = new HashMap<String, Message>();
        HashMap faultyOperationsMap = new HashMap();
        HashMap<String, Element> namespaceImportsMap = new HashMap<String, Element>();
        HashMap<QName, Element> complexTypeElementsMap = new HashMap<QName, Element>();
        ArrayList<Element> elementElementsList = new ArrayList<Element>();
        HashMap<String, String> namespacePrefixMap = new HashMap<String, String>();
        List operations = porttype.getOperations();
        for (int k = 0; k < operations.size(); ++k) {
            Map faultMap;
            Output output;
            Message message;
            Operation op = (Operation)operations.get(k);
            Input input = op.getInput();
            if (input != null) {
                message = input.getMessage();
                messagesMap.put(message.getQName(), message);
                inputOperationsMap.put(op.getName(), message);
            }
            if ((output = op.getOutput()) != null) {
                message = output.getMessage();
                messagesMap.put(message.getQName(), message);
                outputOperationsMap.put(op.getName(), message);
            }
            if ((faultMap = op.getFaults()) == null || faultMap.size() <= 0) continue;
            Iterator keys2 = faultMap.keySet().iterator();
            while (keys2.hasNext()) {
                Object key = keys2.next();
                Fault fault = (Fault)faultMap.get(key);
                if (fault == null) continue;
                message = fault.getMessage();
                messagesMap.put(message.getQName(), message);
                faultyOperationsMap.put(key, message);
            }
        }
        if (forceWrapping) {
            keys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
        } else {
            QName[] allKeys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
            ArrayList<QName> wrappableMessageNames = new ArrayList<QName>();
            boolean noMessagesTobeProcessed = true;
            for (int i = 0; i < allKeys.length; ++i) {
                if (!this.findWrapppable((Message)messagesMap.get(allKeys[i]))) continue;
                noMessagesTobeProcessed = false;
                wrappableMessageNames.add(allKeys[i]);
            }
            if (noMessagesTobeProcessed) {
                return null;
            }
            keys = wrappableMessageNames.toArray(new QName[wrappableMessageNames.size()]);
        }
        ArrayList<QName> resolvedMessageQNames = new ArrayList<QName>();
        String xsdPrefix = this.findSchemaPrefix();
        Document document = this.getDOMDocumentBuilder().newDocument();
        for (int i = 0; i < keys.length; ++i) {
            Message wsdl4jMessage = (Message)messagesMap.get(keys[i]);
            if (resolvedMessageQNames.contains(wsdl4jMessage.getQName())) continue;
            Map parts = wsdl4jMessage.getParts();
            String name = wsdl4jMessage.getQName().getLocalPart();
            Element newComplexType = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_COMPLEX_TYPE_LOCAL_NAME);
            newComplexType.setAttribute(XSD_NAME, name);
            Element cmplxContentSequence = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_SEQUENCE_LOCAL_NAME);
            Iterator iterator = parts.keySet().iterator();
            while (iterator.hasNext()) {
                String prefix;
                void var29_50;
                QName schemaTypeName;
                Part part = (Part)parts.get(iterator.next());
                String elementName = part.getName();
                boolean isTyped = true;
                if (part.getTypeName() != null) {
                    schemaTypeName = part.getTypeName();
                } else if (part.getElementName() != null) {
                    schemaTypeName = part.getElementName();
                    isTyped = false;
                } else {
                    throw new RuntimeException(" Unqualified Message part!");
                }
                Element child = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
                if (XMLSCHEMA_NAMESPACE_URI.equals(var29_50.getNamespaceURI())) {
                    prefix = xsdPrefix;
                } else {
                    String uri = var29_50.getNamespaceURI();
                    if (!namespaceImportsMap.containsKey(uri)) {
                        Element namespaceImport = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_IMPORT_LOCAL_NAME);
                        namespaceImport.setAttribute("namespace", uri);
                        namespaceImportsMap.put(uri, namespaceImport);
                        prefix = this.getTemporaryNamespacePrefix();
                        namespacePrefixMap.put(uri, prefix);
                    } else {
                        prefix = (String)namespacePrefixMap.get(uri);
                    }
                }
                if (isTyped) {
                    child.setAttribute(XSD_NAME, elementName);
                    child.setAttribute(XSD_TYPE, prefix + ":" + var29_50.getLocalPart());
                } else {
                    child.setAttribute(XSD_REF, prefix + ":" + var29_50.getLocalPart());
                }
                cmplxContentSequence.appendChild(child);
            }
            newComplexType.appendChild(cmplxContentSequence);
            complexTypeElementsMap.put(wsdl4jMessage.getQName(), newComplexType);
            resolvedMessageQNames.add(wsdl4jMessage.getQName());
        }
        String[] inputOperationtNames = inputOperationsMap.keySet().toArray(new String[inputOperationsMap.size()]);
        for (int j = 0; j < inputOperationtNames.length; ++j) {
            String inputOpName = inputOperationtNames[j];
            Element elementDeclaration = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
            elementDeclaration.setAttribute(XSD_NAME, inputOpName);
            String typeValue2 = ((Message)inputOperationsMap.get(inputOpName)).getQName().getLocalPart();
            elementDeclaration.setAttribute(XSD_TYPE, "axis2wrapped:" + typeValue2);
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(inputOpName, new QName(targetNamespaceUri, inputOpName, AXIS2WRAPPED));
        }
        String[] outputOperationtNames = outputOperationsMap.keySet().toArray(new String[outputOperationsMap.size()]);
        for (int j = 0; j < outputOperationtNames.length; ++j) {
            String baseoutputOpName = outputOperationtNames[j];
            String outputOpName = baseoutputOpName + "Response";
            Element elementDeclaration = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
            elementDeclaration.setAttribute(XSD_NAME, outputOpName);
            typeValue = ((Message)outputOperationsMap.get(baseoutputOpName)).getQName().getLocalPart();
            elementDeclaration.setAttribute(XSD_TYPE, "axis2wrapped:" + typeValue);
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(outputOpName, new QName(targetNamespaceUri, outputOpName, AXIS2WRAPPED));
        }
        String[] faultyOperationtNames = faultyOperationsMap.keySet().toArray(new String[faultyOperationsMap.size()]);
        for (int j = 0; j < faultyOperationtNames.length; ++j) {
            String baseFaultOpName = faultyOperationtNames[j];
            Element elementDeclaration = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
            elementDeclaration.setAttribute(XSD_NAME, baseFaultOpName);
            typeValue = ((Message)faultyOperationsMap.get(baseFaultOpName)).getQName().getLocalPart();
            elementDeclaration.setAttribute(XSD_TYPE, "axis2wrapped:" + typeValue);
            elementElementsList.add(elementDeclaration);
            this.resolvedRpcWrappedElementMap.put(baseFaultOpName, new QName(targetNamespaceUri, baseFaultOpName, AXIS2WRAPPED));
        }
        Element schemaElement = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_LOCAL_NAME);
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespacePrefixMap.get(s).toString(), s);
        }
        schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_AXIS2WRAPPED, targetNamespaceUri);
        schemaElement.setAttribute(XSD_TARGETNAMESPACE, targetNamespaceUri);
        schemaElement.setAttribute(XSD_ELEMENT_FORM_DEFAULT, XSD_UNQUALIFIED);
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            schemaElement.appendChild(namespaceImports[i]);
        }
        Element[] complexTypeElements = complexTypeElementsMap.values().toArray(new Element[complexTypeElementsMap.size()]);
        for (int i = 0; i < complexTypeElements.length; ++i) {
            schemaElement.appendChild(complexTypeElements[i]);
        }
        Element[] elementDeclarations = elementElementsList.toArray(new Element[elementElementsList.size()]);
        for (int i = 0; i < elementDeclarations.length; ++i) {
            schemaElement.appendChild(elementDeclarations[i]);
        }
        return schemaElement;
    }

    private void processImports(Definition wsdl4JDefinition) {
        Map wsdlImports = wsdl4JDefinition.getImports();
        if (null != wsdlImports && !wsdlImports.isEmpty()) {
            Collection importsCollection = wsdlImports.values();
            Iterator iterator = importsCollection.iterator();
            while (iterator.hasNext()) {
                Vector values = (Vector)iterator.next();
                for (int i = 0; i < values.size(); ++i) {
                    Definition importedDef;
                    Import wsdlImport = (Import)values.elementAt(i);
                    if (wsdlImport.getDefinition() == null || (importedDef = wsdlImport.getDefinition()) == null) continue;
                    this.processImports(importedDef);
                    Map namespaces = importedDef.getNamespaces();
                    Iterator keys = namespaces.keySet().iterator();
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        if (this.wsdl4jDefinition.getNamespaces().containsValue(namespaces.get(key))) continue;
                        this.wsdl4jDefinition.getNamespaces().put(key, namespaces.get(key));
                    }
                    this.wsdl4jDefinition.getNamespaces().putAll(namespaces);
                    Types t = importedDef.getTypes();
                    List typesList = t.getExtensibilityElements();
                    for (int j = 0; j < typesList.size(); ++j) {
                        Types types = wsdl4JDefinition.getTypes();
                        if (types == null) {
                            types = wsdl4JDefinition.createTypes();
                            wsdl4JDefinition.setTypes(types);
                        }
                        types.addExtensibilityElement((ExtensibilityElement)typesList.get(j));
                    }
                    Map messagesMap = importedDef.getMessages();
                    wsdl4JDefinition.getMessages().putAll(messagesMap);
                    Map porttypeMap = importedDef.getPortTypes();
                    wsdl4JDefinition.getPortTypes().putAll(porttypeMap);
                    Map bindingMap = importedDef.getBindings();
                    wsdl4JDefinition.getBindings().putAll(bindingMap);
                }
            }
        }
    }

    private XmlSchema getXMLSchema(Element element, String baseUri) {
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        Map nsMap = this.axisService.getNameSpacesMap();
        Iterator keys = nsMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            schemaCollection.mapNamespace(key, (String)nsMap.get(key));
        }
        if (baseUri != null) {
            schemaCollection.setBaseUri(baseUri);
        }
        if (this.customResolver != null) {
            schemaCollection.setSchemaResolver(this.customResolver);
        }
        return schemaCollection.read(element);
    }

    private Definition readInTheWSDLFile(InputStream in) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        if (this.customWSLD4JResolver != null) {
            return reader.readWSDL(this.customWSLD4JResolver);
        }
        reader.setFeature("javax.wsdl.importDocuments", false);
        reader.setFeature("javax.wsdl.verbose", false);
        try {
            doc = XMLUtils.newDocument(in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(this.getBaseUri(), doc);
    }

    private void copyExtensibleElements(List wsdl4jExtensibleElements, Definition wsdl4jDefinition, AxisDescription description, String originOfExtensibilityElements) {
        Iterator iterator = wsdl4jExtensibleElements.iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement wsdl4jElement = (ExtensibilityElement)iterator.next();
            if (wsdl4jElement instanceof UnknownExtensibilityElement) {
                DOMPolicyReader policyReader;
                UnknownExtensibilityElement unknown = (UnknownExtensibilityElement)wsdl4jElement;
                if (WSDLConstants.SOAP_12_OPERATION.equals(unknown.getElementType())) {
                    Element element = unknown.getElement();
                    if (!(description instanceof AxisOperation)) continue;
                    AxisOperation axisOperation = (AxisOperation)description;
                    String style = element.getAttribute("style");
                    if (style != null) {
                        axisOperation.setStyle(style);
                    }
                    axisOperation.setSoapAction(element.getAttribute("soapAction"));
                    continue;
                }
                if (WSDLConstants.SOAP_12_HEADER.equals(unknown.getElementType())) continue;
                if (WSDLConstants.SOAP_12_BINDING.equals(unknown.getElementType())) {
                    this.style = unknown.getElement().getAttribute("style");
                    this.axisService.setSoapNsUri(wsdl4jElement.getElementType().getNamespaceURI());
                    continue;
                }
                if (WSDLConstants.SOAP_12_ADDRESS.equals(unknown.getElementType())) {
                    this.axisService.setEndpoint(unknown.getElement().getAttribute("location"));
                    continue;
                }
                if (WSDLConstants.POLICY.equals(unknown.getElementType())) {
                    policyReader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
                    Policy policy = policyReader.readPolicy(unknown.getElement());
                    this.addPolicy(description, originOfExtensibilityElements, policy);
                    continue;
                }
                if (!WSDLConstants.POLICY_REFERENCE.equals(unknown.getElementType())) continue;
                policyReader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
                PolicyReference policyRef = policyReader.readPolicyReference(unknown.getElement());
                this.addPolicyRef(description, originOfExtensibilityElements, policyRef);
                continue;
            }
            if (wsdl4jElement instanceof SOAPAddress) {
                SOAPAddress soapAddress = (SOAPAddress)wsdl4jElement;
                this.axisService.setEndpoint(soapAddress.getLocationURI());
                continue;
            }
            if (wsdl4jElement instanceof Schema) {
                Schema schema = (Schema)wsdl4jElement;
                this.axisService.addSchema(this.getXMLSchema(schema.getElement(), wsdl4jDefinition.getDocumentBaseURI()));
                continue;
            }
            if (SOAPConstants.Q_ELEM_SOAP_OPERATION.equals(wsdl4jElement.getElementType())) {
                SOAPOperation soapOperation = (SOAPOperation)wsdl4jElement;
                if (!(description instanceof AxisOperation)) continue;
                AxisOperation axisOperation = (AxisOperation)description;
                if (soapOperation.getStyle() != null) {
                    axisOperation.setStyle(soapOperation.getStyle());
                }
                axisOperation.setSoapAction(soapOperation.getSoapActionURI());
                continue;
            }
            if (SOAPConstants.Q_ELEM_SOAP_HEADER.equals(wsdl4jElement.getElementType())) {
                SOAPHeader soapHeader = (SOAPHeader)wsdl4jElement;
                SOAPHeaderMessage headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                Boolean required = soapHeader.getRequired();
                if (null != required) {
                    headerMessage.setRequired(required);
                }
                if (null != wsdl4jDefinition) {
                    Message msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    Part msgPart = msg.getPart(soapHeader.getPart());
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisMessage)) continue;
                ((AxisMessage)description).addSopaHeader(headerMessage);
                continue;
            }
            if (!SOAPConstants.Q_ELEM_SOAP_BINDING.equals(wsdl4jElement.getElementType())) continue;
            SOAPBinding soapBinding = (SOAPBinding)wsdl4jElement;
            this.style = soapBinding.getStyle();
            this.axisService.setSoapNsUri(soapBinding.getElementType().getNamespaceURI());
        }
    }

    private void addPolicy(AxisDescription description, String originOfExtensibilityElements, Policy policy) {
        if (description instanceof AxisService) {
            if (SERVICE.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(6, policy);
            } else if (PORT.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(7, policy);
            } else if (BINDING.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(9, policy);
            }
        } else if (description instanceof AxisOperation) {
            if (PORT_TYPE_OPERATION.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyElement(10, policy);
            } else {
                description.getPolicyInclude().addPolicyElement(9, policy);
            }
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(12, policy);
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(14, policy);
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(13, policy);
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyElement(15, policy);
        }
    }

    private void addPolicyRef(AxisDescription description, String originOfExtensibilityElements, PolicyReference policyRefElement) {
        if (description instanceof AxisService) {
            if (SERVICE.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(6, policyRefElement);
            } else if (PORT.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(7, policyRefElement);
            } else if (BINDING.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(9, policyRefElement);
            }
        } else if (description instanceof AxisOperation) {
            if (PORT_TYPE_OPERATION.equals(originOfExtensibilityElements)) {
                description.getPolicyInclude().addPolicyRefElement(10, policyRefElement);
            } else {
                description.getPolicyInclude().addPolicyRefElement(9, policyRefElement);
            }
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(12, policyRefElement);
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(14, policyRefElement);
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(13, policyRefElement);
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            description.getPolicyInclude().addPolicyRefElement(15, policyRefElement);
        }
    }

    private boolean findWrapForceable(Binding binding) {
        List extElements = binding.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            SOAPBinding soapBinding;
            if (!(extElements.get(i) instanceof SOAPBinding) || !"rpc".equals((soapBinding = (SOAPBinding)extElements.get(i)).getStyle())) continue;
            return true;
        }
        return false;
    }

    private boolean findWrapppable(Message message) {
        boolean wrappable;
        Map partsMap = message.getParts();
        Iterator parts = partsMap.values().iterator();
        boolean bl = wrappable = partsMap.size() > 1;
        while (!wrappable && parts.hasNext()) {
            Part part = (Part)parts.next();
            wrappable = part.getTypeName() != null || wrappable;
        }
        return wrappable;
    }

    private String findSchemaPrefix() {
        String xsdPrefix = null;
        Map declaredNameSpaces = this.axisService.getNameSpacesMap();
        if (declaredNameSpaces.containsValue(XMLSCHEMA_NAMESPACE_URI)) {
            Iterator it = declaredNameSpaces.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!XMLSCHEMA_NAMESPACE_URI.equals(declaredNameSpaces.get(key))) continue;
                xsdPrefix = key;
                break;
            }
        } else {
            xsdPrefix = XMLSCHEMA_NAMESPACE_PREFIX;
        }
        return xsdPrefix;
    }

    private DocumentBuilder getDOMDocumentBuilder() {
        DocumentBuilder documentBuilder;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return documentBuilder;
    }

    private String getTemporaryNamespacePrefix() {
        return "ns" + nsCount++;
    }

    private String getMEP(Operation operation) throws Exception {
        OperationType operationType = operation.getStyle();
        if (this.isServerSide) {
            if (null != operationType) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    return "http://www.w3.org/2004/08/wsdl/in-out";
                }
                if (operationType.equals(OperationType.ONE_WAY)) {
                    return "http://www.w3.org/2004/08/wsdl/in-only";
                }
                if (operationType.equals(OperationType.NOTIFICATION)) {
                    return "http://www.w3.org/2004/08/wsdl/out-only";
                }
                if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    return "http://www.w3.org/2004/08/wsdl/out-in";
                }
                throw new Exception("Cannot Determine the MEP");
            }
        } else if (null != operationType) {
            if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                return "http://www.w3.org/2004/08/wsdl/out-in";
            }
            if (operationType.equals(OperationType.ONE_WAY)) {
                return "http://www.w3.org/2004/08/wsdl/out-only";
            }
            if (operationType.equals(OperationType.NOTIFICATION)) {
                return "http://www.w3.org/2004/08/wsdl/in-only";
            }
            if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                return "http://www.w3.org/2004/08/wsdl/in-out";
            }
            throw new Exception("Cannot Determine the MEP");
        }
        throw new Exception("Cannot Determine the MEP");
    }

    private void copyExtensionAttributes(Map extAttributes, Definition definition, AxisDescription description, String origin) {
        Iterator iterator = extAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            QName value;
            String policyURIs;
            QName key = (QName)iterator.next();
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(key.getNamespaceURI()) || !"PolicyURIs".equals(key.getLocalPart()) || (policyURIs = (value = (QName)extAttributes.get(key)).getLocalPart()).length() == 0) continue;
            String[] uris = policyURIs.split(" ");
            for (int i = 0; i < uris.length; ++i) {
                PolicyReference ref = new PolicyReference(uris[i]);
                if (!PORT_TYPE.equals(origin)) continue;
                PolicyInclude include = description.getPolicyInclude();
                include.addPolicyRefElement(8, ref);
            }
        }
    }

    private void processPoliciesInDefintion(Definition definition) {
        List extElements = definition.getExtensibilityElements();
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            UnknownExtensibilityElement unknown;
            ExtensibilityElement extElement = (ExtensibilityElement)iterator.next();
            if (!(extElement instanceof UnknownExtensibilityElement) || !WSDLConstants.POLICY.equals((unknown = (UnknownExtensibilityElement)extElement).getElementType())) continue;
            DOMPolicyReader policyReader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
            Policy policy = policyReader.readPolicy(unknown.getElement());
            this.registry.register(policy.getPolicyURI(), policy);
        }
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }
}

