/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPWorker;
import org.apache.axis2.transport.http.server.SimpleHttpServer;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.util.OptionsParser;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHTTPServer
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)SimpleHTTPServer.class);
    SimpleHttpServer embedded = null;
    int port = -1;
    private ThreadFactory threadPool = null;
    public static int DEFAULT_PORT = 8080;
    private String hostAddress = null;
    protected ConfigurationContext configurationContext;

    public SimpleHTTPServer() {
    }

    public SimpleHTTPServer(ConfigurationContext systemContext, int port) throws AxisFault {
        this(systemContext, port, null);
    }

    public SimpleHTTPServer(ConfigurationContext systemContext, int port, ThreadFactory pool) throws AxisFault {
        this.configurationContext = systemContext;
        if (pool == null) {
            pool = this.configurationContext.getThreadPool();
        } else {
            this.configurationContext.setThreadPool(pool);
        }
        this.port = port;
        this.threadPool = pool;
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        TransportInDescription trsIn = new TransportInDescription(new QName("http"));
        trsIn.setReceiver(this);
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
            listenerManager.init(this.configurationContext);
        }
        listenerManager.addListener(trsIn, true);
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        try {
            this.configurationContext = axisConf;
            Parameter param = transprtIn.getParameter("port");
            if (param != null) {
                this.port = Integer.parseInt((String)param.getValue());
            }
            if ((param = transprtIn.getParameter("hostname")) != null) {
                this.hostAddress = ((String)param.getValue()).trim();
            }
        }
        catch (Exception e1) {
            throw new AxisFault(e1);
        }
    }

    public static void main(String[] args) throws Exception {
        String paramPort;
        int port = DEFAULT_PORT;
        OptionsParser optionsParser = new OptionsParser(args);
        args = optionsParser.getRemainingArgs();
        if (optionsParser.isFlagSet('?') > 0 || optionsParser.isFlagSet('h') > 0 || args == null || args.length == 0 || args.length > 2) {
            SimpleHTTPServer.printUsage();
        }
        if ((paramPort = optionsParser.isValueSet('p')) != null) {
            port = Integer.parseInt(paramPort);
        }
        args = optionsParser.getRemainingArgs();
        System.out.println("[SimpleHTTPServer] Starting");
        System.out.println("[SimpleHTTPServer] Using the Axis2 Repository " + new File(args[0]).getAbsolutePath());
        System.out.println("[SimpleHTTPServer] Listening on port " + port);
        try {
            SimpleHTTPServer receiver = new SimpleHTTPServer(ConfigurationContextFactory.createConfigurationContextFromFileSystem(args[0], null), port, null);
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(receiver));
            receiver.start();
            System.out.println("[SimpleHTTPServer] Started");
        }
        catch (Throwable t) {
            log.fatal((Object)"Error starting SimpleHTTPServer", t);
            System.out.println("[SimpleHTTPServer] Shutting down");
        }
    }

    public static void printUsage() {
        System.out.println("Usage: SimpleHTTPServer [options] <repository>");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -p port to listen on (default is 8080)");
        System.exit(1);
    }

    public void start() throws AxisFault {
        try {
            this.embedded = new SimpleHttpServer(this.port, this.threadPool);
            this.embedded.setRequestHandler(new HTTPWorker(this.configurationContext));
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new AxisFault(e);
        }
    }

    public void stop() {
        System.out.println("[SimpleHTTPServer] Stop called");
        if (this.embedded != null) {
            this.embedded.destroy();
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    /*
     * WARNING - void declaration
     */
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        String localAddress;
        if (this.hostAddress != null) {
            if (this.embedded != null) {
                return new EndpointReference(this.hostAddress + "/axis2/services/" + serviceName);
            }
            throw new AxisFault("Unable to generate EPR for the transport : http");
        }
        if (ip != null) {
            localAddress = ip;
        } else {
            try {
                localAddress = SimpleHttpServerConnection.getIpAddress();
            }
            catch (SocketException e) {
                throw AxisFault.makeFault(e);
            }
        }
        if (this.embedded != null) {
            void var3_3;
            return new EndpointReference("http://" + (String)var3_3 + ":" + this.embedded.getLocalPort() + "/axis2/services/" + serviceName);
        }
        throw new AxisFault("Unable to generate EPR for the transport : http");
    }

    public boolean isRunning() {
        if (this.embedded == null) {
            return false;
        }
        return this.embedded.isRunning();
    }

    static class ShutdownThread
    extends Thread {
        private SimpleHTTPServer server = null;

        public ShutdownThread(SimpleHTTPServer server) {
            this.server = server;
        }

        public void run() {
            System.out.println("[SimpleHTTPServer] Shutting down");
            this.server.stop();
            System.out.println("[SimpleHTTPServer] Shutdown complete");
        }
    }
}

